'*===================================*
'*                                   *
'* Music Quest Programmer's ToolKit *
'* Example utility program           *
'*                                   *
'*===================================*
'*                                   *
'* Copyright (c) 1988, 1990          *
'* Music Quest, Inc.                 *
'*                                   *
'* Updates                           *
'*                                   *
'* PR111 02/15/88                    *
'*       04/07/90 added auto-IRQ     *
'*                                   *
'*===================================*

DEFINT A-Z

' $INCLUDE: 'mcc.cst'
' $INCLUDE: 'mcc.inc'
DECLARE SUB initrecplay ()
DECLARE SUB recordtrack ()
DECLARE SUB playtrack ()
DECLARE SUB hextrace ()
DECLARE SUB tkitrace ()
DECLARE SUB progchange ()
DECLARE SUB showspp ()
DECLARE SUB showsmpte ()
DECLARE SUB cuepoint ()
DECLARE SUB writesmpte ()

CLS

irq% = mccirq(&H330)                     ' look for IRQ
IF irq% = 0 THEN
  PRINT CHR$(10); "Unable to find MIDI interface IRQ"; CHR$(10)
  STOP
END IF
IF mccopen(&H330, irq%) = 0 THEN        ' open MCC for use
  PRINT CHR$(10); "Unable to open MIDI interface"; CHR$(10)
  STOP
END IF

contflag = 1                            ' set to keep running
DO
  mccsetnoslih                          ' establish no-op SLIH
  ' Display utility menu
  LOCATE 1, 1
  PRINT "Music Quest Programmer's ToolKit - Quick Basic Version"
  PRINT "Copyright 1988, 1990"
  PRINT "Music Quest, Inc."; CHR$(10); CHR$(10)
  PRINT "ToolKit Utility Menu"
  PRINT "1  = Hex MIDI trace"
  PRINT "2  = Interpreted MIDI trace"
  PRINT "3  = Send program change command"
  PRINT "4  = Record MIDI data"
  PRINT "5  = Play back recorded MIDI data"
  PRINT "6  = Chase Lock - Song Position Pointer trace"
  PRINT "7  = SMPTE frame trace"
  PRINT "8  = SMPTE Cue Point"
  PRINT "9  = Write SMPTE sync track"
  PRINT "x  = Exit"; CHR$(10)
  INPUT "Selection? ", choice$

  SELECT CASE choice$
      CASE "1"                          ' trace
        hextrace
        CLS
      CASE "2"                          ' interpreted trace
        tkitrace
        CLS
      CASE "3"                          ' program change
        progchange
        CLS
      CASE "4"                          ' record
        recordtrack
        CLS
      CASE "5"                          ' play
        playtrack
        CLS
      CASE "6"                          ' CLS - SPP
        showspp
        CLS
      CASE "7"                          ' SMPTE display
        showsmpte
        CLS
      CASE "8"                          ' cue point
        cuepoint
        CLS
      CASE "9"                          ' write smpte track
        writesmpte
        CLS
      CASE "x", "X"                     ' exit
        CLS
        PRINT CHR$(10); "Resetting interface...."
        contflag = 0
      CASE ELSE
        PRINT CHR$(10); "Incorrect selection, try another."
  END SELECT
LOOP WHILE contflag

mccclose                                ' close MCC
END

'*===================================*
'*                                   *
'* Hex trace                         *
'*                                   *
'*===================================*
SUB hextrace

  CLS
  PRINT "Press any key to end trace"
  rc% = mcccommand(UART.MODE)           ' put MCC into pass-thru mode
  mccsetreceiveslih                     ' establish generic SLIH

  DO                                    ' until some key is hit
    byte = mccget                       ' see if a byte is ready
    IF byte >= 0 THEN                   ' if so, display
      x$ = HEX$(byte)
      IF LEN(x$) = 1 THEN               ' make two digit hex
        x$ = "0" + x$
      END IF
      PRINT x$; "  ";
    END IF
  LOOP WHILE INKEY$ = ""

  mccsetnoslih                          ' establish no-op SLIH
  mccflush                              ' clear any residual data
  mccreset
END SUB

'*===================================*
'*                                   *
'* Program change command            *
'*                                   *
'*===================================*
SUB progchange
  rc% = mcccommand(UART.MODE)           ' put MCC into pass-thru mode
  prognum = 0
  chan = 0
  INPUT "Enter channel number (1-16) and program number (1-128) => ", chan, prognum
  IF (prognum > 0) AND (prognum <= 128) AND (chan > 0) AND (chan <= 16) THEN
      mccput (&HC0 + (chan - 1))        ' send program change status
      mccput (prognum - 1)              ' send progrma number
  ELSE
      PRINT "Invalid values"
  END IF
  t0! = TIMER + 1
  DO                                    'wait for data to be sent PR111
  LOOP WHILE t0! > TIMER
  mccreset
END SUB

