/*===================================*/
/*                                   */
/* Music Quest Programmer's ToolKit  */
/* Example utility program           */
/*                                   */
/*===================================*/
/*                                   */
/* Copyright 1988, 1990              */
/* Music Quest, Inc.                 */
/*                                   */
/*===================================*/
#include "stdio.h"
#include "bios.h"
#include "\ptk\asm\mcc.h"

main()
{
  int contflag;                         /* continue/end flag */
  int choice;                           /* menu selection */
  int irq;                              /* interface's IRQ level */

  irq=mcc_irq(0x330);                   /* find IRQ for use */
  if (irq == 0)
    {
      puts("\n\nMIDI interface not installed\n\n");
      abort();
    }
  if (!mcc_open(0x330,irq))             /* open interface for use */
    {
      puts("\n\nMIDI interface not installed\n\n");
      abort();
    }

  contflag=1;                           /* set to keep running */
  while (contflag)
    {
      set_slih(mcc_noslih);             /* establish no-op SLIH */
      /* Display utility menu */
      puts("Music Quest Programmer's ToolKit Example Program - Quick C Version");
      puts("Copyright 1988, 1990");
      puts("Music Quest, Inc.");
      puts("\nToolKit Utility Menu\n");
      puts("1  = Hex MIDI trace");
      puts("2  = Interpreted MIDI trace");
      puts("3  = Send program change command");
      puts("4  = Record MIDI data");
      puts("5  = Play back recorded MIDI data");
      puts("6  = Chase Lock - Song Position Pointer trace");
      puts("7  = SMPTE frame trace");
      puts("8  = SMPTE Cue Point");
      puts("9  = Write SMPTE sync track");
      puts("x  = Exit\n");
      puts("Selection?");

      choice=toupper(getch());

      switch (choice)
        {
          case '1':                     /* trace */
            hex_trace();
            break;
          case '2':                     /* interpreted trace */
            tk_itrace();
            break;
          case '3':                     /* program change */
            prog_change();
            break;
          case '4':                     /* record */
            record_track();
            break;
          case '5':
            play_track();               /* play */
            break;
          case '6':                     /* CLS - SPP */
            show_spp();
            break;
          case '7':                     /* SMPTE display */
            show_smpte();
            break;
          case '8':                     /* cue point */
            cue_point();
            break;
          case '9':                     /* write smpte */
            write_smpte();
            break;
          case 'X':                     /* exit */
            puts("\nResetting interface....");
            contflag=0;
            break;
          default:
            break;
        }
    }
  mcc_close();                          /* close MCC */
}

/*===================================*/
/*                                   */
/* Hex trace                         */
/*                                   */
/*===================================*/
hex_trace()
{
  int byte;                             /* received data byte */

  puts("\n\nPress any key to end trace\n\n");
  set_slih(mcc_receive);                /* establish generic SLIH */
  mcc_command(UART_MODE);               /* put MCC into pass-thru mode */

  while (!_bios_keybrd(_KEYBRD_READY))  /* until some key is hit */
    if ((byte=mcc_get()) >=0)           /* see if a byte is available */
      {
        printf("%02X  ",byte);          /* display receive byte */
      }

  set_slih(mcc_noslih);                 /* establish no-op SLIH */
  mcc_flush();                          /* clear any residual data */
  mcc_reset();                          /* return to coproc mode */
  _bios_keybrd(_KEYBRD_READ);           /* read exit key */
  puts("\n\n");
}

/*===================================*/
/*                                   */
/* Program change command            */
/*                                   */
/*===================================*/
prog_change()
{
  int prognum;                          /* MIDI program number */
  int chan;                             /* MIDI channel number */
  long t, t2;

  set_slih(mcc_noslih);                 /* establish SLIH */
  mcc_command(UART_MODE);               /* put MCC into pass-thru mode */
  prognum=chan=0;
  puts("\nEnter channel number (1-16) and program number (1-128) => ");
  scanf("%d %d",&chan,&prognum);                 /* read user response */
  puts("\n\n");
  if ((prognum > 0) && (prognum <= 128) && /* validate response */
      (chan > 0) && (chan <= 16))
    {
      mcc_put(0xC0+(chan-1));           /* send program change status */
      mcc_put(prognum-1);               /* send program number */
      _bios_timeofday(_TIME_GETCLOCK,&t); /* give MCC time to send data */
      t+=3L;
      do
        _bios_timeofday(_TIME_GETCLOCK,&t2);
      while (t > t2);
    }
  mcc_reset();                          /* retrun to coproc mode */
}
