/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Package;
import org.armedbear.lisp.PackageError;

public final class Packages {
    private static final ArrayList<Package> packages = new ArrayList();
    private static final HashMap<String, Package> map = new HashMap();

    public static final synchronized Package createPackage(String name) {
        return Packages.createPackage(name, 0);
    }

    public static final synchronized Package createPackage(String name, int size) {
        Package pkg = map.get(name);
        if (pkg == null) {
            pkg = size != 0 ? new Package(name, size) : new Package(name);
            packages.add(pkg);
            map.put(name, pkg);
        } else {
            Debug.trace("package " + name + " already exists");
        }
        return pkg;
    }

    public static final synchronized void addPackage(Package pkg) {
        String name = pkg.getName();
        if (map.get(name) != null) {
            Lisp.error(new LispError("A package named " + name + " already exists."));
            return;
        }
        packages.add(pkg);
        map.put(name, pkg);
        List nicknames = pkg.getNicknames();
        if (nicknames != null) {
            for (String nickname : nicknames) {
                Packages.addNickname(pkg, nickname);
            }
        }
    }

    public static final synchronized Package findPackage(String name) {
        return Lisp.getCurrentPackage().findPackage(name);
    }

    static final synchronized Package findPackageGlobally(String name) {
        return map.get(name);
    }

    public static final synchronized Package makePackage(String name) {
        if (map.get(name) != null) {
            Lisp.error(new LispError("A package named " + name + " already exists."));
            return null;
        }
        Package pkg = new Package(name);
        packages.add(pkg);
        map.put(name, pkg);
        return pkg;
    }

    public static final synchronized void addNickname(Package pkg, String nickname) {
        Package obj = map.get(nickname);
        if (obj != null && obj != pkg) {
            Lisp.error(new PackageError("A package named " + nickname + " already exists."));
            return;
        }
        map.put(nickname, pkg);
    }

    public static final synchronized boolean deletePackage(Package pkg) {
        String name = pkg.getName();
        if (name != null) {
            map.remove(name);
            List nicknames = pkg.getNicknames();
            if (nicknames != null) {
                for (String nickname : nicknames) {
                    map.remove(nickname);
                }
            }
            packages.remove(pkg);
            return true;
        }
        return false;
    }

    public static final synchronized LispObject listAllPackages() {
        LispObject result = Lisp.NIL;
        for (Package pkg : packages) {
            result = new Cons(pkg, result);
        }
        return result;
    }

    public static final synchronized Package[] getAllPackages() {
        Package[] array = new Package[packages.size()];
        packages.toArray(array);
        return array;
    }

    public static final synchronized LispObject getPackagesNicknamingPackage(Package thePackage) {
        LispObject result = Lisp.NIL;
        for (Package pkg : packages) {
            for (Package nicknamedPackage : pkg.getLocallyNicknamedPackages()) {
                if (!thePackage.equals(nicknamedPackage)) continue;
                result = new Cons(pkg, result);
            }
        }
        return result;
    }
}

