/*
 * unbound_slot_instance.java
 *
 * Copyright (C) 2004 Peter Graves
 * $Id: unbound_slot_instance.java 14466 2013-04-24 12:50:40Z rschlatte $
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * As a special exception, the copyright holders of this library give you
 * permission to link this library with independent modules to produce an
 * executable, regardless of the license terms of these independent
 * modules, and to copy and distribute the resulting executable under
 * terms of your choice, provided that you also meet, for each linked
 * independent module, the terms and conditions of the license of that
 * module.  An independent module is a module which is not derived from
 * or based on this library.  If you modify this library, you may extend
 * this exception to your version of the library, but you are not
 * obligated to do so.  If you do not wish to do so, delete this
 * exception statement from your version.
 */

package org.armedbear.lisp;

import static org.armedbear.lisp.Lisp.*;

// ### unbound-slot-instance
public final class unbound_slot_instance extends Primitive
{
    private unbound_slot_instance()
    {
        super("unbound-slot-instance");
    }

    @Override
    public LispObject execute(LispObject arg)
    {
        if (arg instanceof UnboundSlot)
            return ((UnboundSlot)arg).getInstance();
        return type_error(arg, Symbol.UNBOUND_SLOT);
    }

    private static final unbound_slot_instance CELL_ERROR_NAME =
        new unbound_slot_instance();
}
