/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.www.SlaveServerDetection;
import org.pentaho.di.www.WebResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterSlaveServlet
extends HttpServlet {
    private static final long serialVersionUID = 8513820270964866132L;
    private static LogWriter log = LogWriter.getInstance();
    public static final String CONTEXT_PATH = "/kettle/registerSlave";
    private List<SlaveServerDetection> detections;

    public RegisterSlaveServlet(List<SlaveServerDetection> detections) {
        this.detections = detections;
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!request.getRequestURI().equals("/kettle/registerSlave/")) {
            return;
        }
        if (log.isDebug()) {
            log.logDebug(this.toString(), "Slave Server registration requested", new Object[0]);
        }
        PrintWriter out = response.getWriter();
        BufferedReader in = request.getReader();
        if (log.isDetailed()) {
            log.logDetailed(this.toString(), "Encoding: " + request.getCharacterEncoding(), new Object[0]);
        }
        response.setContentType("text/xml");
        out.print(XMLHandler.getXMLHeader());
        response.setStatus(200);
        try {
            String message;
            int c;
            StringBuilder xml = new StringBuilder(request.getContentLength());
            while ((c = in.read()) != -1) {
                xml.append((char)c);
            }
            Document document = XMLHandler.loadXMLString((String)xml.toString());
            Node node = XMLHandler.getSubNode((Node)document, (String)"SlaveServerDetection");
            SlaveServerDetection slaveServerDetection = new SlaveServerDetection(node);
            int index = this.detections.indexOf(slaveServerDetection);
            if (index < 0) {
                this.detections.add(slaveServerDetection);
                message = "Slave server detection '" + slaveServerDetection.getSlaveServer().getName() + "' was replaced in the list.";
            } else {
                SlaveServerDetection old = this.detections.get(index);
                old.setSlaveServer(slaveServerDetection.getSlaveServer());
                old.setActive(slaveServerDetection.isActive());
                if (old.isActive()) {
                    old.setLastActiveDate(slaveServerDetection.getLastActiveDate());
                } else {
                    old.setLastInactiveDate(slaveServerDetection.getLastInactiveDate());
                }
                message = "Slave server detection '" + slaveServerDetection.getSlaveServer().getName() + "' was added to the list.";
            }
            out.println(new WebResult("OK", message));
        }
        catch (Exception ex) {
            out.println(new WebResult("ERROR", Const.getStackTracker((Throwable)ex)));
        }
    }

    public String toString() {
        return "Register slave server";
    }
}

