/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.actions;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.rubypeople.rdt.internal.debug.core.model.RubyExpression;
import org.rubypeople.rdt.internal.debug.core.model.RubyProcessingException;
import org.rubypeople.rdt.internal.debug.core.model.RubyStackFrame;
import org.rubypeople.rdt.internal.debug.core.model.RubyVariable;
import org.rubypeople.rdt.internal.debug.ui.actions.AbstractInspectAction;

public class InspectAction
extends AbstractInspectAction
implements IViewActionDelegate,
IEditorActionDelegate {
    protected RubyStackFrame getRubyStackFrame() {
        IViewPart iViewPart = this.page.findView("org.eclipse.debug.ui.DebugView");
        if (iViewPart == null) {
            return null;
        }
        IDebugView iDebugView = (IDebugView)iViewPart;
        StructuredSelection structuredSelection = (StructuredSelection)iDebugView.getViewer().getSelection();
        if (structuredSelection.isEmpty()) {
            return null;
        }
        if (!(structuredSelection.getFirstElement() instanceof RubyStackFrame)) {
            return null;
        }
        return (RubyStackFrame)structuredSelection.getFirstElement();
    }

    public void run(IAction iAction) {
        final RubyStackFrame rubyStackFrame = this.getRubyStackFrame();
        if (rubyStackFrame == null) {
            MessageDialog.openInformation((Shell)this.page.getActivePart().getSite().getShell(), (String)"No suitable stack frame", (String)"Could not inspect because there is no context (a ruby stack frame) for inspection selected.");
            return;
        }
        if (!(this.selection instanceof ITextSelection)) {
            return;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                String string = ((ITextSelection)InspectAction.this.selection).getText().replace('\n', ';');
                string = string.replace('\r', ' ');
                try {
                    RubyVariable rubyVariable = rubyStackFrame.getRubyDebuggerProxy().readInspectExpression(rubyStackFrame, string);
                    InspectAction.this.showExpressionView();
                    DebugPlugin.getDefault().getExpressionManager().addExpression((IExpression)new RubyExpression(string, rubyVariable));
                }
                catch (RubyProcessingException rubyProcessingException) {
                    MessageDialog.openInformation((Shell)InspectAction.this.page.getActivePart().getSite().getShell(), (String)rubyProcessingException.getRubyExceptionType(), (String)("Could not inspect '" + string + "': " + rubyProcessingException.getMessage()));
                }
            }
        });
    }

    public void setActiveEditor(IAction iAction, IEditorPart iEditorPart) {
        this.page = iEditorPart == null || iEditorPart.getEditorSite() == null ? null : iEditorPart.getEditorSite().getPage();
    }
}

