/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences.formatter;

import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubySourceViewer;
import org.rubypeople.rdt.internal.ui.text.SimpleRubySourceViewerConfiguration;
import org.rubypeople.rdt.ui.text.RubyTextTools;

public abstract class RubyPreview {
    protected final SimpleRubySourceViewerConfiguration fViewerConfiguration;
    protected final Document fPreviewDocument;
    protected final SourceViewer fSourceViewer;
    protected final IPreferenceStore fPreferenceStore;
    protected final MarginPainter fMarginPainter;
    protected Map fWorkingValues;
    private int fTabSize = 0;

    public RubyPreview(Map map, Composite composite) {
        RubyTextTools rubyTextTools = RubyPlugin.getDefault().getRubyTextTools();
        this.fPreviewDocument = new Document();
        this.fWorkingValues = map;
        rubyTextTools.setupRubyDocumentPartitioner((IDocument)this.fPreviewDocument, "___ruby_partitioning");
        IPreferenceStore[] iPreferenceStoreArray = new IPreferenceStore[]{RubyPlugin.getDefault().getCombinedPreferenceStore()};
        this.fPreferenceStore = new ChainedPreferenceStore(iPreferenceStoreArray);
        this.fSourceViewer = new RubySourceViewer(composite, null, null, false, 2824, this.fPreferenceStore);
        this.fViewerConfiguration = new SimpleRubySourceViewerConfiguration(rubyTextTools.getColorManager(), this.fPreferenceStore, null, "___ruby_partitioning", true);
        this.fSourceViewer.configure((SourceViewerConfiguration)this.fViewerConfiguration);
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.rubypeople.rdt.ui.editors.textfont"));
        this.fMarginPainter = new MarginPainter((ITextViewer)this.fSourceViewer);
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)"printMarginColor");
        this.fMarginPainter.setMarginRulerColor(rubyTextTools.getColorManager().getColor(rGB));
        this.fSourceViewer.addPainter((IPainter)this.fMarginPainter);
        new RubySourcePreviewerUpdater();
        this.fSourceViewer.setDocument((IDocument)this.fPreviewDocument);
    }

    public Control getControl() {
        return this.fSourceViewer.getControl();
    }

    public void update() {
        if (this.fWorkingValues == null) {
            this.fPreviewDocument.set("");
            return;
        }
        String string = (String)this.fWorkingValues.get("org.rubypeople.rdt.core.formatter.lineSplit");
        int n = RubyPreview.getPositiveIntValue(string, 0);
        this.fMarginPainter.setMarginRulerColumn(n);
        int n2 = RubyPreview.getPositiveIntValue((String)this.fWorkingValues.get("org.rubypeople.rdt.core.formatter.tabulation.size"), 0);
        if (n2 != this.fTabSize) {
            this.fSourceViewer.getTextWidget().setTabs(n2);
        }
        this.fTabSize = n2;
        StyledText styledText = (StyledText)this.fSourceViewer.getControl();
        int n3 = styledText.getClientArea().height;
        int n4 = styledText.getTopPixel();
        int n5 = this.getHeightOfAllLines(styledText);
        int n6 = n5 > n3 ? n5 - n3 : 0;
        styledText.setRedraw(false);
        this.doFormatPreview();
        this.fSourceViewer.setSelection(null);
        int n7 = this.getHeightOfAllLines(styledText);
        int n8 = n7 > n3 ? n7 - n3 : 0;
        int n9 = n6 > 0 ? (int)((double)(n8 * n4) / (double)n6) : 0;
        styledText.setTopPixel(n9);
        styledText.setRedraw(true);
    }

    private int getHeightOfAllLines(StyledText styledText) {
        int n = 0;
        int n2 = styledText.getLineCount();
        int n3 = 0;
        while (n3 < n2) {
            n += styledText.getLineHeight();
            ++n3;
        }
        return n;
    }

    protected abstract void doFormatPreview();

    private static int getPositiveIntValue(String string, int n) {
        try {
            int n2 = Integer.parseInt(string);
            if (n2 >= 0) {
                return n2;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    public final Map getWorkingValues() {
        return this.fWorkingValues;
    }

    public final void setWorkingValues(Map map) {
        this.fWorkingValues = map;
    }

    private final class RubySourcePreviewerUpdater {
        final IPropertyChangeListener fontListener = new IPropertyChangeListener(this){
            final /* synthetic */ RubySourcePreviewerUpdater this$1;
            {
                this.this$1 = rubySourcePreviewerUpdater;
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("org.rubypeople.rdt.ui.editors.textfont")) {
                    Font font = JFaceResources.getFont((String)"org.rubypeople.rdt.ui.editors.textfont");
                    RubySourcePreviewerUpdater.access$0((RubySourcePreviewerUpdater)this.this$1).fSourceViewer.getTextWidget().setFont(font);
                    if (RubySourcePreviewerUpdater.access$0((RubySourcePreviewerUpdater)this.this$1).fMarginPainter != null) {
                        RubySourcePreviewerUpdater.access$0((RubySourcePreviewerUpdater)this.this$1).fMarginPainter.initialize();
                    }
                }
            }
        };
        final IPropertyChangeListener propertyListener = new IPropertyChangeListener(this){
            final /* synthetic */ RubySourcePreviewerUpdater this$1;
            {
                this.this$1 = rubySourcePreviewerUpdater;
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (RubySourcePreviewerUpdater.access$0((RubySourcePreviewerUpdater)this.this$1).fViewerConfiguration.affectsTextPresentation(propertyChangeEvent)) {
                    RubySourcePreviewerUpdater.access$0((RubySourcePreviewerUpdater)this.this$1).fViewerConfiguration.handlePropertyChangeEvent(propertyChangeEvent);
                    RubySourcePreviewerUpdater.access$0((RubySourcePreviewerUpdater)this.this$1).fSourceViewer.invalidateTextPresentation();
                }
            }
        };

        public RubySourcePreviewerUpdater() {
            JFaceResources.getFontRegistry().addListener(this.fontListener);
            RubyPreview.this.fPreferenceStore.addPropertyChangeListener(this.propertyListener);
            RubyPreview.this.fSourceViewer.getTextWidget().addDisposeListener(new DisposeListener(this){
                final /* synthetic */ RubySourcePreviewerUpdater this$1;
                {
                    this.this$1 = rubySourcePreviewerUpdater;
                }

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    JFaceResources.getFontRegistry().removeListener(this.this$1.fontListener);
                    RubySourcePreviewerUpdater.access$0((RubySourcePreviewerUpdater)this.this$1).fPreferenceStore.removePropertyChangeListener(this.this$1.propertyListener);
                }
            });
        }

        static /* synthetic */ RubyPreview access$0(RubySourcePreviewerUpdater rubySourcePreviewerUpdater) {
            return rubySourcePreviewerUpdater.RubyPreview.this;
        }
    }
}

