/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;

public class FormatAction
extends TextEditorAction {
    public FormatAction(ResourceBundle resourceBundle, String string, ITextEditor iTextEditor) {
        super(resourceBundle, string, iTextEditor);
    }

    public void run() {
        IDocument iDocument = this.getTextEditor().getDocumentProvider().getDocument((Object)this.getTextEditor().getEditorInput());
        try {
            ISelection iSelection = this.getTextEditor().getSelectionProvider().getSelection();
            if (iSelection instanceof TextSelection) {
                TextSelection textSelection = (TextSelection)iSelection;
                String string = textSelection.getText();
                if (string == null || string.length() == 0) {
                    String string2 = RubyPlugin.getDefault().getCodeFormatter().formatString(iDocument.get());
                    RubyEditor rubyEditor = (RubyEditor)this.getTextEditor();
                    RubyEditor.CaretPosition caretPosition = rubyEditor.getCaretPosition();
                    iDocument.set(string2);
                    rubyEditor.setCaretPosition(caretPosition);
                } else {
                    int n = iDocument.getLineOffset(textSelection.getStartLine());
                    int n2 = textSelection.getEndLine();
                    int n3 = iDocument.getLineOffset(n2) + iDocument.getLineLength(n2);
                    String string3 = RubyPlugin.getDefault().getCodeFormatter().formatString(iDocument.get(n, n3 - n));
                    iDocument.replace(n, n3 - n, string3);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            RubyPlugin.log(badLocationException);
        }
        super.run();
    }
}

