/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.builder;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResourceDelta;

public class ResourceDeltaFormatter {
    static Map flagMap = new HashMap();

    static {
        ResourceDeltaFormatter.putFlag(256, "Content");
        ResourceDeltaFormatter.putFlag(0x100000, "Encoding");
        ResourceDeltaFormatter.putFlag(524288, "Description");
        ResourceDeltaFormatter.putFlag(16384, "Open");
        ResourceDeltaFormatter.putFlag(32768, "Type");
        ResourceDeltaFormatter.putFlag(65536, "Sync");
        ResourceDeltaFormatter.putFlag(131072, "Markers");
        ResourceDeltaFormatter.putFlag(4096, "Moved-from");
        ResourceDeltaFormatter.putFlag(8192, "Moved-to");
    }

    public String format(IResourceDelta iResourceDelta) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.kindAsString(iResourceDelta.getKind()));
        stringBuffer.append(this.flagsAsString(iResourceDelta.getFlags()));
        stringBuffer.append(iResourceDelta.getFullPath());
        stringBuffer.append("\n");
        IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
        int n = 0;
        while (n < iResourceDeltaArray.length) {
            IResourceDelta iResourceDelta2 = iResourceDeltaArray[n];
            stringBuffer.append(this.format(iResourceDelta2));
            ++n;
        }
        return stringBuffer.toString();
    }

    private String flagsAsString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = flagMap.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            if ((n & n2) == 0) continue;
            stringBuffer.append(flagMap.get(n2) + " ");
        }
        return stringBuffer.toString();
    }

    private String kindAsString(int n) {
        switch (n) {
            case 1: {
                return "Added  ";
            }
            case 2: {
                return "Removed";
            }
            case 4: {
                return "Changed";
            }
            case 8: {
                return "AddedPh";
            }
            case 16: {
                return "RemovPh";
            }
        }
        return String.valueOf(n);
    }

    private static void putFlag(int n, String string) {
        flagMap.put(new Integer(n), string);
    }
}

