/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.decorator;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.tigris.subversion.subclipse.core.IResourceStateChangeListener;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.decorator.IDecoratorComponent;
import org.tigris.subversion.subclipse.ui.decorator.SVNDecoratorConfiguration;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNLightweightDecorator
extends LabelProvider
implements ILightweightLabelDecorator,
IResourceStateChangeListener,
IPropertyChangeListener {
    private static String[] fonts = new String[]{"svn_ignored_resource_font", "svn_outgoing_change_font"};
    private static String[] colors = new String[]{"svn_outgoing_change_background_color", "svn_outgoing_change_foreground_color", "svn_ignored_resource_background_color", "svn_ignored_resource_foreground_color"};
    private static ImageDescriptor dirty = new CachedImageDescriptor(TeamImages.getImageDescriptor((String)"ovr/dirty_ov.gif"));
    private static ImageDescriptor checkedIn = new CachedImageDescriptor(TeamImages.getImageDescriptor((String)"ovr/version_controlled.gif"));
    private static ImageDescriptor deleted;
    private static ImageDescriptor switched;
    private static ImageDescriptor added;
    private static ImageDescriptor newResource;
    private static ImageDescriptor conflicted;
    private static ImageDescriptor merged;
    private static ImageDescriptor external;
    private static ImageDescriptor locked;
    private static ImageDescriptor needsLock;
    private static IPropertyChangeListener propertyListener;
    protected boolean computeDeepDirtyCheck;
    protected IDecoratorComponent[][] folderDecoratorFormat;
    protected IDecoratorComponent[][] projectDecoratorFormat;
    protected IDecoratorComponent[][] fileDecoratorFormat;
    protected String dirtyFlag;
    protected String addedFlag;
    protected String externalFlag;
    protected boolean showNewResources;
    protected boolean showDirty;
    protected boolean showAdded;
    protected boolean showExternal;
    protected boolean showHasRemote;
    protected DateFormat dateFormat = DateFormat.getInstance();
    static /* synthetic */ Class class$0;

    static {
        added = new CachedImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("ovr16/added_ov.gif"));
        merged = new CachedImageDescriptor(TeamImages.getImageDescriptor((String)"ovr/dirty_ov.gif"));
        newResource = new CachedImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("ovr16/question_ov.gif"));
        external = new CachedImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("ovr16/external_ov.gif"));
        locked = new CachedImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("ovr16/locked_ov.gif"));
        needsLock = new CachedImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("ovr16/protected_ov.gif"));
        conflicted = new CachedImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("ovr16/conflicted_ov.gif"));
        deleted = new CachedImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("ovr16/deleted_ov.gif"));
        switched = new CachedImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("ovr16/switched_ov.gif"));
    }

    public SVNLightweightDecorator() {
        IPreferenceStore store = SVNUIPlugin.getPlugin().getPreferenceStore();
        this.computeDeepDirtyCheck = store.getBoolean("pref_calculate_dirty");
        this.folderDecoratorFormat = SVNDecoratorConfiguration.compileFormatString(store.getString("pref_foldertext_decoration"));
        this.projectDecoratorFormat = SVNDecoratorConfiguration.compileFormatString(store.getString("pref_projecttext_decoration"));
        this.fileDecoratorFormat = SVNDecoratorConfiguration.compileFormatString(store.getString("pref_filetext_decoration"));
        this.dirtyFlag = store.getString("pref_dirty_flag");
        this.addedFlag = store.getString("pref_added_flag");
        this.externalFlag = store.getString("pref_external_flag");
        this.showNewResources = store.getBoolean("pref_show_newresource");
        this.showDirty = store.getBoolean("pref_show_overlaydirty");
        this.showAdded = store.getBoolean("pref_show_added");
        this.showExternal = store.getBoolean("pref_show_external");
        this.showHasRemote = store.getBoolean("pref_show_hasremote");
        propertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("pref_calculate_dirty".equals(event.getProperty())) {
                    SVNLightweightDecorator.this.computeDeepDirtyCheck = SVNLightweightDecorator.this.getBoolean(event);
                } else if ("pref_foldertext_decoration".equals(event.getProperty())) {
                    SVNLightweightDecorator.this.folderDecoratorFormat = SVNDecoratorConfiguration.compileFormatString((String)event.getNewValue());
                } else if ("pref_projecttext_decoration".equals(event.getProperty())) {
                    SVNLightweightDecorator.this.projectDecoratorFormat = SVNDecoratorConfiguration.compileFormatString((String)event.getNewValue());
                } else if ("pref_filetext_decoration".equals(event.getProperty())) {
                    SVNLightweightDecorator.this.fileDecoratorFormat = SVNDecoratorConfiguration.compileFormatString((String)event.getNewValue());
                } else if ("pref_dirty_flag".equals(event.getProperty())) {
                    SVNLightweightDecorator.this.dirtyFlag = (String)event.getNewValue();
                } else if ("pref_added_flag".equals(event.getProperty())) {
                    SVNLightweightDecorator.this.addedFlag = (String)event.getNewValue();
                } else if ("pref_external_flag".equals(event.getProperty())) {
                    SVNLightweightDecorator.this.externalFlag = (String)event.getNewValue();
                } else if ("pref_show_newresource".equals(event.getProperty())) {
                    SVNLightweightDecorator.this.showNewResources = SVNLightweightDecorator.this.getBoolean(event);
                } else if ("pref_show_overlaydirty".equals(event.getProperty())) {
                    SVNLightweightDecorator.this.showDirty = SVNLightweightDecorator.this.getBoolean(event);
                } else if ("pref_show_added".equals(event.getProperty())) {
                    SVNLightweightDecorator.this.showAdded = SVNLightweightDecorator.this.getBoolean(event);
                } else if ("pref_show_external".equals(event.getProperty())) {
                    SVNLightweightDecorator.this.showExternal = SVNLightweightDecorator.this.getBoolean(event);
                } else if ("pref_show_hasremote".equals(event.getProperty())) {
                    SVNLightweightDecorator.this.showHasRemote = SVNLightweightDecorator.this.getBoolean(event);
                }
            }
        };
        store.addPropertyChangeListener(propertyListener);
        SVNProviderPlugin.addResourceStateChangeListener((IResourceStateChangeListener)this);
        this.ensureFontAndColorsCreated(fonts, colors);
        PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private void ensureFontAndColorsCreated(final String[] fonts, final String[] colors) {
        SVNUIPlugin.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
                int i = 0;
                while (i < colors.length) {
                    theme.getColorRegistry().get(colors[i]);
                    ++i;
                }
                i = 0;
                while (i < fonts.length) {
                    theme.getFontRegistry().get(fonts[i]);
                    ++i;
                }
            }
        });
    }

    private boolean getBoolean(PropertyChangeEvent event) {
        if (event.getNewValue() instanceof String) {
            return ((String)event.getNewValue()).equalsIgnoreCase("true");
        }
        if (event.getNewValue() instanceof Boolean) {
            return (Boolean)event.getNewValue();
        }
        return false;
    }

    public static boolean isDirty(ISVNLocalResource svnResource) {
        block4: {
            try {
                if (svnResource.exists()) break block4;
                return false;
            }
            catch (SVNException e) {
                SVNUIPlugin.log(e.getStatus());
                return true;
            }
        }
        if (svnResource.getIResource().getType() == 1) {
            LocalResourceStatus status = svnResource.getStatus();
            return (status.isTextModified() || status.isPropModified() || status.isReplaced()) && !status.isIgnored() && !svnResource.isIgnored();
        }
        return svnResource.isDirty();
    }

    private IResource getResource(Object object) {
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    public void decorate(Object element, IDecoration decoration) {
        ImageDescriptor overlay;
        IResource resource = this.getResource(element);
        if (resource == null || resource.getType() == 8) {
            return;
        }
        SVNTeamProvider svnProvider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)resource.getProject(), (String)SVNProviderPlugin.getTypeId());
        if (svnProvider == null) {
            return;
        }
        boolean isIgnored = false;
        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
        try {
            if (svnResource.isIgnored()) {
                isIgnored = true;
            }
        }
        catch (SVNException sVNException) {
            return;
        }
        boolean isDirty = false;
        boolean isUnversioned = false;
        LocalResourceStatus status = null;
        if (!isIgnored) {
            if (resource.getType() == 1 || this.computeDeepDirtyCheck) {
                isDirty = SVNLightweightDecorator.isDirty(svnResource);
            }
            try {
                status = svnResource.getStatus();
                isUnversioned = status.isUnversioned();
            }
            catch (SVNException e1) {
                SVNUIPlugin.log(e1.getStatus());
            }
            this.decorateTextLabel(svnResource, status, decoration, isDirty);
        }
        if (!isUnversioned) {
            this.computeColorsAndFonts(isIgnored, isDirty, decoration);
        }
        if (!isIgnored && (overlay = this.getOverlay(svnResource, status, isDirty, svnProvider)) != null) {
            decoration.addOverlay(overlay);
        }
    }

    private void computeColorsAndFonts(boolean isIgnored, boolean isDirty, IDecoration decoration) {
        if (!SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_use_font_decorators")) {
            return;
        }
        ITheme current = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        if (isIgnored) {
            decoration.setBackgroundColor(current.getColorRegistry().get("svn_ignored_resource_background_color"));
            decoration.setForegroundColor(current.getColorRegistry().get("svn_ignored_resource_foreground_color"));
            decoration.setFont(current.getFontRegistry().get("svn_ignored_resource_font"));
        } else if (isDirty) {
            decoration.setBackgroundColor(current.getColorRegistry().get("svn_outgoing_change_background_color"));
            decoration.setForegroundColor(current.getColorRegistry().get("svn_outgoing_change_foreground_color"));
            decoration.setFont(current.getFontRegistry().get("svn_outgoing_change_font"));
        }
    }

    protected void decorateTextLabel(ISVNLocalResource svnResource, LocalResourceStatus status, IDecoration decoration, boolean isDirty) {
        HashMap<String, String> bindings = new HashMap<String, String>(6);
        if (svnResource.getIResource().getLocation() == null) {
            return;
        }
        if (status.isUnversioned()) {
            return;
        }
        int type = svnResource.getIResource().getType();
        IDecoratorComponent[][] format = type == 2 ? this.folderDecoratorFormat : (type == 4 ? this.projectDecoratorFormat : this.fileDecoratorFormat);
        if (isDirty & !status.isAdded()) {
            bindings.put("dirty_flag", this.dirtyFlag);
        }
        if (status.getUrlString() != null) {
            String label = svnResource.getRepository().getLabel();
            bindings.put("label", label == null ? status.getUrlString() : label);
            bindings.put("url", Util.unescape((String)status.getUrlString()));
            SVNUrl repositoryRoot = svnResource.getRepository().getRepositoryRoot();
            if (repositoryRoot != null) {
                int rootLen;
                int urlLen = status.getUrlString().length();
                String shortUrl = urlLen > (rootLen = repositoryRoot.toString().length() + 1) ? status.getUrlString().substring(rootLen) : status.getUrlString();
                bindings.put("url_short", Util.unescape((String)shortUrl));
            }
        }
        if (status.isAdded()) {
            bindings.put("added_flag", this.addedFlag);
        } else if (SVNStatusKind.EXTERNAL.equals((Object)status.getTextStatus())) {
            bindings.put("external_flag", this.externalFlag);
        } else {
            if (status.getTextStatus() != SVNStatusKind.UNVERSIONED && status.getTextStatus() != SVNStatusKind.ADDED) {
                if (status.getLastChangedRevision() != null) {
                    bindings.put("revision", status.getLastChangedRevision().toString());
                }
                if (status.getLastCommitAuthor() != null) {
                    bindings.put("author", status.getLastCommitAuthor());
                }
            }
            if (status.getLastChangedDate() != null) {
                bindings.put("date", this.dateFormat.format(status.getLastChangedDate()));
            }
        }
        SVNDecoratorConfiguration.decorate(decoration, format, bindings);
    }

    protected ImageDescriptor getOverlay(ISVNLocalResource svnResource, LocalResourceStatus status, boolean isDirty, SVNTeamProvider provider) {
        if (this.showNewResources) {
            try {
                if (svnResource.exists()) {
                    boolean isNewResource = false;
                    if (!svnResource.isManaged()) {
                        isNewResource = true;
                    }
                    if (isNewResource) {
                        return newResource;
                    }
                }
            }
            catch (SVNException e) {
                SVNUIPlugin.log(e.getStatus());
                return null;
            }
        }
        if (this.showExternal && SVNStatusKind.EXTERNAL.equals((Object)status.getTextStatus())) {
            return external;
        }
        if (this.showDirty && isDirty) {
            if (svnResource.getIResource().getType() == 2) {
                if (status.isDeleted()) {
                    return deleted;
                }
                if (status.isAdded()) {
                    return added;
                }
                return dirty;
            }
            return dirty;
        }
        if (this.showAdded) {
            if (status.isTextConflicted()) {
                return conflicted;
            }
            if (status.isTextMerged()) {
                return merged;
            }
            if (status.isAdded()) {
                return added;
            }
            if (status.isLocked()) {
                return locked;
            }
            if (status.isReadOnly()) {
                return needsLock;
            }
        }
        if (status.isDeleted()) {
            return deleted;
        }
        if (this.showHasRemote) {
            if (status.isSwitched()) {
                return switched;
            }
            if (status.hasRemote()) {
                return checkedIn;
            }
        }
        return null;
    }

    public static void refresh() {
        SVNUIPlugin.getPlugin().getWorkbench().getDecoratorManager().update("org.tigris.subversion.subclipse.ui.decorator");
    }

    public void refresh(IProject project) {
        final ArrayList resources = new ArrayList();
        try {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) {
                    resources.add(resource);
                    return true;
                }
            });
            this.postLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, resources.toArray()));
        }
        catch (CoreException e) {
            SVNProviderPlugin.log((IStatus)e.getStatus());
        }
    }

    public void resourceSyncInfoChanged(IResource[] changedResources) {
        this.resourceStateChanged(changedResources);
    }

    public void resourceModified(IResource[] changedResources) {
        this.resourceStateChanged(changedResources);
    }

    public void resourceStateChanged(IResource[] changedResources) {
        HashSet<Object> resourcesToUpdate = new HashSet<Object>();
        int i = 0;
        while (i < changedResources.length) {
            IResource resource = changedResources[i];
            if (resource != null) {
                if (resource.exists()) {
                    if (this.computeDeepDirtyCheck) {
                        IResource current = resource;
                        while (current.getType() != 8 && !resourcesToUpdate.contains(current)) {
                            resourcesToUpdate.add(current);
                            current = current.getParent();
                        }
                    } else {
                        resourcesToUpdate.add(resource);
                    }
                } else {
                    try {
                        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                        if (!svnResource.isManaged() && !svnResource.isIgnored()) {
                            IContainer current = resource.getParent();
                            while (current.getType() != 8) {
                                if (current.exists() && SVNWorkspaceRoot.getSVNResourceFor((IResource)current).isManaged()) {
                                    resourcesToUpdate.add(current);
                                }
                                current = current.getParent();
                            }
                        }
                    }
                    catch (SVNException sVNException) {}
                }
            }
            ++i;
        }
        this.postLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, resourcesToUpdate.toArray()));
    }

    public void projectConfigured(IProject project) {
        this.refresh(project);
    }

    public void projectDeconfigured(IProject project) {
        this.refresh(project);
    }

    private void postLabelEvent(final LabelProviderChangedEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                SVNLightweightDecorator.this.fireLabelProviderChanged(event);
            }
        });
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.isEventOfInterest(event)) {
            this.ensureFontAndColorsCreated(fonts, colors);
            SVNLightweightDecorator.refresh();
        }
    }

    private boolean isEventOfInterest(PropertyChangeEvent event) {
        String prop = event.getProperty();
        return prop.equals("org.eclipse.team.uiglobal_ignores_changed") || prop.equals("org.eclipse.team.uiglobal_file_types_changed") || prop.equals("org.tigris.subversion.subclipse.ui.P_DECORATORS_CHANGED") || prop.equals("svn_outgoing_change_background_color") || prop.equals("svn_outgoing_change_foreground_color") || prop.equals("svn_outgoing_change_font") || prop.equals("svn_ignored_resource_foreground_color") || prop.equals("svn_ignored_resource_background_color") || prop.equals("svn_ignored_resource_font");
    }

    public void dispose() {
        super.dispose();
        PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().removePropertyChangeListener((IPropertyChangeListener)this);
        TeamUI.removePropertyChangeListener((IPropertyChangeListener)this);
        SVNUIPlugin.getPlugin().getPreferenceStore().removePropertyChangeListener(propertyListener);
        SVNProviderPlugin.removeResourceStateChangeListener((IResourceStateChangeListener)this);
    }

    public static class CachedImageDescriptor
    extends ImageDescriptor {
        ImageDescriptor descriptor;
        ImageData data;

        public CachedImageDescriptor(ImageDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public ImageData getImageData() {
            if (this.data == null) {
                this.data = this.descriptor.getImageData();
            }
            return this.data;
        }
    }
}

