/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.CheckoutAsProjectAction;
import org.tigris.subversion.subclipse.ui.actions.CheckoutIntoAction;
import org.tigris.subversion.subclipse.ui.actions.CheckoutUsingProjectWizardAction;
import org.tigris.subversion.subclipse.ui.wizards.CheckoutWizardCheckoutAsMultiplePage;
import org.tigris.subversion.subclipse.ui.wizards.CheckoutWizardCheckoutAsWithProjectFilePage;
import org.tigris.subversion.subclipse.ui.wizards.CheckoutWizardCheckoutAsWithoutProjectFilePage;
import org.tigris.subversion.subclipse.ui.wizards.CheckoutWizardLocationPage;
import org.tigris.subversion.subclipse.ui.wizards.CheckoutWizardProjectPage;
import org.tigris.subversion.subclipse.ui.wizards.CheckoutWizardSelectionPage;
import org.tigris.subversion.subclipse.ui.wizards.ConfigurationWizardMainPage;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class CheckoutWizard
extends Wizard
implements INewWizard,
IImportWizard {
    private CheckoutWizardLocationPage locationPage;
    private ConfigurationWizardMainPage createLocationPage;
    private CheckoutWizardSelectionPage selectionPage;
    private CheckoutWizardCheckoutAsMultiplePage checkoutAsMultiplePage;
    private CheckoutWizardCheckoutAsWithProjectFilePage checkoutAsWithProjectFilePage;
    private CheckoutWizardCheckoutAsWithoutProjectFilePage checkoutAsWithoutProjectFilePage;
    private CheckoutWizardProjectPage projectPage;
    private IProject project;
    private String projectName;
    private boolean hasProjectFile;
    private ISVNRepositoryLocation repositoryLocation;
    private ISVNRemoteFolder[] remoteFolders;

    public CheckoutWizard() {
        this.setWindowTitle(Policy.bind("CheckoutWizard.title"));
    }

    public CheckoutWizard(ISVNRemoteFolder[] remoteFolders) {
        this();
        this.remoteFolders = remoteFolders;
        if (remoteFolders.length == 1) {
            this.checkForProjectFile();
        }
    }

    public void addPages() {
        this.setNeedsProgressMonitor(true);
        if (this.remoteFolders == null) {
            this.locationPage = new CheckoutWizardLocationPage("locationPage", Policy.bind("CheckoutWizardLocationPage.heading"), SVNUIPlugin.getPlugin().getImageDescriptor("wizban/newconnect_wizban.gif"));
            this.addPage((IWizardPage)this.locationPage);
            this.createLocationPage = new ConfigurationWizardMainPage("createLocationPage", Policy.bind("CheckoutWizardLocationPage.heading"), SVNUIPlugin.getPlugin().getImageDescriptor("wizban/newconnect_wizban.gif"));
            this.addPage((IWizardPage)this.createLocationPage);
            this.selectionPage = new CheckoutWizardSelectionPage("selectionPage", Policy.bind("CheckoutWizardSelectionPage.heading"), SVNUIPlugin.getPlugin().getImageDescriptor("wizban/newconnect_wizban.gif"));
            this.addPage((IWizardPage)this.selectionPage);
        }
        if (this.remoteFolders == null || this.remoteFolders.length > 1) {
            this.checkoutAsMultiplePage = new CheckoutWizardCheckoutAsMultiplePage("checkoutAsMultiplePage", Policy.bind("CheckoutWizardCheckoutAsPage.heading"), SVNUIPlugin.getPlugin().getImageDescriptor("wizban/newconnect_wizban.gif"));
            this.addPage((IWizardPage)this.checkoutAsMultiplePage);
        }
        if (this.remoteFolders == null || this.remoteFolders.length == 1) {
            if (this.remoteFolders == null || this.hasProjectFile) {
                this.checkoutAsWithProjectFilePage = new CheckoutWizardCheckoutAsWithProjectFilePage("checkoutAsWithProjectFilePage", Policy.bind("CheckoutWizardCheckoutAsPage.heading"), SVNUIPlugin.getPlugin().getImageDescriptor("wizban/newconnect_wizban.gif"));
                this.addPage((IWizardPage)this.checkoutAsWithProjectFilePage);
                if (this.remoteFolders != null && this.remoteFolders.length == 1 && this.project != null) {
                    this.checkoutAsWithProjectFilePage.setProjectName(this.project.getName());
                }
            }
            if (this.remoteFolders == null || !this.hasProjectFile) {
                this.checkoutAsWithoutProjectFilePage = new CheckoutWizardCheckoutAsWithoutProjectFilePage("checkoutAsWithoutProjectFilePage", Policy.bind("CheckoutWizardCheckoutAsPage.heading"), SVNUIPlugin.getPlugin().getImageDescriptor("wizban/newconnect_wizban.gif"));
                this.addPage((IWizardPage)this.checkoutAsWithoutProjectFilePage);
            }
        }
        this.projectPage = new CheckoutWizardProjectPage("projectPage", Policy.bind("CheckoutWizardProjectPage.heading"), SVNUIPlugin.getPlugin().getImageDescriptor("wizban/newconnect_wizban.gif"));
        this.addPage((IWizardPage)this.projectPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        return this.getNextPage(page, true);
    }

    public IWizardPage getNextPage(IWizardPage page, boolean aboutToShow) {
        if (page == this.locationPage) {
            if (this.locationPage.createNewLocation()) {
                return this.createLocationPage;
            }
            if (aboutToShow) {
                this.selectionPage.setLocation(this.repositoryLocation);
            }
            return this.selectionPage;
        }
        if (page == this.createLocationPage) {
            ISVNRepositoryLocation newLocation;
            if (aboutToShow && (newLocation = this.createLocation()) != null) {
                this.locationPage.refreshLocations();
                this.selectionPage.setLocation(newLocation);
            }
            return this.selectionPage;
        }
        if (page == this.selectionPage) {
            if (aboutToShow) {
                if (this.remoteFolders.length == 1) {
                    BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                        public void run() {
                            CheckoutWizard.this.checkForProjectFile();
                            if (CheckoutWizard.this.hasProjectFile) {
                                if (CheckoutWizard.this.checkoutAsWithProjectFilePage != null) {
                                    CheckoutWizard.this.checkoutAsWithProjectFilePage.setText(Policy.bind("CheckoutWizardCheckoutAsPage.single", CheckoutWizard.this.remoteFolders[0].getName()));
                                    if (CheckoutWizard.this.project == null) {
                                        CheckoutWizard.this.project = SVNWorkspaceRoot.getProject((ISVNRemoteFolder)CheckoutWizard.this.remoteFolders[0], null);
                                    }
                                    if (CheckoutWizard.this.project != null) {
                                        CheckoutWizard.this.checkoutAsWithProjectFilePage.setProject(CheckoutWizard.this.project.getName());
                                    }
                                }
                            } else if (CheckoutWizard.this.checkoutAsWithoutProjectFilePage != null) {
                                CheckoutWizard.this.checkoutAsWithoutProjectFilePage.setText(Policy.bind("CheckoutWizardCheckoutAsPage.single", CheckoutWizard.this.remoteFolders[0].getName()));
                                IProject project = SVNWorkspaceRoot.getProject((ISVNRemoteFolder)CheckoutWizard.this.remoteFolders[0], null);
                                CheckoutWizard.this.checkoutAsWithoutProjectFilePage.setProject(project.getName());
                            }
                        }
                    });
                } else if (this.checkoutAsMultiplePage != null) {
                    this.checkoutAsMultiplePage.setText(Policy.bind("CheckoutWizardCheckoutAsPage.multiple", Integer.toString(this.remoteFolders.length)));
                }
            }
            if (this.remoteFolders.length > 1) {
                return this.checkoutAsMultiplePage;
            }
            if (this.hasProjectFile) {
                return this.checkoutAsWithProjectFilePage;
            }
            return this.checkoutAsWithoutProjectFilePage;
        }
        if (page == this.checkoutAsWithoutProjectFilePage) {
            if (this.checkoutAsWithoutProjectFilePage.useWizard()) {
                return null;
            }
            return this.projectPage;
        }
        if (page == this.checkoutAsMultiplePage || page == this.checkoutAsWithProjectFilePage) {
            return this.projectPage;
        }
        return super.getNextPage(page);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ISVNRepositoryLocation createLocation() {
        this.createLocationPage.finish((IProgressMonitor)new NullProgressMonitor());
        Properties properties = this.createLocationPage.getProperties();
        final ISVNRepositoryLocation[] root = new ISVNRepositoryLocation[1];
        SVNProviderPlugin provider = SVNProviderPlugin.getPlugin();
        try {
            block13: {
                root[0] = provider.getRepositories().createRepository(properties);
                try {
                    new ProgressMonitorDialog(this.getShell()).run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException {
                            try {
                                root[0].validateConnection(monitor);
                            }
                            catch (TeamException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (!(t instanceof TeamException)) break block13;
                    throw (TeamException)t;
                }
            }
            provider.getRepositories().addOrUpdateRepository(root[0]);
            return root[0];
        }
        catch (TeamException e) {
            if (root[0] == null) {
                SVNUIPlugin.openError(this.getContainer().getShell(), Policy.bind("NewLocationWizard.exception"), null, e);
                return null;
            }
            IStatus error = e.getStatus();
            if (error.isMultiStatus() && error.getChildren().length == 1) {
                error = error.getChildren()[0];
            }
            boolean keep = false;
            if (error.isMultiStatus()) {
                SVNUIPlugin.openError(this.getContainer().getShell(), Policy.bind("NewLocationWizard.validationFailedTitle"), null, e);
            } else {
                keep = MessageDialog.openQuestion((Shell)this.getContainer().getShell(), (String)Policy.bind("NewLocationWizard.validationFailedTitle"), (String)Policy.bind("NewLocationWizard.validationFailedText", new Object[]{error.getMessage()}));
            }
            try {
                if (keep) {
                    provider.getRepositories().addOrUpdateRepository(root[0]);
                } else {
                    provider.getRepositories().disposeRepository(root[0]);
                }
            }
            catch (TeamException e1) {
                SVNUIPlugin.openError(this.getContainer().getShell(), Policy.bind("exception"), null, e1);
                return null;
            }
            if (!keep) return root[0];
            return root[0];
        }
    }

    private void checkForProjectFile() {
        if (!this.hasProjectFile && this.project == null) {
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, false, new IRunnableWithProgress(){

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor = Policy.monitorFor(monitor);
                        monitor.beginTask("Getting remote project info", 100);
                        ISVNRemoteFolder folder = CheckoutWizard.this.remoteFolders[0];
                        String url = String.valueOf(folder.getUrl().toString()) + "/.project";
                        try {
                            try {
                                ISVNClientAdapter client = SVNProviderPlugin.getPlugin().getSVNClientManager().createSVNClient();
                                client.getInfo(new SVNUrl(url));
                                CheckoutWizard.this.hasProjectFile = true;
                                monitor.worked(50);
                                CheckoutWizard.this.project = SVNWorkspaceRoot.getProject((ISVNRemoteFolder)folder, null);
                            }
                            catch (Exception exception) {
                                CheckoutWizard.this.hasProjectFile = false;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var5_6 = null;
                            monitor.done();
                            throw throwable;
                        }
                        {
                            Object var5_7 = null;
                        }
                        monitor.done();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                SVNUIPlugin.openError(this.getContainer().getShell(), Policy.bind("exception"), null, e.getCause(), 1);
            }
        }
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        if (page == this.checkoutAsMultiplePage || page == this.projectPage) {
            return this.projectPage.isPageComplete();
        }
        if (page == this.checkoutAsWithoutProjectFilePage) {
            if (this.checkoutAsWithoutProjectFilePage.useWizard()) {
                return true;
            }
            return this.checkoutAsWithoutProjectFilePage.isPageComplete() && this.projectPage.isPageComplete();
        }
        if (page == this.checkoutAsWithProjectFilePage) {
            return this.checkoutAsWithProjectFilePage.isPageComplete() && this.projectPage.isPageComplete();
        }
        if (page == this.selectionPage) {
            return this.projectPage.isPageComplete();
        }
        return super.canFinish();
    }

    public void setLocation(ISVNRepositoryLocation repositoryLocation) {
        this.repositoryLocation = repositoryLocation;
    }

    public boolean performFinish() {
        if (this.remoteFolders.length == 1) {
            this.checkForProjectFile();
            boolean useWizard = false;
            if (!this.hasProjectFile) {
                useWizard = this.checkoutAsWithoutProjectFilePage.useWizard();
            }
            if (useWizard) {
                return this.checkoutUsingWizard();
            }
        }
        if (this.projectPage.getLocation().equals(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString())) {
            return this.checkoutAsProject();
        }
        return this.checkoutAsProjectInto();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
        this.projectPage.setLocation();
    }

    public void setRemoteFolders(ISVNRemoteFolder[] remoteFolders) {
        this.remoteFolders = remoteFolders;
        this.hasProjectFile = false;
        this.project = null;
    }

    public ISVNRemoteFolder[] getRemoteFolders() {
        return this.remoteFolders;
    }

    private boolean checkoutUsingWizard() {
        CheckoutUsingProjectWizardAction checkoutAction = new CheckoutUsingProjectWizardAction(this.remoteFolders);
        try {
            if (this.remoteFolders.length == 1) {
                if (this.hasProjectFile) {
                    checkoutAction.setSvnRevision(this.checkoutAsWithProjectFilePage.getRevision());
                } else {
                    checkoutAction.setSvnRevision(this.checkoutAsWithoutProjectFilePage.getRevision());
                }
            } else {
                checkoutAction.setSvnRevision(this.checkoutAsMultiplePage.getRevision());
            }
            checkoutAction.execute(null);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("CheckoutAsAction.title"), (String)e.getMessage());
            return false;
        }
        return true;
    }

    private boolean checkoutAsProjectInto() {
        CheckoutIntoAction checkoutAction = new CheckoutIntoAction(this.remoteFolders, this.projectName, this.projectPage.getCanonicalLocation(), this.getShell());
        try {
            if (this.remoteFolders.length == 1) {
                if (this.hasProjectFile) {
                    checkoutAction.setSvnRevision(this.checkoutAsWithProjectFilePage.getRevision());
                } else {
                    checkoutAction.setSvnRevision(this.checkoutAsWithoutProjectFilePage.getRevision());
                }
            } else {
                checkoutAction.setSvnRevision(this.checkoutAsMultiplePage.getRevision());
            }
            checkoutAction.execute(null);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("CheckoutAsAction.title"), (String)e.getMessage());
            return false;
        }
        return true;
    }

    private boolean checkoutAsProject() {
        CheckoutAsProjectAction checkoutAction = new CheckoutAsProjectAction(this.remoteFolders, this.projectName, this.getShell());
        try {
            if (this.remoteFolders.length == 1) {
                if (this.hasProjectFile) {
                    checkoutAction.setSvnRevision(this.checkoutAsWithProjectFilePage.getRevision());
                } else {
                    checkoutAction.setSvnRevision(this.checkoutAsWithoutProjectFilePage.getRevision());
                }
            } else {
                checkoutAction.setSvnRevision(this.checkoutAsMultiplePage.getRevision());
            }
            checkoutAction.execute(null);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("CheckoutAsAction.title"), (String)e.getMessage());
            return false;
        }
        return true;
    }

    public String getProjectName() {
        return this.projectName;
    }
}

