/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.io.File;
import java.util.Date;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.BaseFile;
import org.tigris.subversion.subclipse.core.resources.BaseFolder;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.util.Assert;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNUrlUtils;

public abstract class BaseResource
extends PlatformObject
implements ISVNRemoteResource {
    private String charset = null;
    protected LocalResourceStatus localResourceStatus;

    public BaseResource(LocalResourceStatus localResourceStatus) {
        Assert.isNotNull(localResourceStatus);
        this.localResourceStatus = localResourceStatus;
    }

    public BaseResource(LocalResourceStatus localResourceStatus, String charset) {
        Assert.isNotNull(localResourceStatus);
        this.localResourceStatus = localResourceStatus;
        this.charset = charset;
    }

    public static BaseResource from(LocalResourceStatus localResourceStatus) {
        if (SVNNodeKind.FILE.equals((Object)localResourceStatus.getNodeKind())) {
            return new BaseFile(localResourceStatus);
        }
        return new BaseFolder(localResourceStatus);
    }

    public String getName() {
        SVNUrl url = this.localResourceStatus.getUrl();
        return url != null ? url.getLastPathSegment() : "";
    }

    public String getContentIdentifier() {
        return SVNRevision.BASE.toString();
    }

    public byte[] asBytes() {
        return this.getContentIdentifier().getBytes();
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (!(target instanceof BaseResource)) {
            return false;
        }
        BaseResource base = (BaseResource)target;
        return base.isContainer() == this.isContainer() && base.getUrl().equals((Object)this.getUrl()) && base.getRevision() == this.getRevision();
    }

    public int hashCode() {
        return this.getUrl().hashCode() + this.getRevision().hashCode();
    }

    public ISVNRepositoryLocation getRepository() {
        return this.localResourceStatus.getRepository();
    }

    public SVNUrl getUrl() {
        return this.localResourceStatus.getUrl();
    }

    public SVNRevision.Number getLastChangedRevision() {
        return this.localResourceStatus.getLastChangedRevision();
    }

    public SVNRevision getRevision() {
        return SVNRevision.BASE;
    }

    public Date getDate() {
        return this.localResourceStatus.getLastChangedDate();
    }

    public String getAuthor() {
        return this.localResourceStatus.getLastCommitAuthor();
    }

    public File getFile() {
        return this.localResourceStatus.getFile();
    }

    public IPath getPath() {
        return this.localResourceStatus.getIPath();
    }

    public String getRepositoryRelativePath() {
        return SVNUrlUtils.getRelativePath((SVNUrl)this.getRepository().getUrl(), (SVNUrl)this.getUrl(), (boolean)true);
    }

    public ISVNLogMessage[] getLogMessages(SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit) throws TeamException {
        try {
            return this.getRepository().getSVNClient().getLogMessages(this.getFile(), revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit);
        }
        catch (SVNClientException e) {
            throw new TeamException("Failed in BaseResource.getLogMessages()", (Throwable)e);
        }
    }

    public boolean exists(IProgressMonitor monitor) throws TeamException {
        return true;
    }

    public ISVNRemoteFolder getParent() {
        return null;
    }

    public String getCharset() {
        return this.charset;
    }

    public String toString() {
        return this.localResourceStatus != null ? this.localResourceStatus.getPath() : "";
    }

    public IResource getResource() {
        try {
            return this.localResourceStatus.getResource();
        }
        catch (SVNException sVNException) {
            return null;
        }
    }
}

