/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.internal.ui.explorer.content;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.LinkedList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionSharingListener;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.server.internal.ui.ServerUIPlugin;
import org.eclipse.wst.rdb.server.internal.ui.dialogs.SQLExceptionDialog;
import org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup.ConnectServerAction;
import org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup.DisconnectServerAction;
import org.eclipse.wst.rdb.server.internal.ui.explorer.content.ConnectionNodeUtil;
import org.eclipse.wst.rdb.server.internal.ui.explorer.content.ServerNotFoundException;
import org.eclipse.wst.rdb.server.internal.ui.services.IServerStatusDecorationService;
import org.eclipse.wst.rdb.server.internal.ui.services.IServicesManager;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;

public class ServerExplorerConnectionSharingListener
implements ConnectionSharingListener {
    private static final String SQLMESSAGE = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.CONNECTION.SQLEXCEPTION.SQLMESSAGE");

    private void disconnect(ConnectionInfo info) {
        try {
            DisconnectServerAction action = new DisconnectServerAction();
            action.selectionChanged(null, (ISelection)new StructuredSelection((Object)ConnectionNodeUtil.getConnectionNode(info)));
            action.run(null);
        }
        catch (ServerNotFoundException serverNotFoundException) {}
    }

    private void reconnect(ConnectionInfo info) {
        try {
            ConnectServerAction action = new ConnectServerAction();
            action.selectionChanged(null, (ISelection)new StructuredSelection((Object)ConnectionNodeUtil.getConnectionNode(info)));
            action.run(null);
        }
        catch (ServerNotFoundException serverNotFoundException) {}
    }

    private IStatus[] getStatus(SQLException sqlException) {
        LinkedList<Status> statusList = new LinkedList<Status>();
        SQLException current = sqlException;
        do {
            statusList.add(new Status(4, ServerUIPlugin.getDefault().getBundle().getSymbolicName(), current.getErrorCode(), current.getMessage(), (Throwable)current));
        } while ((current = current.getNextException()) != null);
        return statusList.toArray(new IStatus[statusList.size()]);
    }

    public void sharedConnectionAdded(ConnectionInfo info, Connection connection) {
    }

    public void sharedConnectionRemove(ConnectionInfo info, Connection connection) {
    }

    public void sharedDatabaseAdded(final ConnectionInfo info, final Database database) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    IConnectionNode node = ConnectionNodeUtil.getConnectionNode(info);
                    node.shouldDisconnect(false);
                    IServicesManager.INSTANCE.getServerExplorerContentService().addNode(node, database);
                    IServerStatusDecorationService service = IServicesManager.INSTANCE.getServerStatusDecorationService();
                    if (service != null) {
                        service.refreshDecoration(new Object[]{node});
                    }
                }
                catch (ServerNotFoundException serverNotFoundException) {}
            }
        });
    }

    public void sharedDatabaseRemove(final ConnectionInfo info, final Database database) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    IConnectionNode node = ConnectionNodeUtil.getConnectionNode(info);
                    node.shouldDisconnect(true);
                    IServicesManager.INSTANCE.getServerExplorerContentService().removeNode(node, database);
                    node.removeAllChildren();
                }
                catch (ServerNotFoundException serverNotFoundException) {}
            }
        });
    }

    public void onSQLException(ConnectionInfo info, Connection connection, SQLException exception) {
        try {
            if (info.getSharedConnection() != connection || exception instanceof SQLWarning || !connection.isClosed()) {
                return;
            }
        }
        catch (SQLException sQLException) {}
        if (Display.getCurrent() == null) {
            this.disconnect(info);
            return;
        }
        MultiStatus status = new MultiStatus(ServerUIPlugin.getDefault().getBundle().getSymbolicName(), exception.getErrorCode(), this.getStatus(exception), SQLMESSAGE, null);
        SQLExceptionDialog dialog = new SQLExceptionDialog((IStatus)status);
        dialog.open();
        if (dialog.getReturnCode() == 2) {
            this.disconnect(info);
        } else if (dialog.getReturnCode() == 1) {
            this.disconnect(info);
            this.reconnect(info);
        }
    }
}

