/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.event.impl;

import com.ibm.etools.emf.event.Change;
import com.ibm.etools.emf.event.ChangeUtil;
import com.ibm.etools.emf.event.impl.ChangeImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ChangeHelper {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected Map oldToNewMap;
    protected Map newToOldMap;

    protected ChangeHelper(Map oldToNewMap) {
        this.oldToNewMap = oldToNewMap;
        this.newToOldMap = ChangeUtil.eINSTANCE.createInverseMap(oldToNewMap);
    }

    protected Map getOldToNewMap() {
        return this.oldToNewMap;
    }

    protected Map getNewToOldMap() {
        return this.newToOldMap;
    }

    protected Iterator getAllContents(Notifier n) {
        if (n instanceof EObject) {
            return ((EObject)n).eAllContents();
        }
        return EcoreUtil.getAllContents((Collection)((Resource)n).getContents());
    }

    protected boolean isAncestor(Notifier ancestor, EObject eObj) {
        if (ancestor instanceof EObject) {
            return EcoreUtil.isAncestor((EObject)((EObject)ancestor), (EObject)eObj);
        }
        return EcoreUtil.isAncestor((Resource)((Resource)ancestor), (EObject)eObj);
    }

    protected Change[] createChanges(Notifier oldTopObject, Notifier newTopObject) {
        EObject newEObject;
        BasicEList changeList = new BasicEList();
        Iterator o = this.getAllContents(oldTopObject);
        while (o.hasNext()) {
            ChangeImpl change;
            Object object = o.next();
            if (!(object instanceof EObject)) continue;
            EObject oldEObject = (EObject)object;
            newEObject = (EObject)this.getOldToNewMap().get(oldEObject);
            if (newEObject == null || !this.isAncestor(newTopObject, newEObject)) {
                change = new ChangeImpl(oldEObject, null);
                this.createSettingChanges(change, oldEObject, null);
                changeList.add(change);
                continue;
            }
            change = new ChangeImpl(oldEObject, newEObject);
            this.createSettingChanges(change, oldEObject, newEObject);
            if (change.getSettingList().size() <= 0) continue;
            changeList.add(change);
        }
        Iterator n = this.getAllContents(newTopObject);
        while (n.hasNext()) {
            Object object = n.next();
            if (!(object instanceof EObject)) continue;
            newEObject = (EObject)object;
            EObject oldEObject = (EObject)this.getNewToOldMap().get(newEObject);
            if (oldEObject != null && this.isAncestor(oldTopObject, oldEObject)) continue;
            ChangeImpl change = new ChangeImpl(null, newEObject);
            this.createSettingChanges(change, null, newEObject);
            changeList.add(change);
        }
        return changeList.toArray(new Change[0]);
    }

    protected boolean valuesMatch(Object oldVal, Object newVal, EStructuralFeature sf) {
        if (oldVal == null || newVal == null) {
            return oldVal == newVal;
        }
        if (sf != null && sf instanceof EAttribute) {
            return oldVal.equals(newVal);
        }
        return oldVal.equals(this.getNewToOldMap().get(newVal));
    }

    protected void createSettingChanges(ChangeImpl change, EObject oldObject, EObject newObject) {
        if (oldObject != null && newObject != null) {
            this.getContainerChanges(change, oldObject, newObject);
            this.getAttributeChanges(change, oldObject, newObject);
            this.getReferenceChanges(change, oldObject, newObject);
        }
    }

    protected void getContainerChanges(ChangeImpl change, EObject oldObj, EObject newObj) {
        EList changedSettings = change.getSettingList();
        EObject oldContainer = oldObj.eContainer();
        EObject newContainer = newObj.eContainer();
        if (oldContainer == null || newContainer == null) {
            if (oldContainer == newContainer) {
                return;
            }
            changedSettings.add(this.createSetting(change, null, oldContainer, oldContainer != null, newContainer, newContainer != null));
        } else if (!this.valuesMatch(oldContainer, newContainer, null)) {
            changedSettings.add(this.createSetting(change, null, oldContainer, oldContainer != null, newContainer, newContainer != null));
        }
    }

    protected void getAttributeChanges(ChangeImpl change, EObject oldObj, EObject newObj) {
        EClass c = oldObj.eClass();
        EList attribs = c.getEAllAttributes();
        this.getSettingChanges(change, oldObj, newObj, attribs);
    }

    protected void getReferenceChanges(ChangeImpl change, EObject oldObj, EObject newObj) {
        EClass c = oldObj.eClass();
        EList refs = c.getEAllReferences();
        this.getSettingChanges(change, oldObj, newObj, refs);
    }

    protected void getSettingChanges(ChangeImpl change, EObject oldObj, EObject newObj, EList features) {
        EList changedSettings = change.getSettingList();
        int f = 0;
        int size = features.size();
        while (f < size) {
            EStructuralFeature sf = (EStructuralFeature)features.get(f);
            Object oldVal = oldObj.eGet(sf);
            boolean oldIsSet = oldObj.eIsSet(sf);
            Object newVal = newObj.eGet(sf);
            boolean newIsSet = newObj.eIsSet(sf);
            if (oldIsSet != newIsSet) {
                changedSettings.add(this.createSetting(change, sf, oldVal, oldIsSet, newVal, newIsSet));
            } else if (oldIsSet) {
                if (sf.isMany()) {
                    EList oldList = (EList)oldVal;
                    EList newList = (EList)newVal;
                    boolean match = true;
                    if (oldList.size() == newList.size()) {
                        int v = 0;
                        int oldSize = oldList.size();
                        while (v < oldSize && match) {
                            Object newEntry;
                            Object oldEntry = oldList.get(v);
                            if (!this.valuesMatch(oldEntry, newEntry = newList.get(v), sf)) {
                                match = false;
                            }
                            ++v;
                        }
                    } else {
                        match = false;
                    }
                    if (!match) {
                        changedSettings.add(this.createSetting(change, sf, oldVal, oldIsSet, newVal, newIsSet));
                    }
                } else if (!this.valuesMatch(oldVal, newVal, sf)) {
                    changedSettings.add(this.createSetting(change, sf, oldVal, oldIsSet, newVal, newIsSet));
                }
            }
            ++f;
        }
    }

    protected Change.Setting createSetting(ChangeImpl change, EStructuralFeature feature, Object oldVal, boolean isOldSet, Object newVal, boolean isNewSet) {
        ChangeImpl changeImpl = change;
        changeImpl.getClass();
        ChangeImpl.SettingImpl setting = new ChangeImpl.SettingImpl(changeImpl, feature, oldVal, isOldSet, newVal, isNewSet);
        setting.setAddedValues(this.getSettingDifferences(feature, this.newToOldMap, oldVal, isOldSet, newVal, isNewSet));
        setting.setRemovedValues(this.getSettingDifferences(feature, this.oldToNewMap, newVal, isNewSet, oldVal, isOldSet));
        return setting;
    }

    protected List getSettingDifferences(EStructuralFeature feature, Map refToBaseMap, Object baseValue, boolean isBaseSet, Object refValue, boolean isRefSet) {
        BasicEList diffs = new BasicEList();
        if (!isBaseSet && isRefSet) {
            if (feature != null && feature.isMany()) {
                diffs.addAll((List)refValue);
            } else {
                diffs.add(refValue);
            }
        } else if (isBaseSet && isRefSet) {
            if (feature != null && feature.isMany()) {
                List baseList = (List)baseValue;
                List refList = (List)refValue;
                Iterator r = refList.iterator();
                while (r.hasNext()) {
                    Object baseObj;
                    Object refObj = r.next();
                    Object object = baseObj = feature instanceof EReference ? refToBaseMap.get(refObj) : refObj;
                    if (baseObj == null || !baseList.contains(baseObj)) {
                        diffs.add(refObj);
                    }
                    if (diffs.contains(refObj) || feature.isUnique()) continue;
                    int refCount = this.getCount(refObj, refList);
                    int baseCount = this.getCount(baseObj, baseList);
                    int i = 0;
                    while (i < refCount - baseCount) {
                        diffs.add(refObj);
                        ++i;
                    }
                }
            } else {
                Object baseObj;
                Object refObj = refValue;
                Object object = baseObj = feature instanceof EReference ? refToBaseMap.get(refObj) : baseValue;
                if (baseObj != refObj && refObj != null) {
                    diffs.add(refObj);
                }
            }
        }
        return diffs;
    }

    protected int getCount(Object obj, List list) {
        int count = 0;
        boolean start = false;
        int i = 0;
        int size = list.size();
        while (i < size) {
            if (list.get(i).equals(obj)) {
                ++count;
            }
            ++i;
        }
        return count;
    }
}

