/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.connection.internal.ui.wizards.shared;

import java.io.File;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.wst.rdb.connection.internal.ui.factories.RSCCoreUIWidgetFactory;
import org.eclipse.wst.rdb.connection.internal.ui.providers.IServerConnectionInformation;
import org.eclipse.wst.rdb.connection.internal.ui.providers.IServerConnectionUIProvider;
import org.eclipse.wst.rdb.connection.internal.ui.util.resource.ResourceLoader;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.ConnectionWizardProperties;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.NewCWUidPwd;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.NewConnectionWizard;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.RDBWizardPage;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.helper.ConnectionUIHelper;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.shared.DatabaseProductVersion;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinitionRegistry;

public class NewCWJDBCPage
extends RDBWizardPage
implements Listener,
SelectionListener,
IServerConnectionInformation {
    private static final ResourceLoader resource = ResourceLoader.INSTANCE;
    private static final String JDBC_CONNECTION_NAME_GROUP = resource.queryString("JDBC_CONNECTION_NAME_GROUP");
    private static final String JDBC_CONNECTION_NAME_DEFAULT = resource.queryString("JDBC_CONNECTION_NAME_DEFAULT");
    private static final String JDBC_CONNECTION_NAME_LABEL = resource.queryString("JDBC_CONNECTION_NAME_LABEL");
    private static final String CUI_NEWCW_VALIDATE_CONNECTION_NAME_EMPTY = resource.queryString("CUI_NEWCW_VALIDATE_CONNECTION_NAME_EMPTY");
    private static final String CUI_NEWCW_VALIDATE_CONNECTION_NAME_EXIST = resource.queryString("CUI_NEWCW_VALIDATE_CONNECTION_NAME_EXIST");
    protected String MATCH = "match";
    protected String KEY1 = "child1";
    protected String KEY2 = "child2";
    public final String JDBC_DRIVER_CUSTOM_PROPERTY_NAME = "JDBC_DRIVER";
    protected int contentOptions;
    protected boolean hasBeenHere = false;
    private boolean informationProviderComplete = false;
    private boolean validateConnectionName = true;
    private boolean isFinalConnection;
    private String url = "";
    private String loadingPath = "";
    private String driverClassName = "";
    private String databaseName;
    private List existingConnectionNamesList;
    protected Label dbmsLabel;
    protected Tree dbmsTree;
    protected Label driverLabel;
    protected Combo driverCombo;
    protected Group detailsGroup;
    protected StackLayout stack;
    protected Button testConnection;
    private Label connectionNameLabel;
    private Text connectionNameText;
    private Button connectionNameCheck;
    private ConnectionUIHelper connectionUIhelper;
    private HashMap providerConnectionMap = new HashMap();
    private NewCWUidPwd userPanel;
    private IServerConnectionUIProvider currentDriverUIPanel;
    private DatabaseDefinition definition;
    private ConnectionWizardProperties connectionProperties = null;
    private DatabaseProductVersion[] allowedDatabaseProductVersions = null;
    private Properties customProperties = new Properties();
    private boolean isServerRecognized = true;
    private ScrolledComposite detailsScrolledComposite;

    public NewCWJDBCPage(String name) {
        this(name, NewCWJDBCPage.getExistingConnectionNamesList());
    }

    public NewCWJDBCPage(String name, List existingConnectionNamesList) {
        this(name, 0, existingConnectionNamesList);
    }

    public NewCWJDBCPage(String name, int contentOptions, List existingConnectionNamesList) {
        super(name);
        this.setTitle(this.getString("CUI_NEWCW_JDBC_TITLE_UI_"));
        this.setDescription(this.getString("CUI_NEWCW_JDBC_DESC_UI_"));
        this.contentOptions = contentOptions;
        this.existingConnectionNamesList = existingConnectionNamesList;
    }

    public void createControl(Composite parent) {
        Composite composite = RSCCoreUIWidgetFactory.INSTANCE.createComposite(parent, 0);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.wst.rdb.connection.ui.infopop.rdbconn_wiz_connparam");
        GridLayout layout = new GridLayout();
        GridData gridData = new GridData(1808);
        layout.numColumns = 2;
        layout.verticalSpacing = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gridData);
        this.initializeDialogUnits((Control)composite);
        this.createGUI(composite, RSCCoreUIWidgetFactory.INSTANCE);
        this.setControl((Control)composite);
        this.setPageComplete(false);
        this.populateGUI();
        this.hasBeenHere = true;
    }

    protected void populateGUI() {
        WorkbenchHelp.setHelp((Control)this.dbmsTree, (String)"org.eclipse.wst.rdb.connection.ui.infopop.rdbconn_wiz_connparam");
        this.addListeners();
        this.fillTree(this.dbmsTree);
        this.setPageDefaults();
        this.setPageComplete(this.determinePageCompletion());
    }

    protected void createGUI(Composite parent, RSCCoreUIWidgetFactory factory) {
        Group connectionGroup = factory.createGroup(parent, JDBC_CONNECTION_NAME_GROUP, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        connectionGroup.setLayoutData((Object)gd);
        connectionGroup.setLayout((Layout)layout);
        this.connectionNameCheck = factory.createButton((Composite)connectionGroup, 32);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.connectionNameCheck.setLayoutData((Object)gd);
        this.connectionNameCheck.setText(JDBC_CONNECTION_NAME_DEFAULT);
        this.connectionNameCheck.setSelection(true);
        this.connectionNameCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewCWJDBCPage.this.connectionNameText.setEnabled(!NewCWJDBCPage.this.connectionNameCheck.getSelection());
                NewCWJDBCPage.this.setDatabaseName(NewCWJDBCPage.this.databaseName);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.connectionNameLabel = factory.createLabel((Composite)connectionGroup, 0);
        this.connectionNameLabel.setText(JDBC_CONNECTION_NAME_LABEL);
        this.connectionNameText = factory.createText((Composite)connectionGroup, 2052);
        gd = new GridData(768);
        this.connectionNameText.setLayoutData((Object)gd);
        this.connectionNameText.setEnabled(false);
        this.dbmsLabel = factory.createLabel(parent, 0);
        this.dbmsLabel.setText(this.getString("CUI_NEWCW_DBMS_LBL_UI_"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.dbmsLabel.setLayoutData((Object)gd);
        this.dbmsTree = factory.createTree(parent, 2820);
        gd = new GridData(175, -1);
        gd.horizontalAlignment = 1;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 1;
        this.dbmsTree.setLayoutData((Object)gd);
        Composite rightside = factory.createComposite(parent, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        rightside.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 1;
        rightside.setLayoutData((Object)gd);
        this.driverLabel = factory.createLabel(rightside, 0);
        this.driverLabel.setText(this.getString("CUI_NEWCW_JDBC_DRV_LBL_UI_"));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.driverLabel.setLayoutData((Object)gd);
        this.driverCombo = factory.createCombo(rightside, 2060);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 1;
        this.driverCombo.setLayoutData((Object)gd);
        this.detailsScrolledComposite = new ScrolledComposite(rightside, 768);
        this.detailsScrolledComposite.setExpandHorizontal(true);
        this.detailsScrolledComposite.setExpandVertical(true);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.detailsScrolledComposite.setLayoutData((Object)gd);
        this.detailsGroup = factory.createGroup((Composite)this.detailsScrolledComposite, this.getString("CUI_NEWCW_DETAILS_GROUP_UI_"), 0);
        this.stack = new StackLayout();
        this.stack.marginWidth = 3;
        this.stack.marginHeight = 3;
        this.detailsGroup.setLayout((Layout)this.stack);
        this.detailsScrolledComposite.setContent((Control)this.detailsGroup);
        this.userPanel = new NewCWUidPwd(this, this.contentOptions);
        Composite userDetails = this.userPanel.getComposite(parent, factory);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        userDetails.setLayoutData((Object)gd);
        this.testConnection = factory.createButton(parent, 8);
        this.testConnection.setText(this.getString("CUI_NEWCW_JDBC_TESTCONNECTION_UI_"));
        this.detailsGroup.setSize(this.detailsGroup.computeSize(-1, -1));
    }

    protected void fillTree(Tree tree) {
        boolean isDatabaseManagersFiltered = false;
        Hashtable<String, String> productVersionsTable = new Hashtable<String, String>();
        tree.removeAll();
        if (this.allowedDatabaseProductVersions != null) {
            isDatabaseManagersFiltered = true;
            int index = 0;
            while (index < this.allowedDatabaseProductVersions.length) {
                productVersionsTable.put(String.valueOf(this.allowedDatabaseProductVersions[index].getProduct()) + this.allowedDatabaseProductVersions[index].getVersion(), this.allowedDatabaseProductVersions[index].getProduct());
                ++index;
            }
        }
        DatabaseDefinitionRegistry dbDefReg = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
        Iterator productIterator = dbDefReg.getConnectibleProducts();
        while (productIterator.hasNext()) {
            String databaseEngineName = (String)productIterator.next();
            if (isDatabaseManagersFiltered && !productVersionsTable.contains(databaseEngineName)) continue;
            TreeItem item = new TreeItem(tree, 0);
            item.setData((Object)databaseEngineName);
            Iterator versionIterator = dbDefReg.getConnectibleVersions(databaseEngineName);
            while (versionIterator.hasNext()) {
                String version = (String)versionIterator.next();
                String displayEngineName = dbDefReg.getDefinition(databaseEngineName, version).getProductDisplayString();
                if (item.getText() == null || item.getText().length() == 0) {
                    item.setText(displayEngineName);
                }
                String displayVersionName = dbDefReg.getDefinition(databaseEngineName, version).getVersionDisplayString();
                if (isDatabaseManagersFiltered && !productVersionsTable.containsKey(String.valueOf(databaseEngineName) + version)) continue;
                TreeItem subItem = new TreeItem(item, 0);
                subItem.setData((Object)version);
                subItem.setText(displayVersionName);
            }
        }
    }

    protected void addListeners() {
        this.connectionNameText.removeListener(24, (Listener)this);
        this.dbmsTree.removeSelectionListener((SelectionListener)this);
        this.driverCombo.removeListener(24, (Listener)this);
        this.testConnection.removeListener(13, (Listener)this);
        this.userPanel.removeListeners();
        this.dbmsTree.addSelectionListener((SelectionListener)this);
        this.driverCombo.addListener(24, (Listener)this);
        this.testConnection.addListener(13, (Listener)this);
        this.connectionNameText.addListener(24, (Listener)this);
        this.userPanel.addListeners();
    }

    protected void setPageDefaults() {
        this.internalLoadWidgetValues();
        this.enableAll();
    }

    protected void enableAll() {
        boolean dd;
        boolean vt;
        boolean bl = vt = (this.contentOptions & 8) == 0;
        if (!vt) {
            this.dbmsLabel.setEnabled(false);
            this.dbmsTree.setEnabled(false);
        }
        boolean bl2 = dd = (this.contentOptions & 0x10) == 0;
        if (!dd) {
            this.driverLabel.setEnabled(false);
            this.driverCombo.setEnabled(false);
        }
    }

    private static boolean isConnectionNameUnique(Collection existed, String baseName) {
        boolean isUnique = true;
        Iterator it = existed.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!name.toLowerCase().equals(baseName.toLowerCase())) continue;
            isUnique = false;
            break;
        }
        return isUnique;
    }

    public static String createUniqueConnectionName(Collection existed, String baseName) {
        if (!NewCWJDBCPage.isConnectionNameUnique(existed, baseName)) {
            int postfix = 1;
            String newBaseName = String.valueOf(baseName) + postfix;
            while (!NewCWJDBCPage.isConnectionNameUnique(existed, newBaseName)) {
                newBaseName = String.valueOf(baseName) + ++postfix;
            }
            return newBaseName;
        }
        return baseName;
    }

    private void setConnectionName(String connectionName) {
        String uniqueName = NewCWJDBCPage.createUniqueConnectionName(this.existingConnectionNamesList, connectionName);
        if (this.existingConnectionNamesList.contains(uniqueName.toLowerCase())) {
            uniqueName = String.valueOf(uniqueName) + 1;
        }
        this.connectionNameText.setText(uniqueName);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (!this.hasBeenHere) {
                this.hasBeenHere = true;
                this.populateGUI();
            } else {
                this.setPageComplete(this.determinePageCompletion());
            }
        }
        super.setVisible(visible);
    }

    protected boolean determinePageCompletion() {
        boolean ok;
        boolean bl = ok = this.validatePage() && this.currentDriverUIPanel.determinePageCompletion() && this.validateConnectionName() && this.userPanel.determinePageCompletion();
        if (ok) {
            this.setErrorMessage(null);
        }
        if (this.testConnection != null) {
            this.testConnection.setEnabled(ok);
        }
        return ok;
    }

    protected boolean validatePage() {
        return this.beenHere() && this.validateDbms() && this.validateDriver();
    }

    protected boolean beenHere() {
        return this.hasBeenHere;
    }

    protected boolean validateDbms() {
        if (this.dbmsTree.getSelectionCount() < 1) {
            this.setErrorMessage(this.getString("CUI_NEWCW_VALIDATE_DBMS_REQ_UI_"));
            return false;
        }
        return true;
    }

    protected boolean validateDriver() {
        if (this.driverCombo.getText().length() < 1) {
            this.setErrorMessage(this.getString("CUI_NEWCW_VALIDATE_DRIVER_REQ_UI_"));
            return false;
        }
        return true;
    }

    protected String[] getClassLocations(String classList) {
        StringTokenizer str = new StringTokenizer(classList, File.pathSeparator, false);
        String[] jFiles = new String[str.countTokens()];
        int i = 0;
        while (i < jFiles.length) {
            jFiles[i] = str.nextToken();
            ++i;
        }
        return jFiles;
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this.testConnection) {
            this.performTestConnection(true, true);
            return;
        }
        if (source == this.driverCombo) {
            this.customProperties.clear();
            this.updateDetails();
        }
        this.setPageComplete(this.determinePageCompletion());
    }

    private boolean validateConnectionName() {
        if (this.connectionNameText.getText().equals("")) {
            this.setErrorMessage(CUI_NEWCW_VALIDATE_CONNECTION_NAME_EMPTY);
            return false;
        }
        if (this.existingConnectionNamesList.contains(this.connectionNameText.getText().toLowerCase())) {
            String message = MessageFormat.format(CUI_NEWCW_VALIDATE_CONNECTION_NAME_EXIST, this.connectionNameText.getText());
            this.setErrorMessage(message);
            return false;
        }
        return true;
    }

    protected void updateDetails() {
        String driverName = this.driverCombo.getText();
        this.currentDriverUIPanel = this.connectionUIhelper.getUIProvider(driverName);
        if (this.currentDriverUIPanel != null) {
            this.currentDriverUIPanel.setServerConnectionInformation(this);
            this.currentDriverUIPanel.setDatabaseDefinition(this.definition);
            this.currentDriverUIPanel.setWizardPage(this);
            this.stack.topControl = this.currentDriverUIPanel.getServerConnectionUI((Composite)this.detailsGroup);
            this.currentDriverUIPanel.determinePageCompletion();
            this.detailsGroup.layout();
            this.detailsScrolledComposite.setMinSize(this.detailsGroup.computeSize(-1, -1));
        }
    }

    public void widgetSelected(SelectionEvent e) {
        TreeItem item = (TreeItem)e.item;
        this.updateDrivers(item);
    }

    private DatabaseDefinition getDefinition(TreeItem item) {
        if (item.getParentItem() != null) {
            String product = (String)item.getParentItem().getData();
            String version = (String)item.getData();
            return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(product, version);
        }
        return null;
    }

    public DatabaseDefinition getCurrentDatabaseDefinition() {
        return this.definition;
    }

    protected void updateDrivers(TreeItem item) {
        if (item.getParentItem() != null && item.getItems().length == 0) {
            this.definition = this.getDefinition(item);
            if (this.definition != null) {
                this.driverCombo.removeListener(24, (Listener)this);
                this.driverCombo.removeAll();
                this.connectionUIhelper = new ConnectionUIHelper(this.definition.getProduct(), this.definition.getVersion(), this.providerConnectionMap);
                String[] names = this.connectionUIhelper.getDriverNames();
                int i = 0;
                int n = names.length;
                while (i < n) {
                    this.driverCombo.add(names[i]);
                    ++i;
                }
                this.driverCombo.addListener(24, (Listener)this);
                String defaultDriver = this.connectionUIhelper.getDefaultDriver();
                if (!this.connectionUIhelper.getDefaultDriver().equals("")) {
                    this.driverCombo.select(this.driverCombo.indexOf(defaultDriver));
                } else {
                    this.driverCombo.select(0);
                }
                this.updateDetails();
            }
        }
        this.setPageComplete(this.determinePageCompletion());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setConnectionDetails(ConnectionInfo connection) {
        connection.setDatabaseName(this.databaseName);
        connection.setURL(this.url);
        connection.setDriverClassName(this.driverClassName);
        connection.setLoadingPath(this.loadingPath);
        this.setCustomProperty("JDBC_DRIVER", this.driverCombo.getText());
        Enumeration<?> customProperties = this.customProperties.propertyNames();
        while (customProperties.hasMoreElements()) {
            String name = (String)customProperties.nextElement();
            connection.setCustomProperty(name, this.customProperties.getProperty(name));
        }
        this.userPanel.setConnectionDetails(connection);
    }

    public boolean isPageComplete() {
        return this.determinePageCompletion() && super.isPageComplete();
    }

    protected void internalLoadWidgetValues() {
        this.getWizard();
        Object dialogSettings = null;
        if (dialogSettings != null && dialogSettings.get("Database Product") != null) {
            String driver;
            String product = dialogSettings.get("Database Product");
            String version = dialogSettings.get("Database Version");
            TreeItem item = this.getTreeItem(this.dbmsTree.getItems(), RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(product, version));
            if (item != null) {
                this.dbmsTree.setSelection(new TreeItem[]{item});
                this.updateDrivers(item);
            }
            if ((driver = dialogSettings.get("Driver")) != null) {
                this.driverCombo.setText(driver);
            }
        } else {
            TreeItem item = this.getFirstDatabaseDefinition(this.dbmsTree.getItems());
            if (item != null) {
                this.dbmsTree.setSelection(new TreeItem[]{item});
                this.updateDrivers(item);
            }
        }
        this.userPanel.internalLoadWidgetValues();
    }

    private TreeItem getTreeItem(TreeItem[] items, DatabaseDefinition definition) {
        TreeItem result = null;
        if (items != null) {
            int i = 0;
            int n = items.length;
            while (i < n && result == null) {
                DatabaseDefinition currentDefinition = this.getDefinition(items[i]);
                if (currentDefinition != null && currentDefinition.equals(definition)) {
                    result = items[i];
                    break;
                }
                result = this.getTreeItem(items[i].getItems(), definition);
                ++i;
            }
        }
        return result;
    }

    private TreeItem getFirstDatabaseDefinition(TreeItem[] items) {
        TreeItem result = null;
        if (items != null) {
            int i = 0;
            int n = items.length;
            while (i < n && result == null) {
                DatabaseDefinition currentDefinition = this.getDefinition(items[i]);
                if (currentDefinition != null) {
                    result = items[i];
                    break;
                }
                result = this.getFirstDatabaseDefinition(items[i].getItems());
                ++i;
            }
        }
        return result;
    }

    public void internalSaveWidgetValues() {
        IDialogSettings dialogSettings = this.getWizard().getDialogSettings();
        if (dialogSettings != null) {
            dialogSettings.put("Database Product", this.definition.getProduct());
            dialogSettings.put("Database Version", this.definition.getVersion());
            dialogSettings.put("Driver", this.driverCombo.getText());
            dialogSettings.put("DatabaseName", this.databaseName);
            dialogSettings.put("URL", this.url);
            dialogSettings.put("LoadingPath", this.loadingPath);
            dialogSettings.put("DriverClassName", this.driverClassName);
            this.userPanel.internalSaveWidgetValues();
        }
    }

    public void setInformationComplete(boolean value) {
        this.informationProviderComplete = value;
        this.setPageComplete(this.determinePageCompletion());
    }

    public void setDatabaseName(String databaseName) {
        if (databaseName != null) {
            this.databaseName = databaseName;
            String connectionName = this.connectionNameCheck.getSelection() ? this.databaseName : this.connectionNameText.getText();
            this.setConnectionName(connectionName);
        }
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getURL() {
        return this.url;
    }

    public String getConnectionName() {
        if (this.connectionNameText != null) {
            return this.connectionNameText.getText();
        }
        return "";
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setLoadingPath(String loadingPath) {
        this.loadingPath = loadingPath;
    }

    public String getLoadingPath() {
        return this.loadingPath;
    }

    public void setDefaultDatabaseDefinition(DatabaseDefinition databaseDefinition) {
        this.definition = databaseDefinition;
    }

    public boolean performTestConnection(boolean showSuccessfulMessage) {
        return this.performTestConnection(showSuccessfulMessage, false);
    }

    public boolean performTestConnection(boolean showSuccessfulMessage, boolean showServerMismatchWarning) {
        this.isServerRecognized = true;
        ConnectionInfo connection = RDBCorePlugin.getDefault().getConnectionManager().createConnectionInfo(this.definition, NewCWJDBCPage.createUniqueConnectionName(NewCWJDBCPage.getExistingConnectionNamesList(), this.getConnectionName()));
        this.setConnectionDetails(connection);
        try {
            try {
                this.getContainer().run(true, true, this.getTestRunnable(connection, 2, showSuccessfulMessage, showServerMismatchWarning));
            }
            catch (InterruptedException interruptedException) {
                if (connection != null) {
                    RDBCorePlugin.getDefault().getConnectionManager().removeConnectionInfo(connection.getName());
                }
            }
        }
        catch (Exception e) {
            MessageDialog.openError(null, (String)RDBWizardPage.getBundle().getString("CUI_WIZARD_ERRTITLE_UI_"), (String)NewConnectionWizard.getMessages(e));
            return false;
        }
        return true;
    }

    public IRunnableWithProgress getTestRunnable(final ConnectionInfo connection, int conType, final boolean showStatus, final boolean showMismatchWarning) {
        IRunnableWithProgress progMonitor = new IRunnableWithProgress(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public void run(IProgressMonitor monitor) {
                block12: {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask("", 3);
                    if (showStatus) {
                        monitor.setTaskName(NewCWJDBCPage.access$3().queryString("CUI_NEWCW_TEST_CONNECTION_PROGRESS_BAR_MESSAGE_UI_"));
                    }
                    monitor.worked(1);
                    try {
                        remoteServerProduct = "";
                        remoteServerVersion = "";
                        if (connection.getSharedConnection() == null) {
                            cnx = connection.connect();
                            recognizedDatabaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().recognize(cnx);
                            if (!(recognizedDatabaseDefinition == null || recognizedDatabaseDefinition.getProduct().equals(connection.getDatabaseDefinition().getProduct()) && recognizedDatabaseDefinition.getVersion().equals(connection.getDatabaseDefinition().getVersion()))) {
                                NewCWJDBCPage.access$4(NewCWJDBCPage.this, false);
                                remoteServerProduct = recognizedDatabaseDefinition.getProduct();
                                remoteServerVersion = recognizedDatabaseDefinition.getVersion();
                            }
                            if (cnx == null) {
                                throw new Exception(RDBWizardPage.getBundle().getString("CUI_TESTCONNECTION_ERROR_UI_"));
                            }
                        }
                        if (!NewCWJDBCPage.access$5(NewCWJDBCPage.this) && showMismatchWarning) {
                            message = "";
                            message = String.valueOf(message) + NewCWJDBCPage.access$3().queryString("_UI_MESSAGE_MISMATCH_WARNING");
                            message = String.valueOf(message) + NewCWJDBCPage.access$3().queryString("_UI_MESSAGE_SPECIFIED_DB_MANAGER") + connection.getDatabaseDefinition().getProductDisplayString() + " " + connection.getDatabaseDefinition().getVersion() + "\n";
                            message = String.valueOf(message) + NewCWJDBCPage.access$3().queryString("_UI_MESSAGE_REMOTE_SERVER") + remoteServerProduct + " " + remoteServerVersion + "\n\n";
                            message = String.valueOf(message) + NewCWJDBCPage.access$3().queryString("_UI_MESSAGE_CONTINUE_QUESTION");
                            question = new DisplayQuestion(NewCWJDBCPage.access$3().queryString("_UI_TITLE_MISMATCH_DIALOG"), message);
                            NewCWJDBCPage.this.getShell().getDisplay().syncExec((Runnable)question);
                            if (!question.getResult()) {
                                throw new Exception(RDBWizardPage.getBundle().getString("CUI_TESTCONNECTION_ERROR_UI_"));
                            }
                        } else if (showStatus) {
                            title = RDBWizardPage.getBundle().getString("CUI_TESTCONNECTION_TITLE_UI_");
                            message = RDBWizardPage.getBundle().getString("CUI_TESTCONNECTION_SUCCESS_UI_");
                            message = MessageFormat.format(message, new String[]{connection.getDatabaseDefinition().getProductDisplayString()});
                            monitor.worked(2);
                            NewCWJDBCPage.this.getShell().getDisplay().asyncExec((Runnable)new DisplayMessage(title, message));
                        }
                        NewCWJDBCPage.access$6(NewCWJDBCPage.this, true);
                        RDBCorePlugin.getDefault().getConnectionManager().removeConnectionInfo(connection.getName());
                        break block12;
                    }
                    catch (Exception e) {
                        monitor.worked(2);
                        RDBCorePlugin.getDefault().getConnectionManager().removeConnectionInfo(connection.getName());
                        NewCWJDBCPage.access$6(NewCWJDBCPage.this, false);
                        if (!NewCWJDBCPage.access$5(NewCWJDBCPage.this)) break block12;
                        title = RDBWizardPage.getBundle().getString("CUI_TESTCONNECTION_TITLE_UI_");
                        s = "";
                        t /* !! */  = e;
                        ** while (t /* !! */  != null)
                    }
lbl-1000:
                    // 1 sources

                    {
                        s = String.valueOf(s) + System.getProperties().getProperty("line.separator") + t /* !! */ .getMessage();
                        t /* !! */  = t /* !! */  instanceof SQLException != false && ((SQLException)t /* !! */ ).getNextException() != t /* !! */  ? ((SQLException)t /* !! */ ).getNextException() : (t /* !! */ .getCause() != t /* !! */  ? t /* !! */ .getCause() : null);
                        continue;
                    }
lbl51:
                    // 1 sources

                    message = RDBWizardPage.getBundle().getString("CUI_TESTCONNECTION_FAILURE_UI_");
                    message = MessageFormat.format(message, new String[]{connection.getDatabaseDefinition().getProductDisplayString(), s});
                    NewCWJDBCPage.this.getShell().getDisplay().asyncExec((Runnable)new DisplayMessage(title, message));
                }
                monitor.setTaskName(RDBWizardPage.getBundle().getString("CUI_CREATECONDONE_UI_"));
                monitor.worked(3);
                monitor.done();
            }
        };
        return progMonitor;
    }

    public boolean isFinalConnection() {
        return this.isFinalConnection;
    }

    public ConnectionInfo getConnection() {
        ConnectionInfo connection = RDBCorePlugin.getDefault().getConnectionManager().createConnectionInfo(this.definition, this.getConnectionName());
        this.setConnectionDetails(connection);
        return connection;
    }

    public static List getExistingConnectionNamesList() {
        ConnectionInfo[] infos = RDBCorePlugin.getDefault().getConnectionManager().getAllNamedConnectionInfo();
        ArrayList<String> nameList = new ArrayList<String>(infos.length);
        int i = 0;
        int n = infos.length;
        while (i < n) {
            if (!nameList.contains(infos[i].getName())) {
                nameList.add(infos[i].getName().toLowerCase());
            }
            ++i;
        }
        String[] names = nameList.toArray(new String[nameList.size()]);
        return Arrays.asList(names);
    }

    public void updateExistingConnectionNamesList() {
        this.existingConnectionNamesList = NewCWJDBCPage.getExistingConnectionNamesList();
    }

    public void setConnectionProperties(ConnectionWizardProperties connectionProperties) {
        String driver;
        TreeItem select;
        if (!this.hasBeenHere) {
            this.populateGUI();
            this.hasBeenHere = true;
        }
        if (connectionProperties.getConnectionName() != null) {
            this.setConnectionName(connectionProperties.getConnectionName());
            this.connectionNameCheck.setSelection(false);
            this.connectionNameText.setEnabled(true);
        }
        String product = connectionProperties.getProduct();
        String version = connectionProperties.getVersion();
        if (product != null && version != null && (select = this.findDBMSItem(this.dbmsTree, product, version)) != null) {
            this.dbmsTree.setSelection(new TreeItem[]{select});
            this.dbmsTree.showItem(select.getParentItem());
            this.updateDrivers(select);
        }
        if (this.driverCombo != null && (driver = connectionProperties.getDriverName()) != null) {
            this.driverCombo.select(this.driverCombo.indexOf(driver));
        }
        if (connectionProperties.getDatabaseName() != null) {
            this.setDatabaseName(connectionProperties.getDatabaseName());
        }
        if (connectionProperties.getClassLocation() != null) {
            this.setLoadingPath(connectionProperties.getClassLocation());
        }
        if (connectionProperties.getDriverClassName() != null) {
            this.setDriverClassName(connectionProperties.getDriverClassName());
        }
        if (connectionProperties.getURL() != null) {
            this.setURL(connectionProperties.getURL());
        }
        if (connectionProperties.getUserID() != null && this.userPanel != null) {
            this.userPanel.setUserId(connectionProperties.getUserID());
        }
        if (connectionProperties.getPassword() != null && this.userPanel != null) {
            this.userPanel.setPassword(connectionProperties.getPassword());
        }
        if (connectionProperties.getCustomProperties() != null) {
            this.customProperties = connectionProperties.getCustomProperties();
        }
        this.currentDriverUIPanel.loadProperties();
    }

    protected TreeItem findDBMSItem(Tree tree, String product, String version) {
        TreeItem foundNode = null;
        if (tree != null) {
            TreeItem[] productNodes = tree.getItems();
            int productIndex = 0;
            while (productIndex < productNodes.length) {
                if (productNodes[productIndex].getText().equals(product)) {
                    TreeItem[] versionNodes = productNodes[productIndex].getItems();
                    int versionIndex = 0;
                    while (versionIndex < versionNodes.length) {
                        if (versionNodes[versionIndex].getText().equals(version)) {
                            foundNode = versionNodes[versionIndex];
                        }
                        ++versionIndex;
                    }
                }
                ++productIndex;
            }
        }
        return foundNode;
    }

    public void setAllowedProductVersions(DatabaseProductVersion[] allowedDatabaseProductVersions) {
        this.allowedDatabaseProductVersions = allowedDatabaseProductVersions;
        if (this.dbmsTree != null) {
            this.populateGUI();
        }
    }

    public void setCustomProperty(String name, String value) {
        if (this.customProperties.containsKey(name)) {
            this.customProperties.remove(name);
            this.customProperties.put(name, value);
        } else {
            this.customProperties.put(name, value);
        }
    }

    public String getCustomProperty(String key) {
        if (this.customProperties.containsKey(key)) {
            return (String)this.customProperties.get(key);
        }
        return "";
    }

    static /* synthetic */ ResourceLoader access$3() {
        return resource;
    }

    static /* synthetic */ void access$4(NewCWJDBCPage newCWJDBCPage, boolean bl) {
        newCWJDBCPage.isServerRecognized = bl;
    }

    static /* synthetic */ boolean access$5(NewCWJDBCPage newCWJDBCPage) {
        return newCWJDBCPage.isServerRecognized;
    }

    static /* synthetic */ void access$6(NewCWJDBCPage newCWJDBCPage, boolean bl) {
        newCWJDBCPage.isFinalConnection = bl;
    }

    public class DisplayMessage
    implements Runnable {
        protected String title;
        protected String message;

        public DisplayMessage(String title, String message) {
            this.title = title;
            this.message = message;
        }

        public void run() {
            MessageDialog.openInformation((Shell)NewCWJDBCPage.this.getShell(), (String)this.title, (String)this.message);
        }
    }

    public class DisplayQuestion
    implements Runnable {
        protected String title;
        protected String message;
        protected boolean result = true;

        public DisplayQuestion(String title, String message) {
            this.title = title;
            this.message = message;
        }

        public boolean getResult() {
            return this.result;
        }

        public void run() {
            this.result = MessageDialog.openQuestion((Shell)NewCWJDBCPage.this.getShell(), (String)this.title, (String)this.message);
        }
    }
}

