/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.classgen;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.jdt.ui.actions.AddUnimplementedConstructorsAction;
import org.eclipse.jdt.ui.actions.OverrideMethodsAction;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class EjbBuilder {
    protected IProgressMonitor monitor;
    protected IPackageFragmentRoot packageFragmentRoot;
    protected String packageName = "";
    protected String typeName = "";
    protected String typeStub;
    protected String typeComment;
    protected String methodStub;
    protected String fields;
    protected boolean createInheritedMethods;
    protected boolean createInheritedConstructors;
    protected IConfigurationElement configurationElement;
    IType fCreatedType;
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createType() throws CoreException, InterruptedException {
        block10: {
            this.monitor = this.getMonitor();
            this.monitor.beginTask("Creating a new type", 10);
            ICompilationUnit createdWorkingCopy = null;
            try {
                String content;
                IPackageFragmentRoot root = this.getPackageFragmentRoot();
                IPackageFragment pack = root.createPackageFragment(this.packageName, true, this.monitor);
                this.monitor.worked(1);
                String clName = this.typeName;
                int indent = 0;
                String lineDelimiter = null;
                lineDelimiter = System.getProperty("line.separator", "\n");
                ICompilationUnit parentCU = pack.getCompilationUnit(String.valueOf(clName) + ".java");
                if (!parentCU.exists()) {
                    parentCU = pack.createCompilationUnit(String.valueOf(clName) + ".java", "", false, (IProgressMonitor)new SubProgressMonitor(this.monitor, 2));
                }
                if ((content = CodeGeneration.getCompilationUnitContent((ICompilationUnit)(createdWorkingCopy = parentCU.getWorkingCopy(null)), null, (String)"", (String)lineDelimiter)) != null) {
                    createdWorkingCopy.getBuffer().setContents(content);
                }
                String cuContent = String.valueOf(content) + lineDelimiter + this.typeComment + lineDelimiter + this.typeStub;
                createdWorkingCopy.getBuffer().setContents(cuContent);
                IType createdType = createdWorkingCopy.getType(clName);
                ICompilationUnit cu = createdType.getCompilationUnit();
                cu.reconcile(0, false, null, null);
                this.createTypeMembers(createdType, null, new SubProgressMonitor(this.monitor, 1));
                if (this.isCreateInheritedMethods()) {
                    this.createInheritedMethods(cu, createdType, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
                }
                if (this.isCreateInheritedConstructors()) {
                    this.createInheritedConstructors(cu, createdType, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
                }
                cu.reconcile(0, false, null, null);
                ISourceRange range = createdType.getSourceRange();
                IBuffer buf = cu.getBuffer();
                String originalContent = buf.getText(range.getOffset(), range.getLength());
                CodeFormatter codeFormatter = ToolFactory.createCodeFormatter((Map)JavaCore.getOptions());
                TextEdit textEdit = codeFormatter.format(4, originalContent, 0, originalContent.length(), indent, lineDelimiter);
                Document document = new Document(originalContent);
                try {
                    textEdit.apply((IDocument)document);
                }
                catch (Exception exception) {}
                String formattedContent = document.get();
                buf.replace(range.getOffset(), range.getLength(), formattedContent);
                cu.getBuffer().setContents(buf.getContents());
                cu.commitWorkingCopy(false, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
                this.fCreatedType = (IType)createdType.getPrimaryElement();
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                if (createdWorkingCopy != null) {
                    createdWorkingCopy.discardWorkingCopy();
                }
                this.monitor.done();
                throw throwable;
            }
            {
                Object var19_21 = null;
                if (createdWorkingCopy == null) break block10;
            }
            createdWorkingCopy.discardWorkingCopy();
        }
        this.monitor.done();
    }

    private void createTypeMembers(IType createdType, ImportsManager imports, SubProgressMonitor monitor2) throws JavaModelException {
        if (this.fields != null && this.fields.length() > 0) {
            createdType.createField(this.fields, null, false, this.getMonitor());
        }
        if (this.methodStub != null && this.methodStub.length() > 0) {
            createdType.createMethod(this.methodStub, null, false, this.getMonitor());
        }
    }

    protected IMethod[] createInheritedMethods(ICompilationUnit cu, IType type, IProgressMonitor monitor) throws CoreException {
        cu.reconcile(0, false, null, null);
        Set handleIds = this.getHandleIds(type);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setSource(cu);
        CompilationUnit unit = (CompilationUnit)parser.createAST((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        ITypeBinding binding = this.getBinding(type, unit);
        if (binding != null) {
            IWorkspaceRunnable operation = OverrideMethodsAction.createRunnable((CompilationUnit)unit, (ITypeBinding)binding, null, (int)-1, (boolean)true);
            operation.run(monitor);
            cu.reconcile(0, false, null, null);
            cu.commitWorkingCopy(false, monitor);
        }
        return this.getTypeMethods(type, handleIds);
    }

    protected IMethod[] createInheritedConstructors(ICompilationUnit cu, IType type, IProgressMonitor monitor) throws CoreException {
        cu.reconcile(0, false, null, null);
        Set handleIds = this.getHandleIds(type);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setSource(cu);
        CompilationUnit unit = (CompilationUnit)parser.createAST((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        ITypeBinding binding = this.getBinding(type, unit);
        if (binding != null) {
            IWorkspaceRunnable operation = AddUnimplementedConstructorsAction.createRunnable((CompilationUnit)unit, (ITypeBinding)binding, null, (int)-1, (boolean)true, (int)1, (boolean)true);
            operation.run(monitor);
            cu.commitWorkingCopy(false, monitor);
        }
        return this.getTypeMethods(type, handleIds);
    }

    private ITypeBinding getBinding(IType type, CompilationUnit unit) throws JavaModelException {
        AbstractTypeDeclaration declaration;
        ITypeBinding binding = null;
        ASTNode node = NodeFinder.perform((ASTNode)unit, type.getNameRange());
        while ((node = node.getParent()) != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.jdt.core.dom.AbstractTypeDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isInstance(node)) continue;
        }
        if ((declaration = (AbstractTypeDeclaration)node) != null) {
            binding = declaration.resolveBinding();
        }
        return binding;
    }

    private Set getHandleIds(IType type) throws JavaModelException {
        IMethod[] typeMethods = type.getMethods();
        HashSet<String> handleIds = new HashSet<String>(typeMethods.length);
        int index = 0;
        while (index < typeMethods.length) {
            handleIds.add(typeMethods[index].getHandleIdentifier());
            ++index;
        }
        return handleIds;
    }

    private IMethod[] getTypeMethods(IType type, Set handleIds) throws JavaModelException {
        ArrayList<IMethod> newMethods = new ArrayList<IMethod>();
        IMethod[] typeMethods = type.getMethods();
        int index = 0;
        while (index < typeMethods.length) {
            if (!handleIds.contains(typeMethods[index].getHandleIdentifier())) {
                newMethods.add(typeMethods[index]);
            }
            ++index;
        }
        IMethod[] methods = new IMethod[newMethods.size()];
        newMethods.toArray(methods);
        return methods;
    }

    protected void createImports(ImportsManager imports, String[] createdImports) {
        int index = 0;
        while (index < createdImports.length) {
            imports.addImport(createdImports[index]);
            ++index;
        }
    }

    private IPackageFragmentRoot getPackageFragmentRoot() {
        return this.packageFragmentRoot;
    }

    protected boolean removeUnused(ICompilationUnit cu, ImportsManager imports) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(cu);
        parser.setResolveBindings(true);
        CompilationUnit root = (CompilationUnit)parser.createAST(null);
        IProblem[] problems = root.getProblems();
        boolean importRemoved = false;
        int i = 0;
        while (i < problems.length) {
            if (problems[i].getID() == 268435844) {
                String imp = problems[i].getArguments()[0];
                imports.removeImport(imp);
                importRemoved = true;
            }
            ++i;
        }
        return importRemoved;
    }

    public IProgressMonitor getMonitor() {
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public IType getCreatedType() {
        return this.fCreatedType;
    }

    public void setCreatedType(IType createdType) {
        this.fCreatedType = createdType;
    }

    public String getMethodStub() {
        return this.methodStub;
    }

    public void setMethodStub(String methodStub) {
        this.methodStub = methodStub;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getTypeComment() {
        return this.typeComment;
    }

    public void setTypeComment(String typeComment) {
        this.typeComment = typeComment;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeStub() {
        return this.typeStub;
    }

    public void setTypeStub(String typeStub) {
        this.typeStub = typeStub;
    }

    public void setPackageFragmentRoot(IPackageFragmentRoot packageFragmentRoot) {
        this.packageFragmentRoot = packageFragmentRoot;
    }

    public String getFields() {
        return this.fields;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public void setConfigurationElement(IConfigurationElement configurationElement) {
        this.configurationElement = configurationElement;
    }

    public boolean isCreateInheritedConstructors() {
        return this.createInheritedConstructors;
    }

    public void setCreateInheritedConstructors(boolean createInheritedConstructors) {
        this.createInheritedConstructors = createInheritedConstructors;
    }

    public boolean isCreateInheritedMethods() {
        return this.createInheritedMethods;
    }

    public void setCreateInheritedMethods(boolean createInheritedMethods) {
        this.createInheritedMethods = createInheritedMethods;
    }

    public static class ImportsManager {
        private ImportRewrite fImportsStructure;
        private HashSet fAddedTypes = new HashSet();

        ImportsManager(ICompilationUnit createdWorkingCopy) throws CoreException {
            this.fImportsStructure = CodeStyleConfiguration.createImportRewrite((ICompilationUnit)createdWorkingCopy, (boolean)true);
        }

        ImportRewrite getImportsStructure() {
            return this.fImportsStructure;
        }

        public String addImport(String qualifiedTypeName) {
            this.fAddedTypes.add(qualifiedTypeName);
            return this.fImportsStructure.addImport(qualifiedTypeName);
        }

        void create(ICompilationUnit cu, boolean toRestore) throws CoreException {
            ImportRewrite.create((ICompilationUnit)cu, (boolean)toRestore);
            TextEdit edit = this.fImportsStructure.rewriteImports((IProgressMonitor)new NullProgressMonitor());
            Document document = new Document(cu.getSource());
            try {
                edit.apply((IDocument)document);
            }
            catch (Exception exception) {}
            String imports = document.get();
            cu.getBuffer().setContents(imports);
            cu.commitWorkingCopy(false, (IProgressMonitor)new NullProgressMonitor());
        }

        void removeImport(String qualifiedName) {
            if (this.fAddedTypes.contains(qualifiedName)) {
                this.fImportsStructure.removeImport(qualifiedName);
            }
        }
    }

    public static class NodeFinder
    extends ASTVisitor {
        private int fStart;
        private int fEnd;
        private ASTNode fCoveringNode;
        private ASTNode fCoveredNode;

        public static ASTNode perform(ASTNode root, int start, int length) {
            NodeFinder finder = new NodeFinder(start, length);
            root.accept((ASTVisitor)finder);
            ASTNode result = finder.getCoveredNode();
            if (result == null || result.getStartPosition() != start || result.getLength() != length) {
                return finder.getCoveringNode();
            }
            return result;
        }

        public static ASTNode perform(ASTNode root, ISourceRange range) {
            return NodeFinder.perform(root, range.getOffset(), range.getLength());
        }

        public NodeFinder(int offset, int length) {
            super(true);
            this.fStart = offset;
            this.fEnd = offset + length;
        }

        protected boolean visitNode(ASTNode node) {
            int nodeStart = node.getStartPosition();
            int nodeEnd = nodeStart + node.getLength();
            if (nodeEnd < this.fStart || this.fEnd < nodeStart) {
                return false;
            }
            if (nodeStart <= this.fStart && this.fEnd <= nodeEnd) {
                this.fCoveringNode = node;
            }
            if (this.fStart <= nodeStart && nodeEnd <= this.fEnd) {
                if (this.fCoveringNode == node) {
                    this.fCoveredNode = node;
                    return true;
                }
                if (this.fCoveredNode == null) {
                    this.fCoveredNode = node;
                }
                return false;
            }
            return true;
        }

        public boolean visit(CompilationUnit node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(PackageDeclaration node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(TypeDeclaration node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(Javadoc node) {
            if (super.visit(node)) {
                return this.visitNode((ASTNode)node);
            }
            return false;
        }

        public boolean visit(Modifier node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(SimpleName node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(SimpleType node) {
            return this.visitNode((ASTNode)node);
        }

        public boolean visit(MethodDeclaration node) {
            return this.visitNode((ASTNode)node);
        }

        public ASTNode getCoveredNode() {
            return this.fCoveredNode;
        }

        public ASTNode getCoveringNode() {
            return this.fCoveringNode;
        }
    }
}

