/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.derby.connection;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManagerListener;

public class DerbyShutdownService
implements ConnectionManagerListener {
    public DerbyShutdownService() {
        RDBCorePlugin.getDefault().getConnectionManager().addListener((ConnectionManagerListener)this);
    }

    public void dispose() {
        RDBCorePlugin.getDefault().getConnectionManager().removeListener((ConnectionManagerListener)this);
    }

    public void connectionInfoCreated(ConnectionInfo info) {
    }

    public void connectionInfoRemoved(String name) {
    }

    public void connectionInfoRenamed(String previousName, ConnectionInfo info) {
    }

    public void connected(ConnectionInfo info, Connection connection) {
    }

    public void disconnected(ConnectionInfo info, Connection connection) {
        if (!info.getURL().startsWith("jdbc:derby:")) {
            return;
        }
        try {
            ConnectionInfo[] infos = RDBCorePlugin.getDefault().getConnectionManager().getAllNamedConnectionInfo();
            int n = 0;
            int i = 0;
            while (i < infos.length) {
                if (infos[i] != info && infos[i].getSharedConnection() != null && infos[i].getDriverClassName().equals(info.getDriverClassName()) && this.getDBLocation(infos[i]).equals(this.getDBLocation(info))) {
                    ++n;
                }
                ++i;
            }
            if (n == 0) {
                this.shutdown(info);
            }
        }
        catch (Exception exception) {}
    }

    protected File getDBLocation(ConnectionInfo info) {
        String url = info.getURL();
        int n = (url = url.substring("jdbc:derby:".length())).indexOf(59);
        if (n >= 0) {
            url = url.substring(0, n);
        }
        return new File(url);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void shutdown(ConnectionInfo info) {
        String uniqueName = DerbyShutdownService.generateName("shutdownInfo", DerbyShutdownService.getConnectionNames());
        try {
            try {
                ConnectionInfo shutdownInfo = RDBCorePlugin.getDefault().getConnectionManager().createConnectionInfo(info.getDatabaseDefinition(), uniqueName);
                shutdownInfo.setURL(String.valueOf(info.getURL()) + ";shutdown=true");
                shutdownInfo.setDatabaseName(info.getDatabaseName());
                shutdownInfo.setDriverClassName(info.getDriverClassName());
                shutdownInfo.setLoadingPath(info.getLoadingPath());
                shutdownInfo.setUserName(info.getUserName());
                shutdownInfo.setPassword(info.getPassword());
                shutdownInfo.connect();
            }
            catch (Exception ex) {
                if (ex instanceof SQLException && ((SQLException)ex).getSQLState().equals("08006")) {
                    this.postShutdown(info);
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            RDBCorePlugin.getDefault().getConnectionManager().removeConnectionInfo(uniqueName);
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        RDBCorePlugin.getDefault().getConnectionManager().removeConnectionInfo(uniqueName);
    }

    protected void postShutdown(ConnectionInfo info) {
        try {
            if (info.getDatabaseDefinition().getVersion().equals("10.0")) {
                String dbDir = info.getURL().substring(11);
                int n = dbDir.indexOf(59);
                dbDir = dbDir.substring(0, n);
                File f = new File(dbDir);
                if ((f = new File(f, "dbex.lck")).exists()) {
                    f.delete();
                }
            }
        }
        catch (Exception exception) {}
    }

    protected static Collection getConnectionNames() {
        ConnectionInfo[] infos = RDBCorePlugin.getDefault().getConnectionManager().getAllNamedConnectionInfo();
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < infos.length) {
            v.add(infos[i].getName());
            ++i;
        }
        return v;
    }

    protected static String generateName(String baseName, Collection exclusionList) {
        String curName = baseName;
        int count = 0;
        while (DerbyShutdownService.isIn(curName, exclusionList)) {
            curName = String.valueOf(baseName) + String.valueOf(count);
            ++count;
        }
        return baseName;
    }

    protected static boolean isIn(String s, Collection col) {
        Iterator it = col.iterator();
        while (it.hasNext()) {
            if (!s.equals(it.next())) continue;
            return true;
        }
        return false;
    }
}

