/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11MessageReference;
import org.eclipse.wst.wsdl.ui.internal.asd.design.DesignViewGraphicsConstants;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.BaseEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.EditPartNavigationHandlerUtil;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.IFeedbackHandler;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.InterfaceEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDDragAndDropEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDGraphNodeDragTracker;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDSelectionEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.figures.ListFigure;
import org.eclipse.wst.wsdl.ui.internal.asd.design.figures.ModelDiagnosticInfo;
import org.eclipse.wst.wsdl.ui.internal.asd.design.layouts.RowLayout;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IMessageReference;

public class MessageReferenceEditPart
extends BaseEditPart
implements IFeedbackHandler {
    protected Figure contentPane;
    protected Label label;
    protected RowLayout rowLayout;
    private Figure messageLabelWrapper;
    private Label messageLabel;
    protected ASDSelectionEditPolicy selectionHandlesEditPolicy = new ASDSelectionEditPolicy();

    protected IFigure createFigure() {
        ListFigure figure = new ListFigure(true);
        figure.setOpaque(true);
        figure.setPaintFirstLine(false);
        figure.setBackgroundColor(ColorConstants.tooltipBackground);
        this.rowLayout = new RowLayout();
        figure.setLayoutManager((LayoutManager)this.rowLayout);
        this.label = new Label();
        this.label.setLabelAlignment(1);
        this.label.setBorder((Border)new MarginBorder(2, 16, 2, 10));
        figure.add((IFigure)this.label);
        this.contentPane = new ListFigure();
        ((ListFigure)this.contentPane).setOpaque(true);
        this.contentPane.setBackgroundColor(ColorConstants.listBackground);
        ToolbarLayout toolbarLayout = new ToolbarLayout(false);
        toolbarLayout.setStretchMinorAxis(true);
        this.contentPane.setLayoutManager((LayoutManager)toolbarLayout);
        figure.add((IFigure)this.contentPane);
        this.rowLayout.setConstraint((IFigure)this.label, "MessageLabel");
        this.rowLayout.setConstraint((IFigure)this.contentPane, "MessageContentPane");
        if (this.isReadOnly()) {
            this.label.setForegroundColor(DesignViewGraphicsConstants.readOnlyLabelColor);
            this.label.getParent().setBackgroundColor(DesignViewGraphicsConstants.readOnlyMessageRefHeadingColor);
        } else {
            this.label.setForegroundColor(ColorConstants.black);
            this.label.getParent().setBackgroundColor(ColorConstants.tooltipBackground);
        }
        return figure;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        if (!this.isReadOnly()) {
            this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new ASDDragAndDropEditPolicy(this.getViewer(), this.selectionHandlesEditPolicy));
        }
        this.installEditPolicy("Selection Feedback", (EditPolicy)this.selectionHandlesEditPolicy);
    }

    public DragTracker getDragTracker(Request request) {
        return new ASDGraphNodeDragTracker((EditPart)this);
    }

    public IFigure getContentPane() {
        return this.contentPane;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        IMessageReference message = (IMessageReference)this.getModel();
        this.label.setText(message.getText());
        this.label.setIcon(message.getImage());
        this.rowLayout.getColumnData().clearColumnWidths();
        EditPart parent = this.getParent();
        while (parent != null) {
            if (parent instanceof InterfaceEditPart) {
                ((GraphicalEditPart)parent).getFigure().invalidateTree();
                break;
            }
            parent = parent.getParent();
        }
    }

    protected void refreshChildren() {
        super.refreshChildren();
        this.refreshMessage();
    }

    protected void refreshMessage() {
        if (this.getModelChildren().size() > 0) {
            if (this.messageLabelWrapper != null) {
                this.contentPane.remove((IFigure)this.messageLabelWrapper);
                this.messageLabelWrapper = null;
            }
        } else {
            if (this.messageLabelWrapper == null) {
                this.messageLabelWrapper = new Figure();
                this.messageLabel = new Label();
                ToolbarLayout toolbarLayout = new ToolbarLayout(false){

                    public void layout(IFigure parent) {
                        super.layout(parent);
                        if (parent.getChildren().size() == 1 && parent.getChildren().get(0) instanceof Label) {
                            parent.setSize(parent.getSize().width, parent.getSize().height + 3);
                            Label child = (Label)parent.getChildren().get(0);
                            int newXAmount = (parent.getSize().width - child.getSize().width) / 2;
                            Point p = child.getLocation();
                            child.setLocation(new Point(p.x + newXAmount, p.y + 3));
                        }
                    }
                };
                this.messageLabelWrapper.setLayoutManager((LayoutManager)toolbarLayout);
                this.messageLabelWrapper.add((IFigure)this.messageLabel);
                this.contentPane.add((IFigure)this.messageLabelWrapper);
            }
            List errorList = this.getErrors();
            List warnList = this.getWarnings();
            if (errorList.size() > 0) {
                ModelDiagnosticInfo info = (ModelDiagnosticInfo)errorList.get(0);
                this.messageLabel.setText("  " + info.getDescriptionText() + "  ");
                this.messageLabel.setForegroundColor(info.getDescriptionTextColor());
            } else if (warnList.size() > 0) {
                ModelDiagnosticInfo info = (ModelDiagnosticInfo)warnList.get(0);
                this.messageLabel.setText("  " + info.getDescriptionText() + "  ");
                this.messageLabel.setForegroundColor(info.getDescriptionTextColor());
            } else {
                this.messageLabel.setText("");
                this.messageLabel.setForegroundColor(ColorConstants.black);
            }
        }
    }

    protected List getErrors() {
        if (this.getModel() instanceof W11MessageReference) {
            W11MessageReference messageRef = (W11MessageReference)this.getModel();
            return this.getDiagnosticMessageType(messageRef.getDiagnosticMessages(), ModelDiagnosticInfo.ERROR_TYPE);
        }
        return new ArrayList();
    }

    protected List getWarnings() {
        if (this.getModel() instanceof W11MessageReference) {
            W11MessageReference messageRef = (W11MessageReference)this.getModel();
            return this.getDiagnosticMessageType(messageRef.getDiagnosticMessages(), ModelDiagnosticInfo.WARNING_TYPE);
        }
        return new ArrayList();
    }

    protected List getDiagnosticMessageType(List diagnosticInfo, int type) {
        ArrayList<ModelDiagnosticInfo> listType = new ArrayList<ModelDiagnosticInfo>();
        int index = 0;
        while (index < diagnosticInfo.size()) {
            ModelDiagnosticInfo info = (ModelDiagnosticInfo)diagnosticInfo.get(index);
            if (info.getType() == type) {
                listType.add(info);
            }
            ++index;
        }
        return listType;
    }

    protected List getModelChildren() {
        IMessageReference theMessage = (IMessageReference)this.getModel();
        return theMessage.getParameters();
    }

    public void addNotify() {
        InterfaceEditPart.attachToInterfaceEditPart((EditPart)this, this.rowLayout);
        super.addNotify();
    }

    public void addFeedback() {
        this.label.getParent().setBackgroundColor(DesignViewGraphicsConstants.tableCellSelectionColor);
    }

    public void removeFeedback() {
        if (this.isReadOnly()) {
            this.label.getParent().setBackgroundColor(DesignViewGraphicsConstants.readOnlyMessageRefHeadingColor);
        } else {
            this.label.getParent().setBackgroundColor(ColorConstants.tooltipBackground);
        }
    }

    public EditPart getRelativeEditPart(int direction) {
        EditPart editPart = super.getRelativeEditPart(direction);
        if (direction == 4 && editPart == null) {
            editPart = EditPartNavigationHandlerUtil.getNextInterface((EditPart)this);
        }
        return editPart;
    }
}

