/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.outputview;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.wst.rdb.internal.outputview.OutputUtil;
import org.eclipse.wst.rdb.internal.outputview.OutputViewPlugin;

public class OVResultAreaMenu
implements MenuListener,
SelectionListener {
    protected Table myResult;
    protected Menu myMenu;
    protected StyledText styledText;
    protected MenuItem saveItem;
    protected MenuItem printItem;
    protected MenuItem menuSeparator1;

    public OVResultAreaMenu(Table aTable) {
        this.myResult = aTable;
        this.myMenu = new Menu((Control)this.myResult);
        this.saveItem = new MenuItem(this.myMenu, 0);
        this.saveItem.setText(OutputViewPlugin.getString("OV_MESSAGE_SAVE_AS"));
        this.menuSeparator1 = new MenuItem(this.myMenu, 2);
        this.printItem = new MenuItem(this.myMenu, 0);
        this.printItem.setText(OutputViewPlugin.getString("OV_MESSAGE_PRINT"));
        this.listenAll();
    }

    private void listenAll() {
        this.myMenu.addMenuListener((MenuListener)this);
        this.saveItem.addSelectionListener((SelectionListener)this);
        this.printItem.addSelectionListener((SelectionListener)this);
    }

    public Menu getMenu() {
        return this.myMenu;
    }

    private void saveOutput() {
        FileDialog fileDialog = new FileDialog(this.myResult.getShell(), 8192);
        String fileName = fileDialog.open();
        if (fileName != null) {
            try {
                File file = new File(fileName);
                if (file.isDirectory()) {
                    this.displayDirectoryError(this.myResult.getShell(), fileName);
                    return;
                }
                if (file.exists()) {
                    Object[] obj = new Object[]{fileName};
                    String message = OutputViewPlugin.getString("OV_MESSAGE_FILE_EXISTS_DESC", obj);
                    MessageBox box = new MessageBox(this.myResult.getShell(), 192);
                    box.setText(OutputViewPlugin.getString("OV_MESSAGE_FILE_EXISTS_TITLE"));
                    box.setMessage(message);
                    if (box.open() != 64) {
                        return;
                    }
                }
                FileOutputStream fos = new FileOutputStream(file);
                OutputStreamWriter outstream = null;
                String encoding = OutputUtil.getCharacterEncoding();
                outstream = encoding != null && !encoding.equals("") ? new OutputStreamWriter((OutputStream)fos, encoding) : new OutputStreamWriter(fos);
                BufferedWriter bw = new BufferedWriter(outstream);
                int columnCount = this.myResult.getColumnCount();
                int i = 0;
                while (i < columnCount) {
                    bw.write(this.myResult.getColumn(i).getText());
                    bw.write(9);
                    ++i;
                }
                bw.newLine();
                int itemCount = this.myResult.getItemCount();
                int i2 = 0;
                while (i2 < itemCount) {
                    int j = 0;
                    while (j < columnCount) {
                        bw.write(this.myResult.getItem(i2).getText(j));
                        bw.write(9);
                        ++j;
                    }
                    bw.newLine();
                    ++i2;
                }
                bw.flush();
                bw.close();
            }
            catch (IOException ex) {
                MessageBox box = new MessageBox(this.myResult.getShell(), 1);
                box.setText(OutputViewPlugin.getString("OV_STATUS_ERROR"));
                box.setMessage(ex.getMessage());
                box.open();
            }
        }
    }

    protected void displayDirectoryError(Shell aShell, String aFile) {
        Object[] obj = new Object[]{aFile};
        String message = OutputViewPlugin.getString("OV_MESSAGE_FILE_ISDIRECTORY_DESC", obj);
        MessageBox box = new MessageBox(aShell, 33);
        box.setText(OutputViewPlugin.getString("OV_MESSAGE_FILE_ISDIRECTORY_TITLE"));
        box.setMessage(message);
        box.open();
        this.saveOutput();
    }

    protected void printOutput() {
        PrintDialog dialog = new PrintDialog(this.myResult.getShell(), 0);
        PrinterData printerData = dialog.open();
        if (printerData != null) {
            Printer printer = new Printer(printerData);
            StringBuffer sb = new StringBuffer(2000);
            int columnCount = this.myResult.getColumnCount();
            String lineSeparator = System.getProperty("line.separator");
            int i = 0;
            while (i < columnCount) {
                sb.append(this.myResult.getColumn(i).getText());
                sb.append('\t');
                ++i;
            }
            sb.append(lineSeparator);
            int itemCount = this.myResult.getItemCount();
            int i2 = 0;
            while (i2 < itemCount) {
                int j = 0;
                while (j < columnCount) {
                    sb.append(this.myResult.getItem(i2).getText(j));
                    sb.append('\t');
                    ++j;
                }
                sb.append(lineSeparator);
                ++i2;
            }
            if (this.styledText == null) {
                this.styledText = new StyledText((Composite)this.myResult, 64);
                this.styledText.setVisible(false);
            }
            this.styledText.setText(sb.toString());
            this.styledText.print(printer).run();
            printer.dispose();
        }
    }

    public void menuHidden(MenuEvent anEvent) {
    }

    public void menuShown(MenuEvent anEvent) {
        this.saveItem.setEnabled(this.myResult.getItemCount() > 0);
        this.printItem.setEnabled(this.myResult.getItemCount() > 0);
    }

    public void widgetDefaultSelected(SelectionEvent anEvent) {
    }

    public void widgetSelected(SelectionEvent anEvent) {
        Object source = anEvent.getSource();
        if (source == this.saveItem) {
            this.saveOutput();
        } else if (source == this.printItem) {
            this.printOutput();
        }
    }
}

