/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.internet.monitor.core.internal.ContentFilter;
import org.eclipse.wst.internet.monitor.core.internal.IContentFilter;
import org.eclipse.wst.internet.monitor.core.internal.IStartup;
import org.eclipse.wst.internet.monitor.core.internal.ProtocolAdapter;
import org.eclipse.wst.internet.monitor.core.internal.Trace;

public class MonitorPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.wst.internet.monitor.core";
    private static MonitorPlugin singleton;
    protected Map protocolAdapters;
    protected Map contentFilters;
    protected boolean startupsLoaded;

    public MonitorPlugin() {
        singleton = this;
        this.loadProtocolAdapters();
        this.loadContentFilters();
    }

    public static MonitorPlugin getInstance() {
        return singleton;
    }

    public String getDefaultType() {
        return "HTTP";
    }

    public ProtocolAdapter getProtocolAdapter(String id) {
        return (ProtocolAdapter)this.protocolAdapters.get(id);
    }

    public ProtocolAdapter[] getProtocolAdapters() {
        ArrayList list = new ArrayList();
        Iterator iterator = this.protocolAdapters.values().iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        ProtocolAdapter[] types = new ProtocolAdapter[list.size()];
        list.toArray(types);
        return types;
    }

    public IContentFilter[] getContentFilters() {
        ArrayList list = new ArrayList();
        Iterator iterator = this.contentFilters.values().iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        IContentFilter[] cf = new IContentFilter[list.size()];
        list.toArray(cf);
        return cf;
    }

    public IContentFilter findContentFilter(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        return (IContentFilter)this.contentFilters.get(id);
    }

    protected synchronized void loadProtocolAdapters() {
        if (this.protocolAdapters != null) {
            return;
        }
        Trace.trace(Trace.CONFIG, "Loading protocol adapters");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "internalProtocolAdapters");
        int size = cf.length;
        HashMap<String, ProtocolAdapter> map = new HashMap<String, ProtocolAdapter>(size);
        int i = 0;
        while (i < size) {
            String id = cf[i].getAttribute("id");
            Trace.trace(Trace.CONFIG, "Loading adapter: " + id);
            map.put(id, new ProtocolAdapter(cf[i]));
            ++i;
        }
        this.protocolAdapters = map;
    }

    protected synchronized void loadContentFilters() {
        if (this.contentFilters != null) {
            return;
        }
        Trace.trace(Trace.CONFIG, "Loading content filters");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "internalContentFilters");
        int size = cf.length;
        HashMap<String, ContentFilter> map = new HashMap<String, ContentFilter>(size);
        int i = 0;
        while (i < size) {
            String id = cf[i].getAttribute("id");
            Trace.trace(Trace.CONFIG, "Loading filter: " + id);
            map.put(id, new ContentFilter(cf[i]));
            ++i;
        }
        this.contentFilters = map;
    }

    protected synchronized void executeStartups() {
        if (this.startupsLoaded) {
            return;
        }
        Trace.trace(Trace.CONFIG, "Loading startups");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "internalStartup");
        int size = cf.length;
        int i = 0;
        while (i < size) {
            String id = cf[i].getAttribute("id");
            Trace.trace(Trace.CONFIG, "Loading startup: " + id);
            try {
                IStartup startup = (IStartup)cf[i].createExecutableExtension("class");
                try {
                    startup.startup();
                }
                catch (Exception ex) {
                    Trace.trace(Trace.SEVERE, "Startup failed" + startup.toString(), ex);
                }
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Could not create startup: " + id, e);
            }
            ++i;
        }
    }
}

