/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.design.layouts;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wst.xsd.ui.internal.design.figures.ModelGroupFigure;
import org.eclipse.wst.xsd.ui.internal.design.figures.SpacingFigure;

public class ModelGroupLayout
extends AbstractLayout {
    protected boolean isHorizontal;
    protected int spacing = 10;
    protected int border = 0;

    public ModelGroupLayout() {
        this(0);
    }

    public ModelGroupLayout(boolean isHorizontal) {
        this.isHorizontal = isHorizontal;
    }

    public ModelGroupLayout(boolean isHorizontal, int spacing) {
        this.isHorizontal = isHorizontal;
        this.spacing = spacing;
    }

    public ModelGroupLayout(int spacing) {
        this.spacing = spacing;
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Dimension preferred = new Dimension();
        List children = container.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Dimension childSize = child.getPreferredSize();
            if (this.isHorizontal) {
                preferred.width += childSize.width;
                preferred.height = Math.max(preferred.height, childSize.height);
            } else {
                preferred.height += childSize.height;
                preferred.width = Math.max(preferred.width, childSize.width);
            }
            ++i;
        }
        int childrenSize = children.size();
        if (childrenSize > 1) {
            if (this.isHorizontal) {
                preferred.width += this.spacing * (childrenSize - 1);
            } else {
                preferred.height += this.spacing * (childrenSize - 1);
            }
        }
        preferred.width += this.border * 2;
        preferred.height += this.border * 2;
        preferred.width += container.getInsets().getWidth();
        preferred.height += container.getInsets().getHeight();
        return preferred;
    }

    public void layout(IFigure container) {
        List children = container.getChildren();
        int rx = 0;
        Dimension dimension = new Dimension();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Dimension childSize = child.getPreferredSize();
            if (this.isHorizontal) {
                dimension.height = Math.max(dimension.height, childSize.height);
                rx += childSize.width;
            } else {
                dimension.width = Math.max(dimension.width, childSize.width);
            }
            ++i;
        }
        if (this.isHorizontal) {
            dimension.height += this.border * 2;
            dimension.width += this.border;
        } else {
            dimension.width += this.border * 2;
            dimension.height += this.border;
        }
        Rectangle r = container.getClientArea();
        dimension = new Dimension(r.width, r.height);
        Point p = new Point(0, 0);
        Iterator i2 = children.iterator();
        while (i2.hasNext()) {
            Rectangle rectangle;
            IFigure child = (IFigure)i2.next();
            Dimension childSize = child.getPreferredSize();
            if (this.isHorizontal) {
                rectangle = new Rectangle(p.x, 0, childSize.width, childSize.height);
                if (!i2.hasNext()) {
                    rectangle.width = dimension.width - rectangle.x;
                }
                rectangle.y = p.x == 0 ? r.height / 2 - childSize.height / 2 : r.height / 2 - childSize.height / 2;
                rectangle.translate(container.getClientArea().getLocation());
                child.setBounds(rectangle);
                p.x += childSize.width;
                p.x += this.spacing;
                continue;
            }
            rectangle = new Rectangle(0, p.y, childSize.width, childSize.height);
            if (child instanceof SpacingFigure) {
                rectangle.x = dimension.width + 6;
            } else {
                rectangle.width = child instanceof ModelGroupFigure ? dimension.width - rectangle.x : dimension.width - rectangle.x;
            }
            rectangle.translate(container.getClientArea().getLocation());
            child.setBounds(rectangle);
            p.y += childSize.height;
            p.y += this.spacing;
        }
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    protected int alignFigure(IFigure parent, IFigure child) {
        return -1;
    }
}

