/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.core.internal.ui.explorer.providers.decorators.impl;

import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.wst.rdb.core.internal.ui.explorer.providers.decorators.IColumnDecorationService;
import org.eclipse.wst.rdb.core.internal.ui.explorer.providers.decorators.impl.AbstractDecorationService;
import org.eclipse.wst.rdb.core.internal.ui.icons.ImageDescription;
import org.eclipse.wst.rdb.core.internal.ui.preferences.ColumnDecoratorUtil;
import org.eclipse.wst.rdb.core.internal.ui.services.IDataToolsUIServiceManager;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;

public class ColumnDecorationService
extends AbstractDecorationService
implements IColumnDecorationService {
    private void decorate(Column column, IDecoration decoration) {
        boolean pk = column.isPartOfPrimaryKey();
        boolean fk = column.isPartOfForeignKey();
        boolean nullable = column.isNullable();
        String dataType = IDataToolsUIServiceManager.INSTANCE.getColumnHelperService().getDataType(column);
        if (dataType != null) {
            if (fk && pk) {
                decoration.addSuffix(ColumnDecoratorUtil.getPKFKColumnDecoration(dataType));
                decoration.addOverlay(ImageDescription.getPKFKDecorationDescriptor());
            } else if (fk && nullable) {
                decoration.addSuffix(ColumnDecoratorUtil.getFKNullableColumnDecoration(dataType));
                decoration.addOverlay(ImageDescription.getFKDecorationDescriptor());
            } else if (fk) {
                decoration.addSuffix(ColumnDecoratorUtil.getFKColumnDecoration(dataType));
                decoration.addOverlay(ImageDescription.getFKDecorationDescriptor());
            } else if (pk) {
                decoration.addSuffix(ColumnDecoratorUtil.getPKColumnDecoration(dataType));
                decoration.addOverlay(ImageDescription.getPKDecorationDescriptor());
            } else if (nullable) {
                decoration.addSuffix(ColumnDecoratorUtil.getNullableColumnDecoration(dataType));
            } else {
                decoration.addSuffix(ColumnDecoratorUtil.getColumnDecoration(dataType));
            }
        }
    }

    public void decorate(Object column, IDecoration decoration) {
        if (column instanceof Column) {
            this.decorate((Column)column, decoration);
        }
    }
}

