/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.common;

import java.io.IOException;
import java.io.PushbackReader;
import org.eclipse.wst.javascript.core.internal.jsparser.lexer.LexerException;
import org.eclipse.wst.javascript.core.internal.jsparser.lexer.LiveLexer;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TCommenttok;
import org.eclipse.wst.javascript.core.internal.jsparser.node.Token;
import org.eclipse.wst.javascript.ui.internal.common.LexerCacheForJavaScript;

class CachingJSLexer
extends LiveLexer {
    protected final LexerCacheForJavaScript cache;

    protected CachingJSLexer(LexerCacheForJavaScript lexerCache, PushbackReader in) {
        super(in);
        this.cache = lexerCache;
    }

    protected CachingJSLexer(LexerCacheForJavaScript lexerCache, PushbackReader in, int offNew) {
        super(in, offNew);
        this.cache = lexerCache;
    }

    protected CachingJSLexer(LexerCacheForJavaScript lexerCache, PushbackReader in, Token tk) {
        super(in, tk);
        this.cache = lexerCache;
    }

    protected Token getToken() throws IOException, LexerException {
        Token retval = super.getToken();
        if (retval.getContainsLineTerminator()) {
            this.cache.remove(retval);
            this.cache.add(retval);
        } else {
            String strTkThis = retval.toString();
            if (strTkThis.equals("{") || strTkThis.equals("}") || strTkThis.equals("function") || strTkThis.equals("var")) {
                this.cache.remove(retval);
                this.cache.add(retval);
            } else if (retval instanceof TCommenttok && strTkThis.startsWith("/**")) {
                this.cache.remove(retval);
                this.cache.add(retval);
            }
        }
        return retval;
    }
}

