/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.core.containment;

import java.util.Collection;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;


public class DatabaseContainmentProvider extends AbstractContainmentProvider {
	public Collection getContainedElements(EObject obj) {
		Database database = (Database) obj;
	    Collection children = super.getContainedElements(obj);
	    children.addAll(database.getSchemas());
	    children.addAll(database.getAuthorizationIds());
	    return children;
	}

	public String getGroupId(EObject obj) {
		return GroupID.DATABASE;
	}
}
