/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.internal.core.rte.fe;

import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;

import org.eclipse.wst.rdb.internal.core.containment.ContainmentServiceImpl;
import org.eclipse.wst.rdb.internal.core.rte.EngineeringOption;
import org.eclipse.wst.rdb.internal.core.rte.EngineeringOptionCategory;
import org.eclipse.wst.rdb.internal.core.rte.EngineeringOptionCategoryID;
import org.eclipse.wst.rdb.internal.core.rte.EngineeringOptionID;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;

public class GenericDdlGenerationOptions {
	public final static byte GENERATE_FULLY_QUALIFIED_NAME = 0;
	public final static byte GENERATE_QUOTED_IDENTIFIER = 1;
	public final static byte GENERATE_DROP_STATEMENTS = 2;
	public final static byte GENERATE_CREATE_STATEMENTS = 3;
	public final static byte GENERATE_TABLES =4;
	public final static byte GENERATE_INDICES = 5;
	public final static byte GENERATE_VIEWS = 6;
	public final static byte GENERATE_TRIGGERS = 7;
	public final static byte GENERATE_PK_CONSTRAINTS = 8;
	public final static byte GENERATE_FK_CONSTRAINTS = 9;
	

	public static EngineeringOption[] createDDLGenerationOptions(EngineeringOptionCategory[] categories) {
        ResourceBundle resource = ResourceBundle.getBundle("org.eclipse.wst.rdb.internal.core.rte.fe.GenericDdlGeneration"); //$NON-NLS-1$

        EngineeringOptionCategory general_options =null;
        EngineeringOptionCategory additional_element =null;
        for (int i = 0; i < categories.length; i++) {
        	if (categories[i].getId().equals(EngineeringOptionCategoryID.GENERATE_OPTIONS)){
        		general_options = categories[i];
        	} else if (categories[i].getId().equals(EngineeringOptionCategoryID.GENERATE_ELEMENTS)){
        		additional_element = categories[i];
        	}
        }
        
        Vector optionVec = new Vector();
        optionVec.add(new EngineeringOption(EngineeringOptionID.GENERATE_FULLY_QUALIFIED_NAME,resource.getString("GENERATE_FULLY_QUALIFIED_NAME"), resource.getString("GENERATE_FULLY_QUALIFIED_NAME_DES"), false,general_options)); //$NON-NLS-1$ //$NON-NLS-2$
        optionVec.add(new EngineeringOption(EngineeringOptionID.GENERATE_QUOTED_IDENTIFIER,resource.getString("GENERATE_QUOTED_IDENTIFIER"), resource.getString("GENERATE_QUOTED_IDENTIFIER_DES"),false,general_options)); //$NON-NLS-1$ //$NON-NLS-2$
        optionVec.add(new EngineeringOption(EngineeringOptionID.GENERATE_DROP_STATEMENTS,resource.getString("GENERATE_DROP_STATEMENTS"), resource.getString("GENERATE_DROP_STATEMENTS_DES"),false,general_options)); //$NON-NLS-1$ //$NON-NLS-2$
        optionVec.add(new EngineeringOption(EngineeringOptionID.GENERATE_CREATE_STATEMENTS,resource.getString("GENERATE_CREATE_STATEMENTS"), resource.getString("GENERATE_CREATE_STATEMENTS_DES"),true,general_options)); //$NON-NLS-1$ //$NON-NLS-2$
        optionVec.add(new EngineeringOption(EngineeringOptionID.GENERATE_TABLES,resource.getString("GENERATE_TABLES"), resource.getString("GENERATE_TABLES_DES"),true,additional_element)); //$NON-NLS-1$ //$NON-NLS-2$
        optionVec.add(new EngineeringOption(EngineeringOptionID.GENERATE_INDICES,resource.getString("GENERATE_INDEX"), resource.getString("GENERATE_INDEX_DES"),true,additional_element)); //$NON-NLS-1$ //$NON-NLS-2$
        optionVec.add(new EngineeringOption(EngineeringOptionID.GENERATE_VIEWS,resource.getString("GENERATE_VIEW"), resource.getString("GENERATE_VIEW_DES"),true,additional_element)); //$NON-NLS-1$ //$NON-NLS-2$
        optionVec.add(new EngineeringOption(EngineeringOptionID.GENERATE_TRIGGERS,resource.getString("GENERATE_TRIGGER"), resource.getString("GENERATE_TRIGGER_DES"),true,additional_element)); //$NON-NLS-1$ //$NON-NLS-2$
        optionVec.add(new EngineeringOption(EngineeringOptionID.GENERATE_PK_CONSTRAINTS,resource.getString("GENERATE_PK_CONSTRAINTS"), resource.getString("GENERATE_PK_CONSTRAINTS_DES"),true,additional_element)); //$NON-NLS-1$ //$NON-NLS-2$
        optionVec.add(new EngineeringOption(EngineeringOptionID.GENERATE_FK_CONSTRAINTS,resource.getString("GENERATE_FK_CONSTRAINTS"), resource.getString("GENERATE_FK_CONSTRAINTS_DES"),true,additional_element)); //$NON-NLS-1$ //$NON-NLS-2$
        
        EngineeringOption[] options = new EngineeringOption[optionVec.size()];
        optionVec.copyInto(options);
		return options;
    }

	public static EngineeringOptionCategory[] createDDLGenerationOptionCategories() {
        ResourceBundle resource = ResourceBundle.getBundle("org.eclipse.wst.rdb.internal.core.rte.fe.GenericDdlGeneration"); //$NON-NLS-1$

        Vector categoryVec = new Vector();
        categoryVec.add(new EngineeringOptionCategory(EngineeringOptionCategoryID.GENERATE_OPTIONS,resource.getString("GENERATION_OPTIONS"), resource.getString("GENERATION_OPTIONS_DES"))); //$NON-NLS-1$ //$NON-NLS-2$
        categoryVec.add(new EngineeringOptionCategory(EngineeringOptionCategoryID.GENERATE_ELEMENTS,resource.getString("ADDITIONAL_ELEMENTS"), resource.getString("ADDITIONAL_ELEMENTS_DES"))); //$NON-NLS-1$ //$NON-NLS-2$
    
        EngineeringOptionCategory[] categories = new EngineeringOptionCategory[categoryVec.size()];
        categoryVec.copyInto(categories);
		return categories;
	}

    //@bd00058820gs
    public static Set getAllContainedDisplayableElementSet(SQLObject[] elements) {
        Set s = new HashSet();
        for(int i=0; i<elements.length; ++i) {
            s.add(elements[i]);
            s.addAll(ContainmentServiceImpl.INSTANCE.getAllContainedDisplayableElements(elements[i]));
        }
        return s;
    }    
    
    public static EngineeringOption getEngineeringOption(String id, /*String product, String version,*/ EngineeringOptionCategory general_options, EngineeringOptionCategory additional_element)
    {
        ResourceBundle resource = ResourceBundle.getBundle("org.eclipse.wst.rdb.internal.core.rte.fe.GenericDdlGeneration"); //$NON-NLS-1$

        try {
            if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_FULLY_QUALIFIED_NAME))
                return new EngineeringOption(id,resource.getString("GENERATE_FULLY_QUALIFIED_NAME"), resource.getString("GENERATE_FULLY_QUALIFIED_NAME_DES"), false,general_options); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_QUOTED_IDENTIFIER))
                return new EngineeringOption(id,resource.getString("GENERATE_QUOTED_IDENTIFIER"), resource.getString("GENERATE_QUOTED_IDENTIFIER_DES"),false,general_options); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_DROP_STATEMENTS))
                return new EngineeringOption(id,resource.getString("GENERATE_DROP_STATEMENTS"), resource.getString("GENERATE_DROP_STATEMENTS_DES"),false,general_options); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_CREATE_STATEMENTS))
                return new EngineeringOption(id,resource.getString("GENERATE_CREATE_STATEMENTS"), resource.getString("GENERATE_CREATE_STATEMENTS_DES"),true,general_options); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_COMMENTS))
                return new EngineeringOption(id,resource.getString("GENERATE_COMMENTS"), resource.getString("GENERATE_COMMENTS_DES"),true,general_options); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_IN_TABLESPACE_CLAUSE))
                return new EngineeringOption(id,resource.getString("GENERATE_IN_TABLESPACE_CLAUSE"), resource.getString("GENERATE_IN_TABLESPACE_CLAUSE_DES"),true,general_options); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_USE_DOMAIN_IF_EXIST))
                return new EngineeringOption(id,resource.getString("GENERATE_USE_DOMAIN_IF_EXIST"), resource.getString("GENERATE_USE_DOMAIN_IF_EXIST_DES"),false,general_options); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_TABLES))
                return new EngineeringOption(id,resource.getString("GENERATE_TABLES"), resource.getString("GENERATE_TABLES_DES"),true,additional_element); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_TABLESPACES))
                return new EngineeringOption(id,resource.getString("GENERATE_TABLESPACES"), resource.getString("GENERATE_TABLESPACES_DES"),true,additional_element); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_INDICES))
                return new EngineeringOption(id,resource.getString("GENERATE_INDEX"), resource.getString("GENERATE_INDEX_DES"),true,additional_element); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_STOREDPROCEDURES))
                return new EngineeringOption(id,resource.getString("GENERATE_STOREDPROCEDURE"), resource.getString("GENERATE_STOREDPROCEDURE_DES"),true,additional_element); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_FUNCTIONS))
                return new EngineeringOption(id,resource.getString("GENERATE_FUNCTION"), resource.getString("GENERATE_FUNCTION_DES"),true,additional_element); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_VIEWS))
                return new EngineeringOption(id,resource.getString("GENERATE_VIEW"), resource.getString("GENERATE_VIEW_DES"),true,additional_element); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_TRIGGERS))
                return new EngineeringOption(id,resource.getString("GENERATE_TRIGGER"), resource.getString("GENERATE_TRIGGER_DES"),true,additional_element); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_SEQUENCES))
                return new EngineeringOption(id,resource.getString("GENERATE_SEQUENCE"), resource.getString("GENERATE_SEQUENCE_DES"),true,additional_element); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_USER_DEFINED_TYPE))
                return new EngineeringOption(id,resource.getString("GENERATE_USER_DEFINED_TYPE"), resource.getString("GENERATE_USER_DEFINED_TYPE_DES"),true,additional_element); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_PK_CONSTRAINTS))
                return new EngineeringOption(id,resource.getString("GENERATE_PK_CONSTRAINTS"), resource.getString("GENERATE_PK_CONSTRAINTS_DES"),true,additional_element); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_TABLESPACES))
                return new EngineeringOption(id,resource.getString("GENERATE_TABLESPACES"), resource.getString("GENERATE_TABLESPACES_DES"),true,additional_element); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_DATABASE))
                return new EngineeringOption(id,resource.getString("GENERATE_DATABASE"), resource.getString("GENERATE_DATABASE_DES"),true,additional_element); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_MQT))
                return new EngineeringOption(id,resource.getString("GENERATE_MQT"), resource.getString("GENERATE_MQT_DES"),true,additional_element); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_ALIAS))
                return new EngineeringOption(id,resource.getString("GENERATE_ALIAS"), resource.getString("GENERATE_ALIAS_DES"),true,additional_element); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_CK_CONSTRAINTS))
                return new EngineeringOption(id,resource.getString("GENERATE_CK_CONSTRAINTS"), resource.getString("GENERATE_CK_CONSTRAINTS_DES"),true,additional_element); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_FK_CONSTRAINTS))
                return new EngineeringOption(id,resource.getString("GENERATE_FK_CONSTRAINTS"), resource.getString("GENERATE_FK_CONSTRAINTS_DES"),true,additional_element); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_BUFFERPOOL))
                return new EngineeringOption(id,resource.getString("GENERATE_BUFFERPOOL"), resource.getString("GENERATE_BUFFERPOOL_DES"),true,additional_element); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_PARTITIONGROUP))
                return new EngineeringOption(id,resource.getString("GENERATE_PARTITIONGROUP"), resource.getString("GENERATE_PARTITIONGROUP_DES"),true,additional_element); //$NON-NLS-1$ //$NON-NLS-2$
            else if (id.equalsIgnoreCase(EngineeringOptionID.GENERATE_SCHEMAS))
                return new EngineeringOption(id,resource.getString("GENERATE_SCHEMA"), resource.getString("GENERATE_SCHEMA_DES"),true,additional_element); //$NON-NLS-1$ //$NON-NLS-2$
        } catch (Exception e) {
            //The resource was not found
        	e.printStackTrace();
        }
        return null;
    }
    //@ed00058820gs
	
}
