/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.server.internal.ui.explorer.content.ServerExplorerConfiguration;


/**
 * @author ljulien
 */
public class ConnectServerAction extends AbstractAction
{
	private static ISelection selection;

	/**
	 * Will set the current selection
	 * @param sel
	 */
	protected void setSelection (ISelection sel)
	{
		selection = sel;
	}
	
	/**
	 * Will return the current selection
	 * @return
	 */
	protected ISelection getSelection ()
	{
		return selection;
	}
	
	/**
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action)
	{
	    try
        {
            final IConnectionNode connection = (IConnectionNode) ((IStructuredSelection)selection).getFirstElement();
            new ServerExplorerConfiguration().restoreConnectionInfo(connection, connection.getConnectionInfo());
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
	}
}
