/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.preferences;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.MultipleInputDialog;
import org.eclipse.debug.internal.ui.SWTUtil;
import org.eclipse.debug.internal.ui.preferences.DebugPreferencesMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class StringVariablePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer variableTable;
    protected Button envAddButton;
    protected Button envEditButton;
    protected Button envRemoveButton;
    protected SimpleVariableContentProvider variableContentProvider = new SimpleVariableContentProvider();
    protected static final String NAME_LABEL = DebugPreferencesMessages.SimpleVariablePreferencePage_10;
    protected static final String VALUE_LABEL = DebugPreferencesMessages.SimpleVariablePreferencePage_11;
    protected static final String DESCRIPTION_LABEL = DebugPreferencesMessages.SimpleVariablePreferencePage_12;
    protected static String[] variableTableColumnProperties = new String[]{"variable", "value", "description"};
    protected String[] variableTableColumnHeaders = new String[]{DebugPreferencesMessages.SimpleVariablePreferencePage_3, DebugPreferencesMessages.SimpleVariablePreferencePage_4, DebugPreferencesMessages.SimpleVariablePreferencePage_5};
    protected ColumnLayoutData[] variableTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(33), new ColumnWeightData(33), new ColumnWeightData(34)};

    public StringVariablePreferencePage() {
        this.setDescription(DebugPreferencesMessages.SimpleVariablePreferencePage_6);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IDebugHelpContextIds.SIMPLE_VARIABLE_PREFERENCE_PAGE);
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setFont(font);
        this.createTable(composite);
        this.createButtons(composite);
        return composite;
    }

    private void createTable(Composite parent) {
        Font font = parent.getFont();
        Composite tableComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.heightHint = 150;
        gridData.widthHint = 400;
        tableComposite.setLayout((Layout)layout);
        tableComposite.setLayoutData((Object)gridData);
        tableComposite.setFont(font);
        this.variableTable = new TableViewer(tableComposite, 68354);
        Table table = this.variableTable.getTable();
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(font);
        gridData = new GridData(1808);
        this.variableTable.getControl().setLayoutData((Object)gridData);
        this.variableTable.setContentProvider((IContentProvider)this.variableContentProvider);
        this.variableTable.setColumnProperties(variableTableColumnProperties);
        this.variableTable.setSorter(new ViewerSorter(){

            public int compare(Viewer iViewer, Object e1, Object e2) {
                if (e1 == null) {
                    return -1;
                }
                if (e2 == null) {
                    return 1;
                }
                return ((IValueVariable)e1).getName().compareToIgnoreCase(((IValueVariable)e2).getName());
            }
        });
        this.variableTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StringVariablePreferencePage.this.handleTableSelectionChanged(event);
            }
        });
        this.variableTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!StringVariablePreferencePage.this.variableTable.getSelection().isEmpty()) {
                    StringVariablePreferencePage.this.handleEditButtonPressed();
                }
            }
        });
        this.variableTable.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    StringVariablePreferencePage.this.handleRemoveButtonPressed();
                }
            }
        });
        int i = 0;
        while (i < this.variableTableColumnHeaders.length) {
            tableLayout.addColumnData(this.variableTableColumnLayouts[i]);
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(this.variableTableColumnLayouts[i].resizable);
            tc.setText(this.variableTableColumnHeaders[i]);
            ++i;
        }
        this.variableTable.setInput((Object)this.getVariableManager());
        this.variableTable.setLabelProvider((IBaseLabelProvider)new SimpleVariableLabelProvider());
    }

    private void createButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.numColumns = 1;
        GridData gdata = new GridData(2);
        buttonComposite.setLayout((Layout)glayout);
        buttonComposite.setLayoutData((Object)gdata);
        buttonComposite.setFont(parent.getFont());
        this.envAddButton = SWTUtil.createPushButton(buttonComposite, DebugPreferencesMessages.SimpleVariablePreferencePage_7, null);
        this.envAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StringVariablePreferencePage.this.handleAddButtonPressed();
            }
        });
        this.envEditButton = SWTUtil.createPushButton(buttonComposite, DebugPreferencesMessages.SimpleVariablePreferencePage_8, null);
        this.envEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StringVariablePreferencePage.this.handleEditButtonPressed();
            }
        });
        this.envEditButton.setEnabled(false);
        this.envRemoveButton = SWTUtil.createPushButton(buttonComposite, DebugPreferencesMessages.SimpleVariablePreferencePage_9, null);
        this.envRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StringVariablePreferencePage.this.handleRemoveButtonPressed();
            }
        });
        this.envRemoveButton.setEnabled(false);
    }

    private void handleAddButtonPressed() {
        MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), DebugPreferencesMessages.SimpleVariablePreferencePage_13);
        dialog.addTextField(NAME_LABEL, null, false);
        dialog.addBrowseField(VALUE_LABEL, null, true);
        dialog.addTextField(DESCRIPTION_LABEL, null, true);
        if (dialog.open() != 0) {
            return;
        }
        String name = dialog.getStringValue(NAME_LABEL).trim();
        if (name != null && name.length() > 0) {
            String description = dialog.getStringValue(DESCRIPTION_LABEL);
            IValueVariable variable = this.getVariableManager().newValueVariable(name, description);
            variable.setValue(dialog.getStringValue(VALUE_LABEL));
            this.addVariable(variable);
        }
    }

    public boolean addVariable(IValueVariable variable) {
        String name = variable.getName();
        List editedVariables = this.variableContentProvider.getVariables();
        for (IValueVariable currentVariable : editedVariables) {
            String variableName = currentVariable.getName();
            if (!variableName.equals(name)) continue;
            boolean overWrite = MessageDialog.openQuestion((Shell)this.getShell(), (String)DebugPreferencesMessages.SimpleVariablePreferencePage_15, (String)MessageFormat.format((String)DebugPreferencesMessages.SimpleVariablePreferencePage_16, (Object[])new String[]{name}));
            if (!overWrite) {
                return false;
            }
            this.variableContentProvider.removeVariables(new IValueVariable[]{currentVariable});
            break;
        }
        this.variableContentProvider.addVariables(new IValueVariable[]{variable});
        this.variableTable.refresh();
        return true;
    }

    private void handleEditButtonPressed() {
        String description;
        IStructuredSelection selection = (IStructuredSelection)this.variableTable.getSelection();
        IValueVariable variable = (IValueVariable)selection.getFirstElement();
        if (variable == null) {
            return;
        }
        String value = variable.getValue();
        if (value == null) {
            value = "";
        }
        if ((description = variable.getDescription()) == null) {
            description = "";
        }
        String originalName = variable.getName();
        MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), DebugPreferencesMessages.SimpleVariablePreferencePage_14);
        dialog.addTextField(NAME_LABEL, originalName, false);
        dialog.addBrowseField(VALUE_LABEL, value, true);
        dialog.addTextField(DESCRIPTION_LABEL, description, true);
        if (dialog.open() == 0) {
            String name = dialog.getStringValue(NAME_LABEL);
            value = dialog.getStringValue(VALUE_LABEL);
            description = dialog.getStringValue(DESCRIPTION_LABEL);
            if (!name.equals(originalName)) {
                IValueVariable newVariable = this.getVariableManager().newValueVariable(name, description);
                newVariable.setValue(value);
                if (this.addVariable(newVariable)) {
                    this.variableContentProvider.removeVariables(new IValueVariable[]{variable});
                    this.variableTable.refresh();
                }
            } else {
                if (value != null) {
                    variable.setValue(value);
                }
                if (description != null) {
                    variable.setDescription(description);
                }
                this.variableTable.update((Object)variable, null);
            }
        }
    }

    private void handleRemoveButtonPressed() {
        boolean remove;
        IStructuredSelection selection = (IStructuredSelection)this.variableTable.getSelection();
        List variablesToRemove = selection.toList();
        StringBuffer contributedVariablesToRemove = new StringBuffer();
        for (IValueVariable variable : variablesToRemove) {
            if (!variable.isContributed()) continue;
            contributedVariablesToRemove.append('\t').append(variable.getName()).append('\n');
        }
        if (contributedVariablesToRemove.length() > 0 && !(remove = MessageDialog.openQuestion((Shell)this.getShell(), (String)DebugPreferencesMessages.SimpleLaunchVariablePreferencePage_21, (String)MessageFormat.format((String)DebugPreferencesMessages.SimpleLaunchVariablePreferencePage_22, (Object[])new String[]{contributedVariablesToRemove.toString()})))) {
            return;
        }
        IValueVariable[] variables = variablesToRemove.toArray(new IValueVariable[0]);
        this.variableContentProvider.removeVariables(variables);
        this.variableTable.refresh();
    }

    protected void handleTableSelectionChanged(SelectionChangedEvent event) {
        int size = ((IStructuredSelection)event.getSelection()).size();
        this.envEditButton.setEnabled(size == 1);
        this.envRemoveButton.setEnabled(size > 0);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.variableContentProvider.discardChanges();
        this.variableTable.refresh();
        super.performDefaults();
    }

    public boolean performOk() {
        this.variableContentProvider.saveChanges();
        return super.performOk();
    }

    private IStringVariableManager getVariableManager() {
        return VariablesPlugin.getDefault().getStringVariableManager();
    }

    private class SimpleVariableContentProvider
    implements IStructuredContentProvider {
        private List fVariables = new ArrayList();

        private SimpleVariableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.fVariables.toArray();
        }

        public void removeVariables(IValueVariable[] variables) {
            int i = 0;
            while (i < variables.length) {
                this.fVariables.remove(variables[i]);
                ++i;
            }
        }

        public void addVariables(IValueVariable[] variables) {
            int i = 0;
            while (i < variables.length) {
                this.fVariables.add(variables[i]);
                ++i;
            }
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null || !(newInput instanceof IStringVariableManager)) {
                return;
            }
            this.discardChanges();
        }

        public void saveChanges() {
            IStringVariableManager manager = StringVariablePreferencePage.this.getVariableManager();
            manager.removeVariables(manager.getValueVariables());
            try {
                manager.addVariables(this.fVariables.toArray(new IValueVariable[0]));
            }
            catch (CoreException e) {
                DebugUIPlugin.errorDialog(StringVariablePreferencePage.this.getShell(), DebugPreferencesMessages.StringVariablePreferencePage_24, DebugPreferencesMessages.StringVariablePreferencePage_25, e.getStatus());
            }
        }

        public void discardChanges() {
            IStringVariableManager manager = StringVariablePreferencePage.this.getVariableManager();
            IValueVariable[] variables = manager.getValueVariables();
            int i = 0;
            while (i < variables.length) {
                IValueVariable variable = variables[i];
                IValueVariable copy = manager.newValueVariable(variable.getName(), variable.getDescription());
                copy.setValue(variable.getValue());
                this.fVariables.add(copy);
                ++i;
            }
        }

        public List getVariables() {
            return this.fVariables;
        }
    }

    private class SimpleVariableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        private SimpleVariableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IValueVariable) {
                IValueVariable variable = (IValueVariable)element;
                switch (columnIndex) {
                    case 0: {
                        StringBuffer buffer = new StringBuffer(variable.getName());
                        if (variable.isContributed()) {
                            String pluginId = StringVariablePreferencePage.this.getVariableManager().getContributingPluginId((IStringVariable)variable);
                            if (pluginId != null) {
                                buffer.append(MessageFormat.format((String)DebugPreferencesMessages.StringVariablePreferencePage_0, (Object[])new String[]{pluginId}));
                            } else {
                                buffer.append(DebugPreferencesMessages.SimpleLaunchVariablePreferencePage_23);
                            }
                        }
                        return buffer.toString();
                    }
                    case 1: {
                        String value = variable.getValue();
                        if (value == null) {
                            value = "";
                        }
                        return value;
                    }
                    case 2: {
                        String description = variable.getDescription();
                        if (description == null) {
                            description = "";
                        }
                        return description;
                    }
                }
            }
            return null;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            if (element instanceof IValueVariable && ((IValueVariable)element).isContributed()) {
                Display display = Display.getCurrent();
                return display.getSystemColor(29);
            }
            return null;
        }
    }
}

