/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerExtension;
import org.eclipse.jface.text.source.IVerticalRulerInfoExtension;
import org.eclipse.jface.text.source.IVerticalRulerListener;
import org.eclipse.jface.text.source.VerticalRulerEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

public class CompositeRuler
implements IVerticalRuler,
IVerticalRulerExtension,
IVerticalRulerInfoExtension {
    private ITextViewer fTextViewer;
    private CompositeRulerCanvas fComposite;
    private IAnnotationModel fModel;
    private List fDecorators = new ArrayList(2);
    private Point fLocation = new Point(-1, -1);
    private int fLastMouseButtonActivityLine = -1;
    private int fGap;
    private Set fAnnotationListeners = new HashSet();

    public CompositeRuler() {
        this(0);
    }

    public CompositeRuler(int gap) {
        this.fGap = gap;
    }

    public void addDecorator(int index, IVerticalRulerColumn rulerColumn) {
        if (index > this.fDecorators.size()) {
            this.fDecorators.add(rulerColumn);
        } else {
            this.fDecorators.add(index, rulerColumn);
        }
        if (this.fComposite != null && !this.fComposite.isDisposed()) {
            rulerColumn.createControl(this, (Composite)this.fComposite);
            this.fComposite.childAdded(rulerColumn.getControl());
            this.layoutTextViewer();
        }
    }

    public void removeDecorator(int index) {
        IVerticalRulerColumn rulerColumn = (IVerticalRulerColumn)this.fDecorators.get(index);
        this.removeDecorator(rulerColumn);
    }

    public void removeDecorator(IVerticalRulerColumn rulerColumn) {
        Control cc;
        this.fDecorators.remove(rulerColumn);
        if (rulerColumn != null && (cc = rulerColumn.getControl()) != null && !cc.isDisposed()) {
            this.fComposite.childRemoved(cc);
            cc.dispose();
        }
        this.layoutTextViewer();
    }

    private void layoutTextViewer() {
        StyledText parent = this.fTextViewer.getTextWidget();
        if (this.fTextViewer instanceof ITextViewerExtension) {
            ITextViewerExtension extension = (ITextViewerExtension)((Object)this.fTextViewer);
            parent = extension.getControl();
        }
        if (parent instanceof Composite && !parent.isDisposed()) {
            ((Composite)parent).layout(true);
        }
    }

    public Control getControl() {
        return this.fComposite;
    }

    public Control createControl(Composite parent, ITextViewer textViewer) {
        this.fTextViewer = textViewer;
        this.fComposite = new CompositeRulerCanvas(parent, 0);
        this.fComposite.setLayout(new RulerLayout());
        for (IVerticalRulerColumn column : this.fDecorators) {
            column.createControl(this, (Composite)this.fComposite);
            this.fComposite.childAdded(column.getControl());
        }
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CompositeRuler.this.fTextViewer = null;
                CompositeRuler.this.fComposite = null;
                CompositeRuler.this.fModel = null;
                CompositeRuler.this.fDecorators.clear();
            }
        });
        return this.fComposite;
    }

    public void setModel(IAnnotationModel model) {
        this.fModel = model;
        for (IVerticalRulerColumn column : this.fDecorators) {
            column.setModel(model);
        }
    }

    public IAnnotationModel getModel() {
        return this.fModel;
    }

    public void update() {
        Display d;
        if (this.fComposite != null && !this.fComposite.isDisposed() && (d = this.fComposite.getDisplay()) != null) {
            d.asyncExec(new Runnable(){

                public void run() {
                    CompositeRuler.this.immediateUpdate();
                }
            });
        }
    }

    public void immediateUpdate() {
        for (IVerticalRulerColumn column : this.fDecorators) {
            column.redraw();
        }
    }

    public void setFont(Font font) {
        for (IVerticalRulerColumn column : this.fDecorators) {
            column.setFont(font);
        }
    }

    public int getWidth() {
        int width = 0;
        for (IVerticalRulerColumn column : this.fDecorators) {
            width += column.getWidth() + this.fGap;
        }
        return Math.max(0, width - this.fGap);
    }

    public int getLineOfLastMouseButtonActivity() {
        if (this.fLastMouseButtonActivityLine == -1) {
            this.fLastMouseButtonActivityLine = this.toDocumentLineNumber(this.fLocation.y);
        }
        return this.fLastMouseButtonActivityLine;
    }

    public int toDocumentLineNumber(int y_coordinate) {
        if (this.fTextViewer == null || y_coordinate == -1) {
            return -1;
        }
        StyledText text = this.fTextViewer.getTextWidget();
        int line = text.getLineIndex(y_coordinate);
        if (line == text.getLineCount() - 1 && y_coordinate > text.getLinePixel(line + 1)) {
            return -1;
        }
        return CompositeRuler.widgetLine2ModelLine(this.fTextViewer, line);
    }

    protected static final int widgetLine2ModelLine(ITextViewer viewer, int widgetLine) {
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)((Object)viewer);
            return extension.widgetLine2ModelLine(widgetLine);
        }
        try {
            IRegion r = viewer.getVisibleRegion();
            IDocument d = viewer.getDocument();
            return widgetLine += d.getLineOfOffset(r.getOffset());
        }
        catch (BadLocationException badLocationException) {
            return widgetLine;
        }
    }

    public ITextViewer getTextViewer() {
        return this.fTextViewer;
    }

    public void setLocationOfLastMouseButtonActivity(int x, int y) {
        this.fLocation.x = x;
        this.fLocation.y = y;
        this.fLastMouseButtonActivityLine = -1;
    }

    public Iterator getDecoratorIterator() {
        Assert.isNotNull((Object)this.fDecorators, (String)"fDecorators must be initialized");
        return this.fDecorators.iterator();
    }

    public IAnnotationHover getHover() {
        return null;
    }

    public void addVerticalRulerListener(IVerticalRulerListener listener) {
        this.fAnnotationListeners.add(listener);
    }

    public void removeVerticalRulerListener(IVerticalRulerListener listener) {
        this.fAnnotationListeners.remove(listener);
    }

    public void fireAnnotationSelected(VerticalRulerEvent event) {
        for (IVerticalRulerListener listener : this.fAnnotationListeners) {
            listener.annotationSelected(event);
        }
    }

    public void fireAnnotationDefaultSelected(VerticalRulerEvent event) {
        for (IVerticalRulerListener listener : this.fAnnotationListeners) {
            listener.annotationDefaultSelected(event);
        }
    }

    public void fireAnnotationContextMenuAboutToShow(VerticalRulerEvent event, Menu menu) {
        for (IVerticalRulerListener listener : this.fAnnotationListeners) {
            listener.annotationContextMenuAboutToShow(event, menu);
        }
    }

    class RulerLayout
    extends Layout {
        protected RulerLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point size = new Point(0, 0);
            int i = 0;
            while (i < children.length) {
                Point s = children[i].computeSize(-1, -1, flushCache);
                size.x += s.x;
                size.y = Math.max(size.y, s.y);
                ++i;
            }
            size.x += Math.max(0, children.length - 1) * CompositeRuler.this.fGap;
            return size;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle clArea = composite.getClientArea();
            int rulerHeight = clArea.height;
            int x = 0;
            for (IVerticalRulerColumn column : CompositeRuler.this.fDecorators) {
                int columnWidth = column.getWidth();
                column.getControl().setBounds(x, 0, columnWidth, rulerHeight);
                x += columnWidth + CompositeRuler.this.fGap;
            }
        }
    }

    static class CompositeRulerCanvas
    extends Canvas {
        private List fCachedListeners = new ArrayList();
        private Listener fMenuDetectListener = new Listener(){

            public void handleEvent(Event event) {
                Menu menu;
                if (event.type == 35 && (menu = CompositeRulerCanvas.this.getMenu()) != null) {
                    menu.setLocation(event.x, event.y);
                    menu.setVisible(true);
                }
            }
        };

        public CompositeRulerCanvas(Composite parent, int style) {
            super(parent, style);
            super.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (CompositeRulerCanvas.this.fCachedListeners != null) {
                        CompositeRulerCanvas.this.fCachedListeners.clear();
                        CompositeRulerCanvas.this.fCachedListeners = null;
                    }
                }
            });
        }

        private void addListener(Class clazz, Control control, EventListener listener) {
            if (ControlListener.class.equals((Object)clazz)) {
                control.addControlListener((ControlListener)listener);
                return;
            }
            if (FocusListener.class.equals((Object)clazz)) {
                control.addFocusListener((FocusListener)listener);
                return;
            }
            if (HelpListener.class.equals((Object)clazz)) {
                control.addHelpListener((HelpListener)listener);
                return;
            }
            if (KeyListener.class.equals((Object)clazz)) {
                control.addKeyListener((KeyListener)listener);
                return;
            }
            if (MouseListener.class.equals((Object)clazz)) {
                control.addMouseListener((MouseListener)listener);
                return;
            }
            if (MouseMoveListener.class.equals((Object)clazz)) {
                control.addMouseMoveListener((MouseMoveListener)listener);
                return;
            }
            if (MouseTrackListener.class.equals((Object)clazz)) {
                control.addMouseTrackListener((MouseTrackListener)listener);
                return;
            }
            if (PaintListener.class.equals((Object)clazz)) {
                control.addPaintListener((PaintListener)listener);
                return;
            }
            if (TraverseListener.class.equals((Object)clazz)) {
                control.addTraverseListener((TraverseListener)listener);
                return;
            }
            if (DisposeListener.class.equals((Object)clazz)) {
                control.addDisposeListener((DisposeListener)listener);
                return;
            }
        }

        private void removeListener(Class clazz, Control control, EventListener listener) {
            if (ControlListener.class.equals((Object)clazz)) {
                control.removeControlListener((ControlListener)listener);
                return;
            }
            if (FocusListener.class.equals((Object)clazz)) {
                control.removeFocusListener((FocusListener)listener);
                return;
            }
            if (HelpListener.class.equals((Object)clazz)) {
                control.removeHelpListener((HelpListener)listener);
                return;
            }
            if (KeyListener.class.equals((Object)clazz)) {
                control.removeKeyListener((KeyListener)listener);
                return;
            }
            if (MouseListener.class.equals((Object)clazz)) {
                control.removeMouseListener((MouseListener)listener);
                return;
            }
            if (MouseMoveListener.class.equals((Object)clazz)) {
                control.removeMouseMoveListener((MouseMoveListener)listener);
                return;
            }
            if (MouseTrackListener.class.equals((Object)clazz)) {
                control.removeMouseTrackListener((MouseTrackListener)listener);
                return;
            }
            if (PaintListener.class.equals((Object)clazz)) {
                control.removePaintListener((PaintListener)listener);
                return;
            }
            if (TraverseListener.class.equals((Object)clazz)) {
                control.removeTraverseListener((TraverseListener)listener);
                return;
            }
            if (DisposeListener.class.equals((Object)clazz)) {
                control.removeDisposeListener((DisposeListener)listener);
                return;
            }
        }

        private void addListener(Class clazz, EventListener listener) {
            Control[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] != null && !children[i].isDisposed()) {
                    this.addListener(clazz, children[i], listener);
                }
                ++i;
            }
            ListenerInfo info = new ListenerInfo();
            info.fClass = clazz;
            info.fListener = listener;
            this.fCachedListeners.add(info);
        }

        private void removeListener(Class clazz, EventListener listener) {
            int length = this.fCachedListeners.size();
            int i = 0;
            while (i < length) {
                ListenerInfo info = (ListenerInfo)this.fCachedListeners.get(i);
                if (listener == info.fListener && clazz.equals(info.fClass)) {
                    this.fCachedListeners.remove(i);
                    break;
                }
                ++i;
            }
            Control[] children = this.getChildren();
            int i2 = 0;
            while (i2 < children.length) {
                if (children[i2] != null && !children[i2].isDisposed()) {
                    this.removeListener(clazz, children[i2], listener);
                }
                ++i2;
            }
        }

        public void childAdded(Control child) {
            if (child != null && !child.isDisposed()) {
                int length = this.fCachedListeners.size();
                int i = 0;
                while (i < length) {
                    ListenerInfo info = (ListenerInfo)this.fCachedListeners.get(i);
                    this.addListener(info.fClass, child, info.fListener);
                    ++i;
                }
                child.addListener(35, this.fMenuDetectListener);
            }
        }

        public void childRemoved(Control child) {
            if (child != null && !child.isDisposed()) {
                int length = this.fCachedListeners.size();
                int i = 0;
                while (i < length) {
                    ListenerInfo info = (ListenerInfo)this.fCachedListeners.get(i);
                    this.removeListener(info.fClass, child, info.fListener);
                    ++i;
                }
                child.removeListener(35, this.fMenuDetectListener);
            }
        }

        public void removeControlListener(ControlListener listener) {
            this.removeListener(ControlListener.class, (EventListener)listener);
            super.removeControlListener(listener);
        }

        public void removeFocusListener(FocusListener listener) {
            this.removeListener(FocusListener.class, (EventListener)listener);
            super.removeFocusListener(listener);
        }

        public void removeHelpListener(HelpListener listener) {
            this.removeListener(HelpListener.class, (EventListener)listener);
            super.removeHelpListener(listener);
        }

        public void removeKeyListener(KeyListener listener) {
            this.removeListener(KeyListener.class, (EventListener)listener);
            super.removeKeyListener(listener);
        }

        public void removeMouseListener(MouseListener listener) {
            this.removeListener(MouseListener.class, (EventListener)listener);
            super.removeMouseListener(listener);
        }

        public void removeMouseMoveListener(MouseMoveListener listener) {
            this.removeListener(MouseMoveListener.class, (EventListener)listener);
            super.removeMouseMoveListener(listener);
        }

        public void removeMouseTrackListener(MouseTrackListener listener) {
            this.removeListener(MouseTrackListener.class, (EventListener)listener);
            super.removeMouseTrackListener(listener);
        }

        public void removePaintListener(PaintListener listener) {
            this.removeListener(PaintListener.class, (EventListener)listener);
            super.removePaintListener(listener);
        }

        public void removeTraverseListener(TraverseListener listener) {
            this.removeListener(TraverseListener.class, (EventListener)listener);
            super.removeTraverseListener(listener);
        }

        public void removeDisposeListener(DisposeListener listener) {
            this.removeListener(DisposeListener.class, (EventListener)listener);
            super.removeDisposeListener(listener);
        }

        public void addControlListener(ControlListener listener) {
            super.addControlListener(listener);
            this.addListener(ControlListener.class, (EventListener)listener);
        }

        public void addFocusListener(FocusListener listener) {
            super.addFocusListener(listener);
            this.addListener(FocusListener.class, (EventListener)listener);
        }

        public void addHelpListener(HelpListener listener) {
            super.addHelpListener(listener);
            this.addListener(HelpListener.class, (EventListener)listener);
        }

        public void addKeyListener(KeyListener listener) {
            super.addKeyListener(listener);
            this.addListener(KeyListener.class, (EventListener)listener);
        }

        public void addMouseListener(MouseListener listener) {
            super.addMouseListener(listener);
            this.addListener(MouseListener.class, (EventListener)listener);
        }

        public void addMouseMoveListener(MouseMoveListener listener) {
            super.addMouseMoveListener(listener);
            this.addListener(MouseMoveListener.class, (EventListener)listener);
        }

        public void addMouseTrackListener(MouseTrackListener listener) {
            super.addMouseTrackListener(listener);
            this.addListener(MouseTrackListener.class, (EventListener)listener);
        }

        public void addPaintListener(PaintListener listener) {
            super.addPaintListener(listener);
            this.addListener(PaintListener.class, (EventListener)listener);
        }

        public void addTraverseListener(TraverseListener listener) {
            super.addTraverseListener(listener);
            this.addListener(TraverseListener.class, (EventListener)listener);
        }

        public void addDisposeListener(DisposeListener listener) {
            super.addDisposeListener(listener);
            this.addListener(DisposeListener.class, (EventListener)listener);
        }

        static class ListenerInfo {
            Class fClass;
            EventListener fListener;

            ListenerInfo() {
            }
        }
    }
}

