/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.boot;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.boot.IPlatformRunnable;
import org.eclipse.core.internal.boot.PlatformConfiguration;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.Platform;
import org.eclipse.update.configurator.IPlatformConfigurationFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class BootLoader {
    public static boolean CONFIGURATION_DEBUG = false;
    public static final String PI_BOOT = "org.eclipse.core.boot";
    public static final String OS_WIN32 = "win32";
    public static final String OS_LINUX = "linux";
    public static final String OS_AIX = "aix";
    public static final String OS_SOLARIS = "solaris";
    public static final String OS_HPUX = "hpux";
    public static final String OS_QNX = "qnx";
    public static final String OS_MACOSX = "macosx";
    public static final String OS_UNKNOWN = "unknown";
    public static final String ARCH_X86 = "x86";
    public static final String ARCH_PA_RISC = "PA_RISC";
    public static final String ARCH_PPC = "ppc";
    public static final String ARCH_SPARC = "sparc";
    public static final String WS_WIN32 = "win32";
    public static final String WS_MOTIF = "motif";
    public static final String WS_GTK = "gtk";
    public static final String WS_PHOTON = "photon";
    public static final String WS_CARBON = "carbon";
    public static final String WS_UNKNOWN = "unknown";

    private BootLoader() {
    }

    public static String[] getCommandLineArgs() {
        return InternalPlatform.getDefault().getApplicationArgs();
    }

    public static IPlatformConfiguration getCurrentPlatformConfiguration() {
        BundleContext context = InternalPlatform.getDefault().getBundleContext();
        ServiceReference configFactorySR = context.getServiceReference(IPlatformConfigurationFactory.class.getName());
        if (configFactorySR == null) {
            throw new IllegalStateException();
        }
        IPlatformConfigurationFactory configFactory = (IPlatformConfigurationFactory)context.getService(configFactorySR);
        if (configFactory == null) {
            throw new IllegalStateException();
        }
        org.eclipse.update.configurator.IPlatformConfiguration currentConfig = configFactory.getCurrentPlatformConfiguration();
        context.ungetService(configFactorySR);
        return new PlatformConfiguration(currentConfig);
    }

    public static URL getInstallURL() {
        return InternalPlatform.getDefault().getInstallURL();
    }

    public static String getNL() {
        return InternalPlatform.getDefault().getNL();
    }

    public static String getOS() {
        return InternalPlatform.getDefault().getOS();
    }

    public static String getOSArch() {
        return InternalPlatform.getDefault().getOSArch();
    }

    public static IPlatformConfiguration getPlatformConfiguration(URL url) throws IOException {
        BundleContext context = InternalPlatform.getDefault().getBundleContext();
        ServiceReference configFactorySR = context.getServiceReference(IPlatformConfigurationFactory.class.getName());
        if (configFactorySR == null) {
            throw new IllegalStateException();
        }
        IPlatformConfigurationFactory configFactory = (IPlatformConfigurationFactory)context.getService(configFactorySR);
        if (configFactory == null) {
            throw new IllegalStateException();
        }
        org.eclipse.update.configurator.IPlatformConfiguration config = configFactory.getPlatformConfiguration(url);
        context.ungetService(configFactorySR);
        return new PlatformConfiguration(config);
    }

    public static String getWS() {
        return InternalPlatform.getDefault().getWS();
    }

    public static String[] knownOSArchValues() {
        return Platform.knownOSArchValues();
    }

    public static String[] knownOSValues() {
        return Platform.knownOSValues();
    }

    public static String[] knownWSValues() {
        return Platform.knownWSValues();
    }

    public static boolean inDebugMode() {
        return Platform.inDebugMode();
    }

    public static boolean inDevelopmentMode() {
        return Platform.inDevelopmentMode();
    }

    public static boolean isRunning() {
        return InternalPlatform.getDefault().isRunning();
    }

    public static URL[] getPluginPath(URL pluginPathLocation) {
        return InternalPlatform.getDefault().getPluginPath(pluginPathLocation);
    }

    public static boolean containsSavedPlatform(String location) {
        return true;
    }

    public static IPlatformRunnable getRunnable(String applicationName) throws Exception {
        return null;
    }

    public static IPlatformRunnable getRunnable(String pluginId, String className, Object args) throws Exception {
        return null;
    }

    public static Object run(String applicationName, URL pluginPathLocation, String location, String[] args) throws Exception {
        return null;
    }

    public static Object run(String applicationName, URL pluginPathLocation, String location, String[] args, Runnable handler) throws Exception {
        return null;
    }

    public static void shutdown() throws Exception {
    }

    public static String[] startup(URL pluginPathLocation, String location, String[] args) throws Exception {
        return null;
    }

    public static String[] startup(URL pluginPathLocation, String location, String[] args, Runnable handler) throws Exception {
        return null;
    }
}

