/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import java.util.Dictionary;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.help.search.ISearchEngine;
import org.eclipse.help.search.ISearchScope;
import org.eclipse.help.ui.ISearchScopeFactory;
import org.eclipse.help.ui.RootScopePage;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class EngineTypeDescriptor {
    private IConfigurationElement config;
    private Image image;
    private ISearchScopeFactory factory;

    public EngineTypeDescriptor(IConfigurationElement config) {
        this.config = config;
    }

    public IConfigurationElement getConfig() {
        return this.config;
    }

    public IConfigurationElement[] getPages() {
        return this.config.getChildren("subpage");
    }

    public String getLabel() {
        return this.config.getAttribute("label");
    }

    public String getId() {
        return this.config.getAttribute("id");
    }

    public Image getIconImage() {
        if (this.image != null) {
            return this.image;
        }
        String icon = this.config.getAttribute("icon");
        if (icon != null) {
            String bundleId = this.config.getContributor().getName();
            HelpUIResources.getImageDescriptor(bundleId, icon);
            return HelpUIResources.getImage(icon);
        }
        this.image = HelpUIResources.getImage("etool16/helpsearch_co.gif");
        return this.image;
    }

    public String getDescription() {
        String desc = null;
        IConfigurationElement[] children = this.config.getChildren("description");
        if (children.length == 1) {
            desc = children[0].getValue();
        }
        return desc;
    }

    public ImageDescriptor getImageDescriptor() {
        ImageDescriptor desc = null;
        String icon = this.config.getAttribute("icon");
        desc = icon != null ? HelpUIResources.getImageDescriptor(icon) : HelpUIResources.getImageDescriptor("etool16/helpsearch_co.gif");
        return desc;
    }

    public RootScopePage createRootPage(String scopeSetName) {
        try {
            Object obj = this.config.createExecutableExtension("pageClass");
            if (obj instanceof RootScopePage) {
                RootScopePage page = (RootScopePage)obj;
                return page;
            }
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public ISearchEngine createEngine() {
        String eclass = this.config.getAttribute("class");
        if (eclass != null) {
            try {
                Object obj = this.config.createExecutableExtension("class");
                if (obj instanceof ISearchEngine) {
                    return (ISearchEngine)obj;
                }
            }
            catch (CoreException coreException) {
                HelpUIPlugin.logWarning("Engine " + eclass + " cannot be instantiated");
            }
        }
        return null;
    }

    public ISearchScope createSearchScope(IPreferenceStore store, String engineId, Dictionary parameters) {
        String fclass;
        if (this.factory == null && (fclass = this.config.getAttribute("scopeFactory")) != null) {
            try {
                Object obj = this.config.createExecutableExtension("scopeFactory");
                if (obj instanceof ISearchScopeFactory) {
                    this.factory = (ISearchScopeFactory)obj;
                }
            }
            catch (CoreException coreException) {
                HelpUIPlugin.logWarning("Scope factory " + fclass + " cannot be instantiated");
            }
        }
        if (this.factory != null) {
            return this.factory.createSearchScope(store, engineId, parameters);
        }
        return null;
    }
}

