/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.internal.debug.core.refactoring.BreakpointChange;
import org.eclipse.jdt.internal.debug.core.refactoring.BreakpointRenameParticipant;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;

public class BreakpointRenameProjectParticipant
extends BreakpointRenameParticipant {
    protected boolean accepts(IJavaElement element) {
        return element instanceof IJavaProject;
    }

    protected void gatherChanges(IMarker[] markers, List changes, String destProjectName) throws CoreException, OperationCanceledException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(destProjectName);
        IJavaProject destProject = JavaCore.create((IProject)project);
        int i = 0;
        while (i < markers.length) {
            IJavaBreakpoint javaBreakpoint;
            IType breakpointType;
            IMarker marker = markers[i];
            IBreakpoint breakpoint = this.getBreakpoint(marker);
            if (breakpoint instanceof IJavaBreakpoint && (breakpointType = BreakpointUtils.getType(javaBreakpoint = (IJavaBreakpoint)breakpoint)) != null) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)breakpointType.getPackageFragment().getParent();
                Object rootResource = null;
                rootResource = root.getCorrespondingResource().equals((Object)this.getOriginalElement().getCorrespondingResource()) ? project : project.getFolder(root.getElementName());
                IPackageFragmentRoot destRoot = destProject.getPackageFragmentRoot((IResource)rootResource);
                IPackageFragment destPackage = destRoot.getPackageFragment(breakpointType.getPackageFragment().getElementName());
                ICompilationUnit destCU = destPackage.getCompilationUnit(breakpointType.getCompilationUnit().getElementName());
                IJavaElement element = BreakpointChange.findElement((IJavaElement)destCU, (IJavaElement)breakpointType);
                if (element != null && element instanceof IType) {
                    IType destType = (IType)element;
                    changes.add(this.createTypeChange(javaBreakpoint, destType, breakpointType));
                }
            }
            ++i;
        }
    }
}

