/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.explorer;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.composite.explorer.TreeLabelProvider;
import org.eclipse.ui.internal.cheatsheets.composite.model.AbstractTask;

public class ConfirmRestartDialog
extends Dialog {
    private AbstractTask[] tasks;
    private TreeLabelProvider treeLabelProvider;

    protected ConfirmRestartDialog(Shell parentShell, AbstractTask[] restartTasks, TreeLabelProvider treeLabelProvider) {
        super(parentShell);
        this.tasks = restartTasks;
        this.treeLabelProvider = treeLabelProvider;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Label header = new Label(composite, 0);
        header.setText(Messages.COMPOSITE_RESET_TASK_DIALOG_MESSAGE);
        TableViewer viewer = new TableViewer(parent, 2816);
        viewer.setContentProvider((IContentProvider)new TaskContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new TaskLabelProvider());
        viewer.setInput((Object)this.tasks);
        GridData taskData = new GridData();
        taskData.widthHint = 400;
        taskData.heightHint = 200;
        taskData.horizontalAlignment = 4;
        taskData.verticalAlignment = 4;
        viewer.getControl().setLayoutData((Object)taskData);
        return composite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setImage(CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_RETURN"));
        this.setShellStyle(this.getShellStyle() | 0x10);
        newShell.setText(Messages.COMPOSITE_RESET_TASK_DIALOG_TITLE);
    }

    public class TaskLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object obj, int index) {
            return ConfirmRestartDialog.this.treeLabelProvider.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return ConfirmRestartDialog.this.treeLabelProvider.getImage(obj);
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }

    public class TaskContentProvider
    implements IStructuredContentProvider {
        Object[] input;

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            this.input = (Object[])newInput;
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return this.input;
        }
    }
}

