/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.HashSet;
import org.eclipse.jdt.internal.ui.search.JavaSearchContentProvider;
import org.eclipse.jdt.internal.ui.search.JavaSearchResult;
import org.eclipse.jdt.internal.ui.search.JavaSearchResultPage;
import org.eclipse.jdt.internal.ui.search.MatchFilter;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;

public class JavaSearchTableContentProvider
extends JavaSearchContentProvider
implements IStructuredContentProvider {
    public JavaSearchTableContentProvider(JavaSearchResultPage page) {
        super(page);
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof JavaSearchResult) {
            HashSet<Object> filteredElements = new HashSet<Object>();
            Object[] rawElements = ((JavaSearchResult)((Object)inputElement)).getElements();
            int i = 0;
            while (i < rawElements.length) {
                if (this.getPage().getDisplayedMatchCount(rawElements[i]) > 0) {
                    filteredElements.add(rawElements[i]);
                }
                ++i;
            }
            return filteredElements.toArray();
        }
        return this.EMPTY_ARR;
    }

    public void elementsChanged(Object[] updatedElements) {
        if (this.fResult == null) {
            return;
        }
        int addCount = 0;
        int removeCount = 0;
        TableViewer viewer = (TableViewer)this.getPage().getViewer();
        HashSet<Object> updated = new HashSet<Object>();
        HashSet<Object> added = new HashSet<Object>();
        HashSet<Object> removed = new HashSet<Object>();
        int i = 0;
        while (i < updatedElements.length) {
            if (this.getPage().getDisplayedMatchCount(updatedElements[i]) > 0) {
                if (viewer.testFindItem(updatedElements[i]) != null) {
                    updated.add(updatedElements[i]);
                } else {
                    added.add(updatedElements[i]);
                }
                ++addCount;
            } else {
                removed.add(updatedElements[i]);
                ++removeCount;
            }
            ++i;
        }
        viewer.add(added.toArray());
        viewer.update(updated.toArray(), new String[]{"org.eclipse.jdt.search.matchCount"});
        viewer.remove(removed.toArray());
    }

    public void filtersChanged(MatchFilter[] filters) {
        super.filtersChanged(filters);
        this.getPage().getViewer().refresh();
    }

    public void clear() {
        this.getPage().getViewer().refresh();
    }
}

