/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.context;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.CartesianDistCalc;
import com.spatial4j.core.distance.DistanceCalculator;
import com.spatial4j.core.distance.GeodesicSphereDistCalc;
import com.spatial4j.core.io.BinaryCodec;
import com.spatial4j.core.io.GeoJSONReader;
import com.spatial4j.core.io.GeoJSONWriter;
import com.spatial4j.core.io.LegacyShapeReader;
import com.spatial4j.core.io.LegacyShapeWriter;
import com.spatial4j.core.io.PolyshapeReader;
import com.spatial4j.core.io.PolyshapeWriter;
import com.spatial4j.core.io.ShapeReader;
import com.spatial4j.core.io.ShapeWriter;
import com.spatial4j.core.io.SupportedFormats;
import com.spatial4j.core.io.WKTReader;
import com.spatial4j.core.io.WKTWriter;
import com.spatial4j.core.shape.Rectangle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SpatialContextFactory {
    protected Map<String, String> args;
    protected ClassLoader classLoader;
    public boolean geo = true;
    public DistanceCalculator distCalc;
    public Rectangle worldBounds;
    public boolean normWrapLongitude = false;
    public Class<? extends BinaryCodec> binaryCodecClass = BinaryCodec.class;
    public final List<Class<? extends ShapeReader>> readers = new ArrayList<Class<? extends ShapeReader>>();
    public final List<Class<? extends ShapeWriter>> writers = new ArrayList<Class<? extends ShapeWriter>>();
    public boolean hasFormatConfig = false;

    public static SpatialContext makeSpatialContext(Map<String, String> args, ClassLoader classLoader) {
        SpatialContextFactory instance;
        String cname;
        if (classLoader == null) {
            classLoader = SpatialContextFactory.class.getClassLoader();
        }
        if ((cname = args.get("spatialContextFactory")) == null) {
            cname = System.getProperty("SpatialContextFactory");
        }
        if (cname == null) {
            instance = new SpatialContextFactory();
        } else {
            try {
                Class<?> c = classLoader.loadClass(cname);
                instance = (SpatialContextFactory)c.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        instance.init(args, classLoader);
        return instance.newSpatialContext();
    }

    protected void init(Map<String, String> args, ClassLoader classLoader) {
        this.args = args;
        this.classLoader = classLoader;
        this.initField("geo");
        this.initCalculator();
        this.initFormats();
        this.initWorldBounds();
        this.initField("normWrapLongitude");
        this.initField("binaryCodecClass");
    }

    protected void initField(String name) {
        Field field;
        try {
            field = this.getClass().getField(name);
        }
        catch (NoSuchFieldException e) {
            throw new Error(e);
        }
        String str = this.args.get(name);
        if (str != null) {
            try {
                Object o;
                if (field.getType() == Boolean.TYPE) {
                    o = Boolean.valueOf(str);
                } else if (field.getType() == Class.class) {
                    try {
                        o = this.classLoader.loadClass(str);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                } else if (field.getType().isEnum()) {
                    o = Enum.valueOf(field.getType().asSubclass(Enum.class), str);
                } else {
                    throw new Error("unsupported field type: " + field.getType());
                }
                field.set(this, o);
            }
            catch (IllegalAccessException e) {
                throw new Error(e);
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid value '" + str + "' on field " + name + " of type " + field.getType(), e);
            }
        }
    }

    protected void initCalculator() {
        String calcStr = this.args.get("distCalculator");
        if (calcStr == null) {
            return;
        }
        if (calcStr.equalsIgnoreCase("haversine")) {
            this.distCalc = new GeodesicSphereDistCalc.Haversine();
        } else if (calcStr.equalsIgnoreCase("lawOfCosines")) {
            this.distCalc = new GeodesicSphereDistCalc.LawOfCosines();
        } else if (calcStr.equalsIgnoreCase("vincentySphere")) {
            this.distCalc = new GeodesicSphereDistCalc.Vincenty();
        } else if (calcStr.equalsIgnoreCase("cartesian")) {
            this.distCalc = new CartesianDistCalc();
        } else if (calcStr.equalsIgnoreCase("cartesian^2")) {
            this.distCalc = new CartesianDistCalc(true);
        } else {
            throw new RuntimeException("Unknown calculator: " + calcStr);
        }
    }

    protected void initFormats() {
        try {
            String val = this.args.get("readers");
            if (val != null) {
                for (String name : val.split(",")) {
                    this.readers.add(Class.forName(name.trim(), false, this.classLoader).asSubclass(ShapeReader.class));
                }
            } else {
                val = this.args.get("wktShapeParserClass");
                if (val != null) {
                    this.readers.add(Class.forName(val.trim(), false, this.classLoader).asSubclass(ShapeReader.class));
                }
            }
            if ((val = this.args.get("writers")) != null) {
                for (String name : val.split(",")) {
                    this.writers.add(Class.forName(name.trim(), false, this.classLoader).asSubclass(ShapeWriter.class));
                }
            }
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Unable to find format class", ex);
        }
    }

    public SupportedFormats makeFormats(SpatialContext ctx) {
        this.checkDefaultFormats();
        ArrayList<ShapeReader> read = new ArrayList<ShapeReader>(this.readers.size());
        for (Class<? extends ShapeReader> clazz : this.readers) {
            try {
                read.add(this.makeClassInstance(clazz, ctx, this));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        ArrayList<ShapeWriter> write = new ArrayList<ShapeWriter>(this.writers.size());
        for (Class<? extends ShapeWriter> clazz : this.writers) {
            try {
                write.add(this.makeClassInstance(clazz, ctx, this));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return new SupportedFormats(Collections.unmodifiableList(read), Collections.unmodifiableList(write));
    }

    protected void checkDefaultFormats() {
        if (this.readers.isEmpty()) {
            this.addReaderIfNoggitExists(GeoJSONReader.class);
            this.readers.add(WKTReader.class);
            this.readers.add(PolyshapeReader.class);
            this.readers.add(LegacyShapeReader.class);
        }
        if (this.writers.isEmpty()) {
            this.writers.add(GeoJSONWriter.class);
            this.writers.add(WKTWriter.class);
            this.writers.add(PolyshapeWriter.class);
            this.writers.add(LegacyShapeWriter.class);
        }
    }

    public void addReaderIfNoggitExists(Class<? extends ShapeReader> reader) {
        try {
            if (this.classLoader == null) {
                Class.forName("org.noggit.JSONParser");
            } else {
                Class.forName("org.noggit.JSONParser", true, this.classLoader);
            }
            this.readers.add(reader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected void initWorldBounds() {
        String worldBoundsStr = this.args.get("worldBounds");
        if (worldBoundsStr == null) {
            return;
        }
        SpatialContext ctx = this.newSpatialContext();
        this.worldBounds = (Rectangle)ctx.readShape(worldBoundsStr);
    }

    public SpatialContext newSpatialContext() {
        return new SpatialContext(this);
    }

    public BinaryCodec makeBinaryCodec(SpatialContext ctx) {
        return this.makeClassInstance(this.binaryCodecClass, ctx, this);
    }

    private <T> T makeClassInstance(Class<? extends T> clazz, Object ... ctorArgs) {
        try {
            Constructor<?> empty = null;
            block2: for (Constructor<?> ctor : clazz.getConstructors()) {
                Class<?>[] parameterTypes = ctor.getParameterTypes();
                if (parameterTypes.length == 0) {
                    empty = ctor;
                }
                if (parameterTypes.length != ctorArgs.length) continue;
                for (int i = 0; i < ctorArgs.length; ++i) {
                    Object ctorArg = ctorArgs[i];
                    if (!parameterTypes[i].isAssignableFrom(ctorArg.getClass())) continue block2;
                }
                return clazz.cast(ctor.newInstance(ctorArgs));
            }
            if (empty != null) {
                return clazz.cast(empty.newInstance(new Object[0]));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException(clazz + " needs a constructor that takes: " + Arrays.toString(ctorArgs));
    }
}

