/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.shards;

import com.carrotsearch.hppc.cursors.IntObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.collect.ImmutableOpenIntMap;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class IndicesShardStoresResponse
extends ActionResponse
implements ToXContent {
    private ImmutableOpenMap<String, ImmutableOpenIntMap<List<StoreStatus>>> storeStatuses;
    private List<Failure> failures;

    public IndicesShardStoresResponse(ImmutableOpenMap<String, ImmutableOpenIntMap<List<StoreStatus>>> storeStatuses, List<Failure> failures) {
        this.storeStatuses = storeStatuses;
        this.failures = failures;
    }

    IndicesShardStoresResponse() {
        this(ImmutableOpenMap.of(), Collections.emptyList());
    }

    public ImmutableOpenMap<String, ImmutableOpenIntMap<List<StoreStatus>>> getStoreStatuses() {
        return this.storeStatuses;
    }

    public List<Failure> getFailures() {
        return this.failures;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int numResponse = in.readVInt();
        ImmutableOpenMap.Builder storeStatusesBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < numResponse; ++i) {
            String index = in.readString();
            int indexEntries = in.readVInt();
            ImmutableOpenIntMap.Builder shardEntries = ImmutableOpenIntMap.builder();
            for (int shardCount = 0; shardCount < indexEntries; ++shardCount) {
                int shardID = in.readInt();
                int nodeEntries = in.readVInt();
                ArrayList<StoreStatus> storeStatuses = new ArrayList<StoreStatus>(nodeEntries);
                for (int nodeCount = 0; nodeCount < nodeEntries; ++nodeCount) {
                    storeStatuses.add(StoreStatus.readStoreStatus(in));
                }
                shardEntries.put(shardID, storeStatuses);
            }
            storeStatusesBuilder.put(index, shardEntries.build());
        }
        int numFailure = in.readVInt();
        ArrayList<Failure> failureBuilder = new ArrayList<Failure>();
        for (int i = 0; i < numFailure; ++i) {
            failureBuilder.add(Failure.readFailure(in));
        }
        this.storeStatuses = storeStatusesBuilder.build();
        this.failures = Collections.unmodifiableList(failureBuilder);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.storeStatuses.size());
        for (ObjectObjectCursor<String, ImmutableOpenIntMap<List<StoreStatus>>> objectObjectCursor : this.storeStatuses) {
            out.writeString((String)objectObjectCursor.key);
            out.writeVInt(((ImmutableOpenIntMap)objectObjectCursor.value).size());
            for (IntObjectCursor shardStatusesEntry : (ImmutableOpenIntMap)objectObjectCursor.value) {
                out.writeInt(shardStatusesEntry.key);
                out.writeVInt(((List)shardStatusesEntry.value).size());
                for (StoreStatus storeStatus : (List)shardStatusesEntry.value) {
                    storeStatus.writeTo(out);
                }
            }
        }
        out.writeVInt(this.failures.size());
        for (ShardOperationFailedException shardOperationFailedException : this.failures) {
            shardOperationFailedException.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.failures.size() > 0) {
            builder.startArray(Fields.FAILURES);
            for (ShardOperationFailedException shardOperationFailedException : this.failures) {
                builder.startObject();
                shardOperationFailedException.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
        }
        builder.startObject(Fields.INDICES);
        for (ObjectObjectCursor objectObjectCursor : this.storeStatuses) {
            builder.startObject((String)objectObjectCursor.key);
            builder.startObject(Fields.SHARDS);
            for (IntObjectCursor shardStatusesEntry : (ImmutableOpenIntMap)objectObjectCursor.value) {
                builder.startObject(String.valueOf(shardStatusesEntry.key));
                builder.startArray(Fields.STORES);
                for (StoreStatus storeStatus : (List)shardStatusesEntry.value) {
                    builder.startObject();
                    storeStatus.toXContent(builder, params);
                    builder.endObject();
                }
                builder.endArray();
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString INDICES = new XContentBuilderString("indices");
        static final XContentBuilderString SHARDS = new XContentBuilderString("shards");
        static final XContentBuilderString FAILURES = new XContentBuilderString("failures");
        static final XContentBuilderString STORES = new XContentBuilderString("stores");
        static final XContentBuilderString VERSION = new XContentBuilderString("version");
        static final XContentBuilderString STORE_EXCEPTION = new XContentBuilderString("store_exception");
        static final XContentBuilderString ALLOCATED = new XContentBuilderString("allocation");

        Fields() {
        }
    }

    public static class Failure
    extends DefaultShardOperationFailedException {
        private String nodeId;

        public Failure(String nodeId, String index, int shardId, Throwable reason) {
            super(index, shardId, reason);
            this.nodeId = nodeId;
        }

        private Failure() {
        }

        public String nodeId() {
            return this.nodeId;
        }

        public static Failure readFailure(StreamInput in) throws IOException {
            Failure failure = new Failure();
            failure.readFrom(in);
            return failure;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.nodeId = in.readString();
            super.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeId);
            super.writeTo(out);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("node", this.nodeId());
            super.toXContent(builder, params);
            return builder;
        }
    }

    public static class StoreStatus
    implements Streamable,
    ToXContent,
    Comparable<StoreStatus> {
        private DiscoveryNode node;
        private long version;
        private Throwable storeException;
        private Allocation allocation;

        private StoreStatus() {
        }

        public StoreStatus(DiscoveryNode node, long version, Allocation allocation, Throwable storeException) {
            this.node = node;
            this.version = version;
            this.allocation = allocation;
            this.storeException = storeException;
        }

        public DiscoveryNode getNode() {
            return this.node;
        }

        public long getVersion() {
            return this.version;
        }

        public Throwable getStoreException() {
            return this.storeException;
        }

        public Allocation getAllocation() {
            return this.allocation;
        }

        static StoreStatus readStoreStatus(StreamInput in) throws IOException {
            StoreStatus storeStatus = new StoreStatus();
            storeStatus.readFrom(in);
            return storeStatus;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.node = DiscoveryNode.readNode(in);
            this.version = in.readLong();
            this.allocation = Allocation.readFrom(in);
            if (in.readBoolean()) {
                this.storeException = in.readThrowable();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.node.writeTo(out);
            out.writeLong(this.version);
            this.allocation.writeTo(out);
            if (this.storeException != null) {
                out.writeBoolean(true);
                out.writeThrowable(this.storeException);
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.node.toXContent(builder, params);
            builder.field(Fields.VERSION, this.version);
            builder.field(Fields.ALLOCATED, this.allocation.value());
            if (this.storeException != null) {
                builder.startObject(Fields.STORE_EXCEPTION);
                ElasticsearchException.toXContent(builder, params, this.storeException);
                builder.endObject();
            }
            return builder;
        }

        @Override
        public int compareTo(StoreStatus other) {
            if (this.storeException != null && other.storeException == null) {
                return 1;
            }
            if (other.storeException != null && this.storeException == null) {
                return -1;
            }
            int compare = Long.compare(other.version, this.version);
            if (compare == 0) {
                return Integer.compare(this.allocation.id, other.allocation.id);
            }
            return compare;
        }

        public static enum Allocation {
            PRIMARY(0),
            REPLICA(1),
            UNUSED(2);

            private final byte id;

            private Allocation(byte id) {
                this.id = id;
            }

            private static Allocation fromId(byte id) {
                switch (id) {
                    case 0: {
                        return PRIMARY;
                    }
                    case 1: {
                        return REPLICA;
                    }
                    case 2: {
                        return UNUSED;
                    }
                }
                throw new IllegalArgumentException("unknown id for allocation [" + id + "]");
            }

            public String value() {
                switch (this.id) {
                    case 0: {
                        return "primary";
                    }
                    case 1: {
                        return "replica";
                    }
                    case 2: {
                        return "unused";
                    }
                }
                throw new IllegalArgumentException("unknown id for allocation [" + this.id + "]");
            }

            private static Allocation readFrom(StreamInput in) throws IOException {
                return Allocation.fromId(in.readByte());
            }

            private void writeTo(StreamOutput out) throws IOException {
                out.writeByte(this.id);
            }
        }
    }
}

