/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportRequest;

public class ChildTaskRequest
extends TransportRequest {
    private TaskId parentTaskId = TaskId.EMPTY_TASK_ID;

    protected ChildTaskRequest() {
    }

    protected ChildTaskRequest(TransportRequest parentTaskRequest) {
        super(parentTaskRequest);
    }

    public void setParentTask(String parentTaskNode, long parentTaskId) {
        this.parentTaskId = new TaskId(parentTaskNode, parentTaskId);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.getVersion().onOrAfter(Version.V_2_3_0)) {
            this.parentTaskId = new TaskId(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_2_3_0)) {
            this.parentTaskId.writeTo(out);
        }
    }

    @Override
    public final Task createTask(long id, String type, String action) {
        return this.createTask(id, type, action, this.parentTaskId);
    }

    public Task createTask(long id, String type, String action, TaskId parentTaskId) {
        return new Task(id, type, action, this.getDescription(), parentTaskId);
    }
}

