/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.InternalClusterInfoService;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.action.index.NodeIndexDeletedAction;
import org.elasticsearch.cluster.action.index.NodeMappingRefreshAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateFilter;
import org.elasticsearch.cluster.metadata.MetaDataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetaDataDeleteIndexService;
import org.elasticsearch.cluster.metadata.MetaDataIndexAliasesService;
import org.elasticsearch.cluster.metadata.MetaDataIndexStateService;
import org.elasticsearch.cluster.metadata.MetaDataIndexTemplateService;
import org.elasticsearch.cluster.metadata.MetaDataMappingService;
import org.elasticsearch.cluster.metadata.MetaDataUpdateSettingsService;
import org.elasticsearch.cluster.node.DiscoveryNodeService;
import org.elasticsearch.cluster.routing.OperationRouting;
import org.elasticsearch.cluster.routing.RoutingService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancedShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.AwarenessAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ClusterRebalanceAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ConcurrentRebalanceAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.DisableAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.DiskThresholdDecider;
import org.elasticsearch.cluster.routing.allocation.decider.EnableAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.FilterAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.NodeVersionAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.RebalanceOnlyWhenActiveAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ReplicaAfterPrimaryActiveAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.SameShardAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ShardsLimitAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.SnapshotInProgressAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ThrottlingAllocationDecider;
import org.elasticsearch.cluster.service.InternalClusterService;
import org.elasticsearch.cluster.settings.ClusterDynamicSettings;
import org.elasticsearch.cluster.settings.DynamicSettings;
import org.elasticsearch.cluster.settings.Validator;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.ExtensionPoint;
import org.elasticsearch.discovery.zen.elect.ElectMasterService;
import org.elasticsearch.gateway.GatewayAllocator;
import org.elasticsearch.index.settings.IndexDynamicSettings;
import org.elasticsearch.threadpool.ThreadPool;

public class ClusterModule
extends AbstractModule {
    public static final String EVEN_SHARD_COUNT_ALLOCATOR = "even_shard";
    public static final String BALANCED_ALLOCATOR = "balanced";
    public static final String SHARDS_ALLOCATOR_TYPE_KEY = "cluster.routing.allocation.type";
    public static final List<Class<? extends AllocationDecider>> DEFAULT_ALLOCATION_DECIDERS = Collections.unmodifiableList(Arrays.asList(SameShardAllocationDecider.class, FilterAllocationDecider.class, ReplicaAfterPrimaryActiveAllocationDecider.class, ThrottlingAllocationDecider.class, RebalanceOnlyWhenActiveAllocationDecider.class, ClusterRebalanceAllocationDecider.class, ConcurrentRebalanceAllocationDecider.class, EnableAllocationDecider.class, DisableAllocationDecider.class, AwarenessAllocationDecider.class, ShardsLimitAllocationDecider.class, NodeVersionAllocationDecider.class, DiskThresholdDecider.class, SnapshotInProgressAllocationDecider.class));
    private final Settings settings;
    private final DynamicSettings.Builder clusterDynamicSettings = new DynamicSettings.Builder();
    private final DynamicSettings.Builder indexDynamicSettings = new DynamicSettings.Builder();
    private final ExtensionPoint.SelectedType<ShardsAllocator> shardsAllocators = new ExtensionPoint.SelectedType<ShardsAllocator>("shards_allocator", ShardsAllocator.class);
    private final ExtensionPoint.ClassSet<AllocationDecider> allocationDeciders = new ExtensionPoint.ClassSet<AllocationDecider>("allocation_decider", AllocationDecider.class, (Class<?>[])new Class[]{AllocationDeciders.class});
    private final ExtensionPoint.ClassSet<IndexTemplateFilter> indexTemplateFilters = new ExtensionPoint.ClassSet<IndexTemplateFilter>("index_template_filter", IndexTemplateFilter.class, (Class<?>[])new Class[0]);
    Class<? extends ClusterInfoService> clusterInfoServiceImpl = InternalClusterInfoService.class;

    public ClusterModule(Settings settings) {
        this.settings = settings;
        this.registerBuiltinClusterSettings();
        this.registerBuiltinIndexSettings();
        for (Class<? extends AllocationDecider> decider : DEFAULT_ALLOCATION_DECIDERS) {
            this.registerAllocationDecider(decider);
        }
        this.registerShardsAllocator(BALANCED_ALLOCATOR, BalancedShardsAllocator.class);
        this.registerShardsAllocator(EVEN_SHARD_COUNT_ALLOCATOR, BalancedShardsAllocator.class);
    }

    private void registerBuiltinClusterSettings() {
        this.registerClusterDynamicSetting("cluster.routing.allocation.awareness.attributes", Validator.EMPTY);
        this.registerClusterDynamicSetting("cluster.routing.allocation.awareness.force.*", Validator.EMPTY);
        this.registerClusterDynamicSetting("cluster.routing.allocation.balance.index", Validator.FLOAT);
        this.registerClusterDynamicSetting("cluster.routing.allocation.balance.shard", Validator.FLOAT);
        this.registerClusterDynamicSetting("cluster.routing.allocation.balance.threshold", Validator.NON_NEGATIVE_FLOAT);
        this.registerClusterDynamicSetting("cluster.routing.allocation.allow_rebalance", ClusterRebalanceAllocationDecider.ALLOCATION_ALLOW_REBALANCE_VALIDATOR);
        this.registerClusterDynamicSetting("cluster.routing.allocation.cluster_concurrent_rebalance", Validator.INTEGER);
        this.registerClusterDynamicSetting("cluster.routing.allocation.enable", Validator.EMPTY);
        this.registerClusterDynamicSetting("cluster.routing.rebalance.enable", Validator.EMPTY);
        this.registerClusterDynamicSetting("cluster.routing.allocation.disable_new_allocation", Validator.EMPTY);
        this.registerClusterDynamicSetting("cluster.routing.allocation.disable_allocation", Validator.EMPTY);
        this.registerClusterDynamicSetting("cluster.routing.allocation.disable_replica_allocation", Validator.EMPTY);
        this.registerClusterDynamicSetting("discovery.zen.no_master_block", Validator.EMPTY);
        this.registerClusterDynamicSetting("cluster.routing.allocation.include.*", Validator.EMPTY);
        this.registerClusterDynamicSetting("cluster.routing.allocation.exclude.*", Validator.EMPTY);
        this.registerClusterDynamicSetting("cluster.routing.allocation.require.*", Validator.EMPTY);
        this.registerClusterDynamicSetting("indices.store.throttle.type", Validator.EMPTY);
        this.registerClusterDynamicSetting("indices.store.throttle.max_bytes_per_sec", Validator.BYTES_SIZE);
        this.registerClusterDynamicSetting("indices.ttl.interval", Validator.TIME);
        this.registerClusterDynamicSetting("indices.mapping.dynamic_timeout", Validator.TIME);
        this.registerClusterDynamicSetting("cluster.blocks.read_only", Validator.EMPTY);
        this.registerClusterDynamicSetting("indices.recovery.file_chunk_size", Validator.POSITIVE_BYTES_SIZE);
        this.registerClusterDynamicSetting("indices.recovery.translog_ops", Validator.INTEGER);
        this.registerClusterDynamicSetting("indices.recovery.translog_size", Validator.BYTES_SIZE);
        this.registerClusterDynamicSetting("indices.recovery.compress", Validator.EMPTY);
        this.registerClusterDynamicSetting("indices.recovery.concurrent_streams", Validator.POSITIVE_INTEGER);
        this.registerClusterDynamicSetting("indices.recovery.concurrent_small_file_streams", Validator.POSITIVE_INTEGER);
        this.registerClusterDynamicSetting("indices.recovery.max_bytes_per_sec", Validator.BYTES_SIZE);
        this.registerClusterDynamicSetting("indices.recovery.retry_delay_state_sync", Validator.TIME_NON_NEGATIVE);
        this.registerClusterDynamicSetting("indices.recovery.retry_delay_network", Validator.TIME_NON_NEGATIVE);
        this.registerClusterDynamicSetting("indices.recovery.recovery_activity_timeout", Validator.TIME_NON_NEGATIVE);
        this.registerClusterDynamicSetting("indices.recovery.internal_action_timeout", Validator.TIME_NON_NEGATIVE);
        this.registerClusterDynamicSetting("indices.recovery.internal_action_long_timeout", Validator.TIME_NON_NEGATIVE);
        this.registerClusterDynamicSetting("indices.recovery.max_size_per_sec", Validator.BYTES_SIZE);
        this.registerClusterDynamicSetting("threadpool.*", ThreadPool.THREAD_POOL_TYPE_SETTINGS_VALIDATOR);
        this.registerClusterDynamicSetting("cluster.routing.allocation.node_initial_primaries_recoveries", Validator.INTEGER);
        this.registerClusterDynamicSetting("cluster.routing.allocation.node_concurrent_recoveries", Validator.INTEGER);
        this.registerClusterDynamicSetting("cluster.routing.allocation.disk.watermark.low", Validator.EMPTY);
        this.registerClusterDynamicSetting("cluster.routing.allocation.disk.watermark.high", Validator.EMPTY);
        this.registerClusterDynamicSetting("cluster.routing.allocation.disk.threshold_enabled", Validator.BOOLEAN);
        this.registerClusterDynamicSetting("cluster.routing.allocation.disk.include_relocations", Validator.BOOLEAN);
        this.registerClusterDynamicSetting("cluster.routing.allocation.disk.reroute_interval", Validator.TIME_NON_NEGATIVE);
        this.registerClusterDynamicSetting("cluster.info.update.interval", Validator.TIME_NON_NEGATIVE);
        this.registerClusterDynamicSetting("cluster.info.update.timeout", Validator.TIME_NON_NEGATIVE);
        this.registerClusterDynamicSetting("cluster.routing.allocation.snapshot.relocation_enabled", Validator.EMPTY);
        this.registerClusterDynamicSetting("action.destructive_requires_name", Validator.EMPTY);
        this.registerClusterDynamicSetting("discovery.zen.publish_timeout", Validator.TIME_NON_NEGATIVE);
        this.registerClusterDynamicSetting("discovery.zen.publish_diff.enable", Validator.BOOLEAN);
        this.registerClusterDynamicSetting("indices.breaker.total.limit", Validator.MEMORY_SIZE);
        this.registerClusterDynamicSetting("indices.breaker.fielddata.limit", Validator.MEMORY_SIZE);
        this.registerClusterDynamicSetting("indices.breaker.fielddata.overhead", Validator.NON_NEGATIVE_DOUBLE);
        this.registerClusterDynamicSetting("indices.breaker.request.limit", Validator.MEMORY_SIZE);
        this.registerClusterDynamicSetting("indices.breaker.request.overhead", Validator.NON_NEGATIVE_DOUBLE);
        this.registerClusterDynamicSetting("cluster.service.slow_task_logging_threshold", Validator.TIME_NON_NEGATIVE);
        this.registerClusterDynamicSetting("search.default_search_timeout", Validator.TIMEOUT);
        this.registerClusterDynamicSetting("discovery.zen.minimum_master_nodes", ElectMasterService.DISCOVERY_ZEN_MINIMUM_MASTER_NODES_VALIDATOR);
        this.registerClusterDynamicSetting("transport.tracer.include", Validator.EMPTY);
        this.registerClusterDynamicSetting("transport.tracer.include.*", Validator.EMPTY);
        this.registerClusterDynamicSetting("transport.tracer.exclude", Validator.EMPTY);
        this.registerClusterDynamicSetting("transport.tracer.exclude.*", Validator.EMPTY);
        this.registerClusterDynamicSetting("cluster.indices.close.enable", Validator.BOOLEAN);
        this.registerClusterDynamicSetting("cluster.routing.allocation.total_shards_per_node", Validator.INTEGER);
    }

    private void registerBuiltinIndexSettings() {
        this.registerIndexDynamicSetting("index.store.throttle.max_bytes_per_sec", Validator.BYTES_SIZE);
        this.registerIndexDynamicSetting("index.store.throttle.type", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.merge.scheduler.max_thread_count", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.merge.scheduler.max_merge_count", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.merge.scheduler.auto_throttle", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.routing.allocation.require.*", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.routing.allocation.include.*", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.routing.allocation.exclude.*", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.routing.allocation.enable", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.routing.rebalance.enable", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.routing.allocation.disable_allocation", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.routing.allocation.disable_new_allocation", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.routing.allocation.disable_replica_allocation", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.translog.fs.type", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.number_of_replicas", Validator.NON_NEGATIVE_INTEGER);
        this.registerIndexDynamicSetting("index.auto_expand_replicas", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.blocks.read_only", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.blocks.read", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.blocks.write", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.blocks.metadata", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.shared_filesystem.recover_on_any_node", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.priority", Validator.NON_NEGATIVE_INTEGER);
        this.registerIndexDynamicSetting("index.ttl.disable_purge", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.refresh_interval", Validator.TIME);
        this.registerIndexDynamicSetting("index.recovery.initial_shards", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.compound_on_flush", Validator.BOOLEAN);
        this.registerIndexDynamicSetting("index.gc_deletes", Validator.TIME);
        this.registerIndexDynamicSetting("index.flush_on_close", Validator.BOOLEAN);
        this.registerIndexDynamicSetting("index.version_map_size", Validator.BYTES_SIZE_OR_PERCENTAGE);
        this.registerIndexDynamicSetting("index.indexing.slowlog.threshold.index.warn", Validator.TIME);
        this.registerIndexDynamicSetting("index.indexing.slowlog.threshold.index.info", Validator.TIME);
        this.registerIndexDynamicSetting("index.indexing.slowlog.threshold.index.debug", Validator.TIME);
        this.registerIndexDynamicSetting("index.indexing.slowlog.threshold.index.trace", Validator.TIME);
        this.registerIndexDynamicSetting("index.indexing.slowlog.reformat", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.indexing.slowlog.level", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.indexing.slowlog.source", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.search.slowlog.threshold.query.warn", Validator.TIME);
        this.registerIndexDynamicSetting("index.search.slowlog.threshold.query.info", Validator.TIME);
        this.registerIndexDynamicSetting("index.search.slowlog.threshold.query.debug", Validator.TIME);
        this.registerIndexDynamicSetting("index.search.slowlog.threshold.query.trace", Validator.TIME);
        this.registerIndexDynamicSetting("index.search.slowlog.threshold.fetch.warn", Validator.TIME);
        this.registerIndexDynamicSetting("index.search.slowlog.threshold.fetch.info", Validator.TIME);
        this.registerIndexDynamicSetting("index.search.slowlog.threshold.fetch.debug", Validator.TIME);
        this.registerIndexDynamicSetting("index.search.slowlog.threshold.fetch.trace", Validator.TIME);
        this.registerIndexDynamicSetting("index.search.slowlog.reformat", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.search.slowlog.level", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.routing.allocation.total_shards_per_node", Validator.INTEGER);
        this.registerIndexDynamicSetting("index.merge.policy.expunge_deletes_allowed", Validator.DOUBLE);
        this.registerIndexDynamicSetting("index.merge.policy.floor_segment", Validator.BYTES_SIZE);
        this.registerIndexDynamicSetting("index.merge.policy.max_merge_at_once", Validator.INTEGER_GTE_2);
        this.registerIndexDynamicSetting("index.merge.policy.max_merge_at_once_explicit", Validator.INTEGER_GTE_2);
        this.registerIndexDynamicSetting("index.merge.policy.max_merged_segment", Validator.BYTES_SIZE);
        this.registerIndexDynamicSetting("index.merge.policy.segments_per_tier", Validator.DOUBLE_GTE_2);
        this.registerIndexDynamicSetting("index.merge.policy.reclaim_deletes_weight", Validator.NON_NEGATIVE_DOUBLE);
        this.registerIndexDynamicSetting("index.compound_format", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.translog.interval", Validator.TIME);
        this.registerIndexDynamicSetting("index.translog.flush_threshold_ops", Validator.INTEGER);
        this.registerIndexDynamicSetting("index.translog.flush_threshold_size", Validator.BYTES_SIZE);
        this.registerIndexDynamicSetting("index.translog.flush_threshold_period", Validator.TIME);
        this.registerIndexDynamicSetting("index.translog.disable_flush", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.translog.durability", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.warmer.enabled", Validator.EMPTY);
        this.registerIndexDynamicSetting("index.requests.cache.enable", Validator.BOOLEAN);
        this.registerIndexDynamicSetting("index.cache.query.enable", Validator.BOOLEAN);
        this.registerIndexDynamicSetting("index.unassigned.node_left.delayed_timeout", Validator.TIME);
        this.registerIndexDynamicSetting("index.max_result_window", Validator.POSITIVE_INTEGER);
        this.registerIndexDynamicSetting("index.mapping.nested_fields.limit", Validator.NON_NEGATIVE_INTEGER);
    }

    public void registerIndexDynamicSetting(String setting, Validator validator) {
        this.indexDynamicSettings.addSetting(setting, validator);
    }

    public void registerClusterDynamicSetting(String setting, Validator validator) {
        this.clusterDynamicSettings.addSetting(setting, validator);
    }

    public void registerAllocationDecider(Class<? extends AllocationDecider> allocationDecider) {
        this.allocationDeciders.registerExtension(allocationDecider);
    }

    public void registerShardsAllocator(String name, Class<? extends ShardsAllocator> clazz) {
        this.shardsAllocators.registerExtension(name, clazz);
    }

    public void registerIndexTemplateFilter(Class<? extends IndexTemplateFilter> indexTemplateFilter) {
        this.indexTemplateFilters.registerExtension(indexTemplateFilter);
    }

    @Override
    protected void configure() {
        this.bind(DynamicSettings.class).annotatedWith(ClusterDynamicSettings.class).toInstance(this.clusterDynamicSettings.build());
        this.bind(DynamicSettings.class).annotatedWith(IndexDynamicSettings.class).toInstance(this.indexDynamicSettings.build());
        String shardsAllocatorType = this.shardsAllocators.bindType(this.binder(), this.settings, SHARDS_ALLOCATOR_TYPE_KEY, BALANCED_ALLOCATOR);
        if (shardsAllocatorType.equals(EVEN_SHARD_COUNT_ALLOCATOR)) {
            ESLogger logger = Loggers.getLogger(this.getClass(), this.settings, new String[0]);
            logger.warn("{} allocator has been removed in 2.0 using {} instead", EVEN_SHARD_COUNT_ALLOCATOR, BALANCED_ALLOCATOR);
        }
        this.allocationDeciders.bind(this.binder());
        this.indexTemplateFilters.bind(this.binder());
        this.bind(ClusterInfoService.class).to(this.clusterInfoServiceImpl).asEagerSingleton();
        this.bind(GatewayAllocator.class).asEagerSingleton();
        this.bind(AllocationService.class).asEagerSingleton();
        this.bind(DiscoveryNodeService.class).asEagerSingleton();
        this.bind(ClusterService.class).to(InternalClusterService.class).asEagerSingleton();
        this.bind(OperationRouting.class).asEagerSingleton();
        this.bind(MetaDataCreateIndexService.class).asEagerSingleton();
        this.bind(MetaDataDeleteIndexService.class).asEagerSingleton();
        this.bind(MetaDataIndexStateService.class).asEagerSingleton();
        this.bind(MetaDataMappingService.class).asEagerSingleton();
        this.bind(MetaDataIndexAliasesService.class).asEagerSingleton();
        this.bind(MetaDataUpdateSettingsService.class).asEagerSingleton();
        this.bind(MetaDataIndexTemplateService.class).asEagerSingleton();
        this.bind(IndexNameExpressionResolver.class).asEagerSingleton();
        this.bind(RoutingService.class).asEagerSingleton();
        this.bind(ShardStateAction.class).asEagerSingleton();
        this.bind(NodeIndexDeletedAction.class).asEagerSingleton();
        this.bind(NodeMappingRefreshAction.class).asEagerSingleton();
        this.bind(MappingUpdatedAction.class).asEagerSingleton();
    }
}

