/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.google.common.collect.ImmutableSet;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.MetaDataIndexUpgradeService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.MultiDataPathUpgrader;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.DanglingIndicesState;
import org.elasticsearch.gateway.MetaStateService;
import org.elasticsearch.gateway.TransportNodesListGatewayMetaState;

public class GatewayMetaState
extends AbstractComponent
implements ClusterStateListener {
    private final NodeEnvironment nodeEnv;
    private final MetaStateService metaStateService;
    private final DanglingIndicesState danglingIndicesState;
    private final MetaDataIndexUpgradeService metaDataIndexUpgradeService;
    @Nullable
    private volatile MetaData previousMetaData;
    private volatile ImmutableSet<String> previouslyWrittenIndices = ImmutableSet.of();

    @Inject
    public GatewayMetaState(Settings settings, NodeEnvironment nodeEnv, MetaStateService metaStateService, DanglingIndicesState danglingIndicesState, TransportNodesListGatewayMetaState nodesListGatewayMetaState, MetaDataIndexUpgradeService metaDataIndexUpgradeService) throws Exception {
        super(settings);
        this.nodeEnv = nodeEnv;
        this.metaStateService = metaStateService;
        this.danglingIndicesState = danglingIndicesState;
        this.metaDataIndexUpgradeService = metaDataIndexUpgradeService;
        nodesListGatewayMetaState.init(this);
        if (DiscoveryNode.dataNode(settings)) {
            this.ensureNoPre019ShardState(nodeEnv);
            MultiDataPathUpgrader.upgradeMultiDataPath(nodeEnv, this.logger);
        }
        if (DiscoveryNode.masterNode(settings) || DiscoveryNode.dataNode(settings)) {
            nodeEnv.ensureAtomicMoveSupported();
        }
        if (DiscoveryNode.masterNode(settings) || DiscoveryNode.dataNode(settings)) {
            try {
                this.ensureNoPre019State();
                this.pre20Upgrade();
                long startNS = System.nanoTime();
                metaStateService.loadFullState();
                this.logger.debug("took {} to load state", TimeValue.timeValueMillis(TimeValue.nsecToMSec(System.nanoTime() - startNS)));
            }
            catch (Exception e) {
                this.logger.error("failed to read local state, exiting...", e, new Object[0]);
                throw e;
            }
        }
    }

    public MetaData loadMetaState() throws Exception {
        return this.metaStateService.loadFullState();
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        HashSet<String> relevantIndices = new HashSet();
        ClusterState state = event.state();
        if (state.blocks().disableStatePersistence()) {
            this.previousMetaData = null;
            this.previouslyWrittenIndices = ImmutableSet.of();
            return;
        }
        MetaData newMetaData = state.metaData();
        boolean success = true;
        if (state.nodes().localNode().masterNode() || state.nodes().localNode().dataNode()) {
            if (this.previousMetaData == null) {
                try {
                    if (GatewayMetaState.isDataOnlyNode(state)) {
                        ImmutableSet.Builder previouslyWrittenIndicesBuilder = ImmutableSet.builder();
                        for (IndexMetaData indexMetaData : newMetaData) {
                            IndexMetaData indexMetaDataOnDisk = null;
                            if (indexMetaData.getState().equals((Object)IndexMetaData.State.CLOSE)) {
                                indexMetaDataOnDisk = this.metaStateService.loadIndexState(indexMetaData.getIndex());
                            }
                            if (indexMetaDataOnDisk == null) continue;
                            previouslyWrittenIndicesBuilder.add((Object)indexMetaDataOnDisk.getIndex());
                        }
                        this.previouslyWrittenIndices = previouslyWrittenIndicesBuilder.addAll(this.previouslyWrittenIndices).build();
                    }
                }
                catch (Throwable e) {
                    success = false;
                }
            }
            if (this.previousMetaData == null || !MetaData.isGlobalStateEquals(this.previousMetaData, newMetaData)) {
                try {
                    this.metaStateService.writeGlobalState("changed", newMetaData);
                }
                catch (Throwable e) {
                    success = false;
                }
            }
            relevantIndices = GatewayMetaState.getRelevantIndices(event.state(), event.previousState(), this.previouslyWrittenIndices);
            Iterable<IndexMetaWriteInfo> writeInfo = GatewayMetaState.resolveStatesToBeWritten(this.previouslyWrittenIndices, relevantIndices, this.previousMetaData, event.state().metaData());
            for (IndexMetaWriteInfo indexMetaWrite : writeInfo) {
                try {
                    this.metaStateService.writeIndex(indexMetaWrite.reason, indexMetaWrite.newMetaData, indexMetaWrite.previousMetaData);
                }
                catch (Throwable e) {
                    success = false;
                }
            }
        }
        this.danglingIndicesState.processDanglingIndices(newMetaData);
        if (success) {
            this.previousMetaData = newMetaData;
            ImmutableSet.Builder builder = ImmutableSet.builder();
            this.previouslyWrittenIndices = builder.addAll(relevantIndices).build();
        }
    }

    public static Set<String> getRelevantIndices(ClusterState state, ClusterState previousState, ImmutableSet<String> previouslyWrittenIndices) {
        Set<String> relevantIndices = GatewayMetaState.isDataOnlyNode(state) ? GatewayMetaState.getRelevantIndicesOnDataOnlyNode(state, previousState, previouslyWrittenIndices) : (state.nodes().localNode().masterNode() ? GatewayMetaState.getRelevantIndicesForMasterEligibleNode(state) : Collections.emptySet());
        return relevantIndices;
    }

    protected static boolean isDataOnlyNode(ClusterState state) {
        return !state.nodes().localNode().masterNode() && state.nodes().localNode().dataNode();
    }

    private void ensureNoPre019State() throws Exception {
        for (Path dataLocation : this.nodeEnv.nodeDataPaths()) {
            Path stateLocation = dataLocation.resolve("_state");
            if (!Files.exists(stateLocation, new LinkOption[0])) continue;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(stateLocation);){
                for (Path stateFile : stream) {
                    String name;
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("[upgrade]: processing [" + stateFile.getFileName() + "]", new Object[0]);
                    }
                    if (!(name = stateFile.getFileName().toString()).startsWith("metadata-")) continue;
                    throw new IllegalStateException("Detected pre 0.19 metadata file please upgrade to a version before " + Version.CURRENT.minimumCompatibilityVersion() + " first to upgrade state structures - metadata found: [" + stateFile.getParent().toAbsolutePath());
                }
            }
        }
    }

    private void pre20Upgrade() throws Exception {
        MetaData metaData = this.loadMetaState();
        ArrayList<IndexMetaData> updateIndexMetaData = new ArrayList<IndexMetaData>();
        for (IndexMetaData indexMetaData : metaData) {
            IndexMetaData newMetaData;
            if (indexMetaData == (newMetaData = this.metaDataIndexUpgradeService.upgradeIndexMetaData(indexMetaData))) continue;
            updateIndexMetaData.add(newMetaData);
        }
        for (IndexMetaData indexMetaData : updateIndexMetaData) {
            this.metaStateService.writeIndex("upgrade", indexMetaData, null);
        }
    }

    private void ensureNoPre019ShardState(NodeEnvironment nodeEnv) throws Exception {
        for (Path dataLocation : nodeEnv.nodeDataPaths()) {
            Path stateLocation = dataLocation.resolve("_state");
            if (!Files.exists(stateLocation, new LinkOption[0])) continue;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(stateLocation, "shards-*");){
                Iterator<Path> iterator = stream.iterator();
                if (!iterator.hasNext()) continue;
                Path stateFile = iterator.next();
                throw new IllegalStateException("Detected pre 0.19 shard state file please upgrade to a version before " + Version.CURRENT.minimumCompatibilityVersion() + " first to upgrade state structures - shard state found: [" + stateFile.getParent().toAbsolutePath());
            }
        }
    }

    public static Iterable<IndexMetaWriteInfo> resolveStatesToBeWritten(ImmutableSet<String> previouslyWrittenIndices, Set<String> potentiallyUnwrittenIndices, MetaData previousMetaData, MetaData newMetaData) {
        ArrayList<IndexMetaWriteInfo> indicesToWrite = new ArrayList<IndexMetaWriteInfo>();
        for (String index : potentiallyUnwrittenIndices) {
            IndexMetaData newIndexMetaData = newMetaData.index(index);
            IndexMetaData previousIndexMetaData = previousMetaData == null ? null : previousMetaData.index(index);
            String writeReason = null;
            if (!previouslyWrittenIndices.contains((Object)index) || previousIndexMetaData == null) {
                writeReason = "freshly created";
            } else if (previousIndexMetaData.getVersion() != newIndexMetaData.getVersion()) {
                writeReason = "version changed from [" + previousIndexMetaData.getVersion() + "] to [" + newIndexMetaData.getVersion() + "]";
            }
            if (writeReason == null) continue;
            indicesToWrite.add(new IndexMetaWriteInfo(newIndexMetaData, previousIndexMetaData, writeReason));
        }
        return indicesToWrite;
    }

    public static Set<String> getRelevantIndicesOnDataOnlyNode(ClusterState state, ClusterState previousState, ImmutableSet<String> previouslyWrittenIndices) {
        RoutingNode newRoutingNode = state.getRoutingNodes().node(state.nodes().localNodeId());
        if (newRoutingNode == null) {
            throw new IllegalStateException("cluster state does not contain this node - cannot write index meta state");
        }
        HashSet<String> indices = new HashSet<String>();
        for (ShardRouting routing : newRoutingNode) {
            indices.add(routing.index());
        }
        for (IndexMetaData indexMetaData : state.metaData()) {
            boolean isOrWasClosed = indexMetaData.getState().equals((Object)IndexMetaData.State.CLOSE);
            IndexMetaData previousMetaData = previousState.metaData().getIndices().get(indexMetaData.getIndex());
            if (previousMetaData != null) {
                boolean bl = isOrWasClosed = isOrWasClosed || previousMetaData.getState().equals((Object)IndexMetaData.State.CLOSE);
            }
            if (!previouslyWrittenIndices.contains((Object)indexMetaData.getIndex()) || !isOrWasClosed) continue;
            indices.add(indexMetaData.getIndex());
        }
        return indices;
    }

    public static Set<String> getRelevantIndicesForMasterEligibleNode(ClusterState state) {
        HashSet<String> relevantIndices = new HashSet<String>();
        for (IndexMetaData indexMetaData : state.metaData()) {
            relevantIndices.add(indexMetaData.getIndex());
        }
        return relevantIndices;
    }

    public static class IndexMetaWriteInfo {
        final IndexMetaData newMetaData;
        final String reason;
        final IndexMetaData previousMetaData;

        public IndexMetaWriteInfo(IndexMetaData newMetaData, IndexMetaData previousMetaData, String reason) {
            this.newMetaData = newMetaData;
            this.reason = reason;
            this.previousMetaData = previousMetaData;
        }

        public IndexMetaData getNewMetaData() {
            return this.newMetaData;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

