/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.breaker;

import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.HierarchyCircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;

public class CircuitBreakerModule
extends AbstractModule {
    public static final String TYPE_KEY = "indices.breaker.type";
    private final Settings settings;

    public CircuitBreakerModule(Settings settings) {
        this.settings = settings;
    }

    @Override
    protected void configure() {
        Class impl;
        String type = this.settings.get(TYPE_KEY);
        if (type == null || type.equals("hierarchy")) {
            impl = HierarchyCircuitBreakerService.class;
        } else if (type.equals("none")) {
            impl = NoneCircuitBreakerService.class;
        } else {
            throw new IllegalArgumentException("Unknown circuit breaker type [" + type + "]");
        }
        this.bind(CircuitBreakerService.class).to(impl).asEagerSingleton();
    }
}

