/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.logging.support.LoggerMessageFormat;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.AbstractScriptParser;
import org.elasticsearch.script.ScriptService;

public class Script
implements ToXContent,
Streamable {
    public static final ScriptService.ScriptType DEFAULT_TYPE = ScriptService.ScriptType.INLINE;
    private static final ScriptParser PARSER = new ScriptParser();
    private String script;
    @Nullable
    private ScriptService.ScriptType type;
    @Nullable
    private String lang;
    @Nullable
    private Map<String, Object> params;

    Script() {
    }

    public Script(String script) {
        this(script, null);
    }

    protected Script(String script, String lang) {
        this(script, ScriptService.ScriptType.INLINE, lang, null);
    }

    public Script(String script, ScriptService.ScriptType type, @Nullable String lang, @Nullable Map<String, ? extends Object> params) {
        if (script == null) {
            throw new IllegalArgumentException("The parameter script (String) must not be null in Script.");
        }
        if (type == null) {
            throw new IllegalArgumentException("The parameter type (ScriptType) must not be null in Script.");
        }
        this.script = script;
        this.type = type;
        this.lang = lang;
        this.params = params;
    }

    public String getScript() {
        return this.script;
    }

    public ScriptService.ScriptType getType() {
        return this.type == null ? DEFAULT_TYPE : this.type;
    }

    public String getLang() {
        return this.lang;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    @Override
    public final void readFrom(StreamInput in) throws IOException {
        this.script = in.readString();
        if (in.readBoolean()) {
            this.type = ScriptService.ScriptType.readFrom(in);
        }
        this.lang = in.readOptionalString();
        if (in.readBoolean()) {
            this.params = in.readMap();
        }
        this.doReadFrom(in);
    }

    protected void doReadFrom(StreamInput in) throws IOException {
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.script);
        boolean hasType = this.type != null;
        out.writeBoolean(hasType);
        if (hasType) {
            ScriptService.ScriptType.writeTo(this.type, out);
        }
        out.writeOptionalString(this.lang);
        boolean hasParams = this.params != null;
        out.writeBoolean(hasParams);
        if (hasParams) {
            out.writeMap(this.params);
        }
        this.doWriteTo(out);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        if (this.type == null) {
            return builder.value(this.script);
        }
        builder.startObject();
        this.scriptFieldToXContent(this.script, this.type, builder, builderParams);
        if (this.lang != null) {
            builder.field(ScriptField.LANG.getPreferredName(), this.lang);
        }
        if (this.params != null) {
            builder.field(ScriptField.PARAMS.getPreferredName(), this.params);
        }
        builder.endObject();
        return builder;
    }

    protected XContentBuilder scriptFieldToXContent(String script, ScriptService.ScriptType type, XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        builder.field(type.getParseField().getPreferredName(), script);
        return builder;
    }

    public static Script readScript(StreamInput in) throws IOException {
        Script script = new Script();
        script.readFrom(in);
        return script;
    }

    public static Script parse(Map<String, Object> config, boolean removeMatchedEntries, ParseFieldMatcher parseFieldMatcher) {
        return PARSER.parse(config, removeMatchedEntries, parseFieldMatcher);
    }

    public static Script parse(XContentParser parser, ParseFieldMatcher parseFieldMatcher) throws IOException {
        return PARSER.parse(parser, parseFieldMatcher);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lang == null ? 0 : this.lang.hashCode());
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        result = 31 * result + (this.script == null ? 0 : this.script.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Script other = (Script)obj;
        if (this.lang == null ? other.lang != null : !this.lang.equals(other.lang)) {
            return false;
        }
        if (this.params == null ? other.params != null : !this.params.equals(other.params)) {
            return false;
        }
        if (this.script == null ? other.script != null : !this.script.equals(other.script)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return "[script: " + this.script + ", type: " + this.type.getParseField().getPreferredName() + ", lang: " + this.lang + ", params: " + this.params + "]";
    }

    public static class ScriptParseException
    extends ElasticsearchException {
        public ScriptParseException(String msg, Object ... args) {
            super(LoggerMessageFormat.format(msg, args), new Object[0]);
        }

        public ScriptParseException(StreamInput in) throws IOException {
            super(in);
        }
    }

    public static interface ScriptField {
        public static final ParseField SCRIPT = new ParseField("script", new String[0]);
        public static final ParseField LANG = new ParseField("lang", new String[0]);
        public static final ParseField PARAMS = new ParseField("params", new String[0]);
    }

    private static class ScriptParser
    extends AbstractScriptParser<Script> {
        private ScriptParser() {
        }

        @Override
        protected Script createSimpleScript(XContentParser parser) throws IOException {
            if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new Script(parser.text());
            }
            throw new ScriptParseException("expected a string value for field [{}], but found [{}]", new Object[]{parser.currentName(), parser.currentToken()});
        }

        @Override
        protected Script createScript(String script, ScriptService.ScriptType type, String lang, Map<String, Object> params) {
            return new Script(script, type, lang, params);
        }

        @Override
        protected String parseInlineScript(XContentParser parser) throws IOException {
            return parser.text();
        }
    }
}

