/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.ExtensionPoint;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.suggest.SuggestParseElement;
import org.elasticsearch.search.suggest.SuggestPhase;
import org.elasticsearch.search.suggest.Suggester;
import org.elasticsearch.search.suggest.completion.CompletionSuggester;
import org.elasticsearch.search.suggest.phrase.PhraseSuggester;
import org.elasticsearch.search.suggest.term.TermSuggester;

public final class Suggesters
extends ExtensionPoint.ClassMap<Suggester> {
    private final Map<String, Suggester> parsers;

    public Suggesters() {
        this(Collections.EMPTY_MAP);
    }

    public Suggesters(Map<String, Suggester> suggesters) {
        super("suggester", Suggester.class, new HashSet<String>(Arrays.asList("phrase", "term", "completion")), Suggesters.class, SuggestParseElement.class, SuggestPhase.class);
        this.parsers = Collections.unmodifiableMap(suggesters);
    }

    @Inject
    public Suggesters(Map<String, Suggester> suggesters, ScriptService scriptService) {
        this(Suggesters.addBuildIns(suggesters, scriptService));
    }

    private static Map<String, Suggester> addBuildIns(Map<String, Suggester> suggesters, ScriptService scriptService) {
        HashMap<String, Suggester> map = new HashMap<String, Suggester>();
        map.put("phrase", new PhraseSuggester(scriptService));
        map.put("term", new TermSuggester());
        map.put("completion", new CompletionSuggester());
        map.putAll(suggesters);
        return map;
    }

    public Suggester get(String type) {
        return this.parsers.get(type);
    }
}

