/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.MetaDataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetaDataIndexUpgradeService;
import org.elasticsearch.cluster.metadata.SnapshotId;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RestoreSource;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.settings.ClusterDynamicSettings;
import org.elasticsearch.cluster.settings.DynamicSettings;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import org.elasticsearch.snapshots.RestoreInfo;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotRestoreException;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotUtils;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class RestoreService
extends AbstractComponent
implements ClusterStateListener {
    public static final String UPDATE_RESTORE_ACTION_NAME = "internal:cluster/snapshot/update_restore";
    private static final ImmutableSet<String> UNMODIFIABLE_SETTINGS = ImmutableSet.of((Object)"index.number_of_shards", (Object)"index.version.created", (Object)"index.legacy.routing.hash.type", (Object)"index.legacy.routing.use_type", (Object)"index.uuid", (Object)"index.creation_date", (Object[])new String[0]);
    private static final ImmutableSet<String> UNREMOVABLE_SETTINGS = ImmutableSet.builder().addAll(UNMODIFIABLE_SETTINGS).add((Object)"index.number_of_replicas").add((Object)"index.auto_expand_replicas").add((Object)"index.version.upgraded").add((Object)"index.version.minimum_compatible").build();
    private final ClusterService clusterService;
    private final RepositoriesService repositoriesService;
    private final TransportService transportService;
    private final AllocationService allocationService;
    private final MetaDataCreateIndexService createIndexService;
    private final DynamicSettings dynamicSettings;
    private final MetaDataIndexUpgradeService metaDataIndexUpgradeService;
    private final CopyOnWriteArrayList<ActionListener<RestoreCompletionResponse>> listeners = new CopyOnWriteArrayList();
    private final BlockingQueue<UpdateIndexShardRestoreStatusRequest> updatedSnapshotStateQueue = ConcurrentCollections.newBlockingQueue();

    @Inject
    public RestoreService(Settings settings, ClusterService clusterService, RepositoriesService repositoriesService, TransportService transportService, AllocationService allocationService, MetaDataCreateIndexService createIndexService, @ClusterDynamicSettings DynamicSettings dynamicSettings, MetaDataIndexUpgradeService metaDataIndexUpgradeService) {
        super(settings);
        this.clusterService = clusterService;
        this.repositoriesService = repositoriesService;
        this.transportService = transportService;
        this.allocationService = allocationService;
        this.createIndexService = createIndexService;
        this.dynamicSettings = dynamicSettings;
        this.metaDataIndexUpgradeService = metaDataIndexUpgradeService;
        transportService.registerRequestHandler(UPDATE_RESTORE_ACTION_NAME, UpdateIndexShardRestoreStatusRequest.class, "same", new UpdateRestoreStateRequestHandler());
        clusterService.add(this);
    }

    public void restoreSnapshot(final RestoreRequest request, final ActionListener<RestoreInfo> listener) {
        try {
            Repository repository = this.repositoriesService.repository(request.repository());
            final SnapshotId snapshotId = new SnapshotId(request.repository(), request.name());
            final Snapshot snapshot = repository.readSnapshot(snapshotId);
            List<String> filteredIndices = SnapshotUtils.filterIndices(snapshot.indices(), request.indices(), request.indicesOptions());
            MetaData metaDataIn = repository.readSnapshotMetaData(snapshotId, snapshot, filteredIndices);
            final MetaData metaData = snapshot.version().before(Version.V_2_0_0_beta1) ? MetaData.addDefaultUnitsIfNeeded(this.logger, metaDataIn) : metaDataIn;
            this.validateSnapshotRestorable(snapshotId, snapshot);
            final Map<String, String> renamedIndices = this.renamedIndices(request, filteredIndices);
            this.clusterService.submitStateUpdateTask(request.cause(), new ClusterStateUpdateTask(){
                RestoreInfo restoreInfo = null;

                @Override
                public ClusterState execute(ClusterState currentState) {
                    ImmutableMap shards;
                    RestoreInProgress restoreInProgress = (RestoreInProgress)currentState.custom("restore");
                    if (restoreInProgress != null && !restoreInProgress.entries().isEmpty()) {
                        throw new ConcurrentSnapshotExecutionException(snapshotId, "Restore process is already running in this cluster");
                    }
                    ClusterState.Builder builder = ClusterState.builder(currentState);
                    MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
                    ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                    RoutingTable.Builder rtBuilder = RoutingTable.builder(currentState.routingTable());
                    HashSet aliases = Sets.newHashSet();
                    if (!renamedIndices.isEmpty()) {
                        ImmutableMap.Builder shardsBuilder = ImmutableMap.builder();
                        for (Map.Entry indexEntry : renamedIndices.entrySet()) {
                            Object updatedIndexMetaData;
                            IndexMetaData.Builder indexMdBuilder;
                            String index = (String)indexEntry.getValue();
                            boolean partial = this.checkPartial(index);
                            RestoreSource restoreSource = new RestoreSource(snapshotId, snapshot.version(), index);
                            String renamedIndex = (String)indexEntry.getKey();
                            IndexMetaData snapshotIndexMetaData = metaData.index(index);
                            snapshotIndexMetaData = this.updateIndexSettings(snapshotIndexMetaData, request.indexSettings, request.ignoreIndexSettings);
                            try {
                                snapshotIndexMetaData = RestoreService.this.metaDataIndexUpgradeService.upgradeIndexMetaData(snapshotIndexMetaData);
                            }
                            catch (Exception ex) {
                                throw new SnapshotRestoreException(snapshotId, "cannot restore index [" + index + "] because it cannot be upgraded", ex);
                            }
                            IndexMetaData currentIndexMetaData = currentState.metaData().index(renamedIndex);
                            IntHashSet ignoreShards = new IntHashSet();
                            if (currentIndexMetaData == null) {
                                RestoreService.this.createIndexService.validateIndexName(renamedIndex, currentState);
                                RestoreService.this.createIndexService.validateIndexSettings(renamedIndex, snapshotIndexMetaData.getSettings());
                                indexMdBuilder = IndexMetaData.builder(snapshotIndexMetaData).state(IndexMetaData.State.OPEN).index(renamedIndex);
                                indexMdBuilder.settings(Settings.settingsBuilder().put(snapshotIndexMetaData.getSettings()).put("index.uuid", Strings.randomBase64UUID()));
                                if (!request.includeAliases() && !snapshotIndexMetaData.getAliases().isEmpty()) {
                                    indexMdBuilder.removeAllAliases();
                                } else {
                                    for (ObjectCursor alias : snapshotIndexMetaData.getAliases().keys()) {
                                        aliases.add(alias.value);
                                    }
                                }
                                updatedIndexMetaData = indexMdBuilder.build();
                                if (partial) {
                                    this.populateIgnoredShards(index, (IntSet)ignoreShards);
                                }
                                rtBuilder.addAsNewRestore((IndexMetaData)updatedIndexMetaData, restoreSource, (IntSet)ignoreShards);
                                blocks.addBlocks((IndexMetaData)updatedIndexMetaData);
                                mdBuilder.put((IndexMetaData)updatedIndexMetaData, true);
                            } else {
                                this.validateExistingIndex(currentIndexMetaData, snapshotIndexMetaData, renamedIndex, partial);
                                indexMdBuilder = IndexMetaData.builder(snapshotIndexMetaData).state(IndexMetaData.State.OPEN);
                                indexMdBuilder.version(Math.max(snapshotIndexMetaData.getVersion(), currentIndexMetaData.getVersion() + 1L));
                                if (!request.includeAliases()) {
                                    if (!snapshotIndexMetaData.getAliases().isEmpty()) {
                                        indexMdBuilder.removeAllAliases();
                                    }
                                    for (ObjectCursor alias : currentIndexMetaData.getAliases().values()) {
                                        indexMdBuilder.putAlias((AliasMetaData)alias.value);
                                    }
                                } else {
                                    for (ObjectCursor alias : snapshotIndexMetaData.getAliases().keys()) {
                                        aliases.add(alias.value);
                                    }
                                }
                                indexMdBuilder.settings(Settings.settingsBuilder().put(snapshotIndexMetaData.getSettings()).put("index.uuid", currentIndexMetaData.getIndexUUID()));
                                updatedIndexMetaData = indexMdBuilder.index(renamedIndex).build();
                                rtBuilder.addAsRestore((IndexMetaData)updatedIndexMetaData, restoreSource);
                                blocks.updateBlocks((IndexMetaData)updatedIndexMetaData);
                                mdBuilder.put((IndexMetaData)updatedIndexMetaData, true);
                            }
                            for (int shard = 0; shard < snapshotIndexMetaData.getNumberOfShards(); ++shard) {
                                if (!ignoreShards.contains(shard)) {
                                    shardsBuilder.put((Object)new ShardId(renamedIndex, shard), (Object)new RestoreInProgress.ShardRestoreStatus(RestoreService.this.clusterService.state().nodes().localNodeId()));
                                    continue;
                                }
                                shardsBuilder.put((Object)new ShardId(renamedIndex, shard), (Object)new RestoreInProgress.ShardRestoreStatus(RestoreService.this.clusterService.state().nodes().localNodeId(), RestoreInProgress.State.FAILURE));
                            }
                        }
                        shards = shardsBuilder.build();
                        RestoreInProgress.Entry restoreEntry = new RestoreInProgress.Entry(snapshotId, RestoreInProgress.State.INIT, Collections.unmodifiableList(new ArrayList(renamedIndices.keySet())), (ImmutableMap<ShardId, RestoreInProgress.ShardRestoreStatus>)shards);
                        builder.putCustom("restore", new RestoreInProgress(restoreEntry));
                    } else {
                        shards = ImmutableMap.of();
                    }
                    this.checkAliasNameConflicts(renamedIndices, aliases);
                    this.restoreGlobalStateIfRequested(mdBuilder);
                    if (RestoreService.this.completed((Map)shards)) {
                        this.restoreInfo = new RestoreInfo(request.name(), Collections.unmodifiableList(new ArrayList(renamedIndices.keySet())), shards.size(), shards.size() - RestoreService.this.failedShards((Map)shards));
                    }
                    RoutingTable rt = rtBuilder.build();
                    ClusterState updatedState = builder.metaData(mdBuilder).blocks(blocks).routingTable(rt).build();
                    RoutingAllocation.Result routingResult = RestoreService.this.allocationService.reroute(ClusterState.builder(updatedState).routingTable(rt).build(), "restored snapshot [" + snapshotId + "]");
                    return ClusterState.builder(updatedState).routingResult(routingResult).build();
                }

                private void checkAliasNameConflicts(Map<String, String> renamedIndices2, Set<String> aliases) {
                    for (Map.Entry<String, String> renamedIndex : renamedIndices2.entrySet()) {
                        if (!aliases.contains(renamedIndex.getKey())) continue;
                        throw new SnapshotRestoreException(snapshotId, "cannot rename index [" + renamedIndex.getValue() + "] into [" + renamedIndex.getKey() + "] because of conflict with an alias with the same name");
                    }
                }

                private void populateIgnoredShards(String index, IntSet ignoreShards) {
                    for (SnapshotShardFailure failure : snapshot.shardFailures()) {
                        if (!index.equals(failure.index())) continue;
                        ignoreShards.add(failure.shardId());
                    }
                }

                private boolean checkPartial(String index) {
                    if (RestoreService.this.failed(snapshot, index)) {
                        if (request.partial()) {
                            return true;
                        }
                        throw new SnapshotRestoreException(snapshotId, "index [" + index + "] wasn't fully snapshotted - cannot restore");
                    }
                    return false;
                }

                private void validateExistingIndex(IndexMetaData currentIndexMetaData, IndexMetaData snapshotIndexMetaData, String renamedIndex, boolean partial) {
                    if (currentIndexMetaData.getState() != IndexMetaData.State.CLOSE) {
                        throw new SnapshotRestoreException(snapshotId, "cannot restore index [" + renamedIndex + "] because it's open");
                    }
                    if (partial) {
                        throw new SnapshotRestoreException(snapshotId, "cannot restore partial index [" + renamedIndex + "] because such index already exists");
                    }
                    if (currentIndexMetaData.getNumberOfShards() != snapshotIndexMetaData.getNumberOfShards()) {
                        throw new SnapshotRestoreException(snapshotId, "cannot restore index [" + renamedIndex + "] with [" + currentIndexMetaData.getNumberOfShards() + "] shard from snapshot with [" + snapshotIndexMetaData.getNumberOfShards() + "] shards");
                    }
                }

                private IndexMetaData updateIndexSettings(IndexMetaData indexMetaData, Settings changeSettings, String[] ignoreSettings) {
                    if (changeSettings.names().isEmpty() && ignoreSettings.length == 0) {
                        return indexMetaData;
                    }
                    Settings normalizedChangeSettings = Settings.settingsBuilder().put(changeSettings).normalizePrefix("index.").build();
                    IndexMetaData.Builder builder = IndexMetaData.builder(indexMetaData);
                    HashMap settingsMap = Maps.newHashMap(indexMetaData.getSettings().getAsMap());
                    ArrayList<String> simpleMatchPatterns = new ArrayList<String>();
                    for (String ignoredSetting : ignoreSettings) {
                        if (!Regex.isSimpleMatchPattern(ignoredSetting)) {
                            if (UNREMOVABLE_SETTINGS.contains((Object)ignoredSetting)) {
                                throw new SnapshotRestoreException(snapshotId, "cannot remove setting [" + ignoredSetting + "] on restore");
                            }
                            settingsMap.remove(ignoredSetting);
                            continue;
                        }
                        simpleMatchPatterns.add(ignoredSetting);
                    }
                    if (!simpleMatchPatterns.isEmpty()) {
                        String[] removePatterns = simpleMatchPatterns.toArray(new String[simpleMatchPatterns.size()]);
                        Iterator iterator = settingsMap.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            if (UNREMOVABLE_SETTINGS.contains(entry.getKey()) || !Regex.simpleMatch(removePatterns, (String)entry.getKey())) continue;
                            iterator.remove();
                        }
                    }
                    for (Map.Entry entry : normalizedChangeSettings.getAsMap().entrySet()) {
                        if (UNMODIFIABLE_SETTINGS.contains(entry.getKey())) {
                            throw new SnapshotRestoreException(snapshotId, "cannot modify setting [" + (String)entry.getKey() + "] on restore");
                        }
                        settingsMap.put(entry.getKey(), entry.getValue());
                    }
                    return builder.settings(Settings.builder().put(settingsMap)).build();
                }

                private void restoreGlobalStateIfRequested(MetaData.Builder mdBuilder) {
                    if (request.includeGlobalState()) {
                        if (metaData.persistentSettings() != null) {
                            boolean changed = false;
                            Settings.Builder persistentSettings = Settings.settingsBuilder().put(new Object[0]);
                            for (Map.Entry<String, String> entry : metaData.persistentSettings().getAsMap().entrySet()) {
                                if (RestoreService.this.dynamicSettings.isDynamicOrLoggingSetting(entry.getKey())) {
                                    String error = RestoreService.this.dynamicSettings.validateDynamicSetting(entry.getKey(), entry.getValue(), RestoreService.this.clusterService.state());
                                    if (error == null) {
                                        persistentSettings.put(entry.getKey(), entry.getValue());
                                        changed = true;
                                        continue;
                                    }
                                    RestoreService.this.logger.warn("ignoring persistent setting [{}], [{}]", entry.getKey(), error);
                                    continue;
                                }
                                RestoreService.this.logger.warn("ignoring persistent setting [{}], not dynamically updateable", entry.getKey());
                            }
                            if (changed) {
                                mdBuilder.persistentSettings(persistentSettings.build());
                            }
                        }
                        if (metaData.templates() != null) {
                            for (ObjectObjectCursor<String, MetaData.Custom> cursor : metaData.templates().values()) {
                                mdBuilder.put((IndexTemplateMetaData)cursor.value);
                            }
                        }
                        if (metaData.customs() != null) {
                            for (ObjectObjectCursor<String, MetaData.Custom> cursor : metaData.customs()) {
                                if ("repositories".equals(cursor.key)) continue;
                                mdBuilder.putCustom((String)cursor.key, (MetaData.Custom)cursor.value);
                            }
                        }
                    }
                }

                @Override
                public void onFailure(String source, Throwable t) {
                    RestoreService.this.logger.warn("[{}] failed to restore snapshot", t, snapshotId);
                    listener.onFailure(t);
                }

                @Override
                public TimeValue timeout() {
                    return request.masterNodeTimeout();
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    listener.onResponse(this.restoreInfo);
                }
            });
        }
        catch (Throwable e) {
            this.logger.warn("[{}][{}] failed to restore snapshot", e, request.repository(), request.name());
            listener.onFailure(e);
        }
    }

    public void indexShardRestoreCompleted(SnapshotId snapshotId, ShardId shardId) {
        this.logger.trace("[{}] successfully restored shard  [{}]", snapshotId, shardId);
        UpdateIndexShardRestoreStatusRequest request = new UpdateIndexShardRestoreStatusRequest(snapshotId, shardId, new RestoreInProgress.ShardRestoreStatus(this.clusterService.state().nodes().localNodeId(), RestoreInProgress.State.SUCCESS));
        this.transportService.sendRequest(this.clusterService.state().nodes().masterNode(), UPDATE_RESTORE_ACTION_NAME, request, EmptyTransportResponseHandler.INSTANCE_SAME);
    }

    private void updateRestoreStateOnMaster(final UpdateIndexShardRestoreStatusRequest request) {
        this.logger.trace("received updated snapshot restore state [{}]", request);
        this.updatedSnapshotStateQueue.add(request);
        this.clusterService.submitStateUpdateTask("update snapshot state", new ClusterStateUpdateTask(){
            private final List<UpdateIndexShardRestoreStatusRequest> drainedRequests = new ArrayList<UpdateIndexShardRestoreStatusRequest>();
            private Map<SnapshotId, Tuple<RestoreInfo, Map<ShardId, RestoreInProgress.ShardRestoreStatus>>> batchedRestoreInfo = null;

            @Override
            public ClusterState execute(ClusterState currentState) {
                if (request.processed) {
                    return currentState;
                }
                RestoreService.this.updatedSnapshotStateQueue.drainTo(this.drainedRequests);
                int batchSize = this.drainedRequests.size();
                if (batchSize == 0) {
                    return currentState;
                }
                RestoreInProgress restore = (RestoreInProgress)currentState.custom("restore");
                if (restore != null) {
                    int changedCount = 0;
                    ArrayList<RestoreInProgress.Entry> entries = new ArrayList<RestoreInProgress.Entry>();
                    for (RestoreInProgress.Entry entry : restore.entries()) {
                        Map shards = null;
                        for (int i = 0; i < batchSize; ++i) {
                            UpdateIndexShardRestoreStatusRequest updateSnapshotState = this.drainedRequests.get(i);
                            updateSnapshotState.processed = true;
                            if (!entry.snapshotId().equals(updateSnapshotState.snapshotId())) continue;
                            RestoreService.this.logger.trace("[{}] Updating shard [{}] with status [{}]", new Object[]{updateSnapshotState.snapshotId(), updateSnapshotState.shardId(), updateSnapshotState.status().state()});
                            if (shards == null) {
                                shards = Maps.newHashMap(entry.shards());
                            }
                            shards.put(updateSnapshotState.shardId(), updateSnapshotState.status());
                            ++changedCount;
                        }
                        if (shards != null) {
                            if (!RestoreService.this.completed(shards)) {
                                entries.add(new RestoreInProgress.Entry(entry.snapshotId(), RestoreInProgress.State.STARTED, entry.indices(), (ImmutableMap<ShardId, RestoreInProgress.ShardRestoreStatus>)ImmutableMap.copyOf(shards)));
                                continue;
                            }
                            RestoreService.this.logger.info("restore [{}] is done", entry.snapshotId());
                            if (this.batchedRestoreInfo == null) {
                                this.batchedRestoreInfo = Maps.newHashMap();
                            }
                            assert (!this.batchedRestoreInfo.containsKey(entry.snapshotId()));
                            this.batchedRestoreInfo.put(entry.snapshotId(), new Tuple<RestoreInfo, Map>(new RestoreInfo(entry.snapshotId().getSnapshot(), entry.indices(), shards.size(), shards.size() - RestoreService.this.failedShards(shards)), shards));
                            continue;
                        }
                        entries.add(entry);
                    }
                    if (changedCount > 0) {
                        RestoreService.this.logger.trace("changed cluster state triggered by {} snapshot restore state updates", changedCount);
                        RestoreInProgress updatedRestore = new RestoreInProgress(entries.toArray(new RestoreInProgress.Entry[entries.size()]));
                        return ClusterState.builder(currentState).putCustom("restore", updatedRestore).build();
                    }
                }
                return currentState;
            }

            @Override
            public void onFailure(String source, @Nullable Throwable t) {
                for (UpdateIndexShardRestoreStatusRequest request2 : this.drainedRequests) {
                    RestoreService.this.logger.warn("[{}][{}] failed to update snapshot status to [{}]", t, request2.snapshotId(), request2.shardId(), request2.status());
                }
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (this.batchedRestoreInfo != null) {
                    for (Map.Entry<SnapshotId, Tuple<RestoreInfo, Map<ShardId, RestoreInProgress.ShardRestoreStatus>>> entry : this.batchedRestoreInfo.entrySet()) {
                        final SnapshotId snapshotId = entry.getKey();
                        final RestoreInfo restoreInfo = entry.getValue().v1();
                        Map<ShardId, RestoreInProgress.ShardRestoreStatus> shards = entry.getValue().v2();
                        RoutingTable routingTable = newState.getRoutingTable();
                        final ArrayList<ShardId> waitForStarted = new ArrayList<ShardId>();
                        for (Map.Entry<ShardId, RestoreInProgress.ShardRestoreStatus> shard : shards.entrySet()) {
                            ShardId shardId;
                            ShardRouting shardRouting;
                            if (shard.getValue().state() != RestoreInProgress.State.SUCCESS || (shardRouting = this.findPrimaryShard(routingTable, shardId = shard.getKey())) == null || shardRouting.active()) continue;
                            RestoreService.this.logger.trace("[{}][{}] waiting for the shard to start", snapshotId, shardId);
                            waitForStarted.add(shardId);
                        }
                        if (waitForStarted.isEmpty()) {
                            this.notifyListeners(snapshotId, restoreInfo);
                            continue;
                        }
                        RestoreService.this.clusterService.addLast(new ClusterStateListener(){

                            @Override
                            public void clusterChanged(ClusterChangedEvent event) {
                                if (event.routingTableChanged()) {
                                    RoutingTable routingTable = event.state().getRoutingTable();
                                    Iterator iterator = waitForStarted.iterator();
                                    while (iterator.hasNext()) {
                                        ShardId shardId = (ShardId)iterator.next();
                                        ShardRouting shardRouting = this.findPrimaryShard(routingTable, shardId);
                                        if (shardRouting != null && !shardRouting.active()) continue;
                                        iterator.remove();
                                        RestoreService.this.logger.trace("[{}][{}] shard disappeared or started - removing", snapshotId, shardId);
                                    }
                                }
                                if (waitForStarted.isEmpty()) {
                                    this.notifyListeners(snapshotId, restoreInfo);
                                    RestoreService.this.clusterService.remove(this);
                                }
                            }
                        });
                    }
                }
            }

            private ShardRouting findPrimaryShard(RoutingTable routingTable, ShardId shardId) {
                IndexShardRoutingTable indexShardRoutingTable;
                IndexRoutingTable indexRoutingTable = routingTable.index(shardId.getIndex());
                if (indexRoutingTable != null && (indexShardRoutingTable = indexRoutingTable.shard(shardId.id())) != null) {
                    return indexShardRoutingTable.primaryShard();
                }
                return null;
            }

            private void notifyListeners(SnapshotId snapshotId, RestoreInfo restoreInfo) {
                for (ActionListener listener : RestoreService.this.listeners) {
                    try {
                        listener.onResponse(new RestoreCompletionResponse(snapshotId, restoreInfo));
                    }
                    catch (Throwable e) {
                        RestoreService.this.logger.warn("failed to update snapshot status for [{}]", e, listener);
                    }
                }
            }
        });
    }

    private boolean completed(Map<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        for (RestoreInProgress.ShardRestoreStatus status : shards.values()) {
            if (status.state().completed()) continue;
            return false;
        }
        return true;
    }

    private int failedShards(Map<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        int failedShards = 0;
        for (RestoreInProgress.ShardRestoreStatus status : shards.values()) {
            if (status.state() != RestoreInProgress.State.FAILURE) continue;
            ++failedShards;
        }
        return failedShards;
    }

    private Map<String, String> renamedIndices(RestoreRequest request, List<String> filteredIndices) {
        HashMap renamedIndices = Maps.newHashMap();
        Iterator<String> iterator = filteredIndices.iterator();
        while (iterator.hasNext()) {
            String previousIndex;
            String index;
            String renamedIndex = index = iterator.next();
            if (request.renameReplacement() != null && request.renamePattern() != null) {
                renamedIndex = index.replaceAll(request.renamePattern(), request.renameReplacement());
            }
            if ((previousIndex = renamedIndices.put(renamedIndex, index)) == null) continue;
            throw new SnapshotRestoreException(new SnapshotId(request.repository(), request.name()), "indices [" + index + "] and [" + previousIndex + "] are renamed into the same index [" + renamedIndex + "]");
        }
        return renamedIndices;
    }

    private void validateSnapshotRestorable(SnapshotId snapshotId, Snapshot snapshot) {
        if (!snapshot.state().restorable()) {
            throw new SnapshotRestoreException(snapshotId, "unsupported snapshot state [" + (Object)((Object)snapshot.state()) + "]");
        }
        if (Version.CURRENT.before(snapshot.version())) {
            throw new SnapshotRestoreException(snapshotId, "the snapshot was created with Elasticsearch version [" + snapshot.version() + "] which is higher than the version of this node [" + Version.CURRENT + "]");
        }
    }

    private void processDeletedIndices(ClusterChangedEvent event) {
        RestoreInProgress restore = (RestoreInProgress)event.state().custom("restore");
        if (restore == null) {
            return;
        }
        if (!event.indicesDeleted().isEmpty()) {
            for (RestoreInProgress.Entry entry : restore.entries()) {
                ArrayList shardsToFail = null;
                for (Map.Entry shard : entry.shards().entrySet()) {
                    if (((RestoreInProgress.ShardRestoreStatus)shard.getValue()).state().completed() || event.state().metaData().hasIndex(((ShardId)shard.getKey()).getIndex())) continue;
                    if (shardsToFail == null) {
                        shardsToFail = new ArrayList();
                    }
                    shardsToFail.add(shard.getKey());
                }
                if (shardsToFail == null) continue;
                for (ShardId shardId : shardsToFail) {
                    this.logger.trace("[{}] failing running shard restore [{}]", entry.snapshotId(), shardId);
                    this.updateRestoreStateOnMaster(new UpdateIndexShardRestoreStatusRequest(entry.snapshotId(), shardId, new RestoreInProgress.ShardRestoreStatus(null, RestoreInProgress.State.FAILURE, "index was deleted")));
                }
            }
        }
    }

    public void failRestore(SnapshotId snapshotId, ShardId shardId) {
        this.logger.debug("[{}] failed to restore shard  [{}]", snapshotId, shardId);
        UpdateIndexShardRestoreStatusRequest request = new UpdateIndexShardRestoreStatusRequest(snapshotId, shardId, new RestoreInProgress.ShardRestoreStatus(this.clusterService.state().nodes().localNodeId(), RestoreInProgress.State.FAILURE));
        this.transportService.sendRequest(this.clusterService.state().nodes().masterNode(), UPDATE_RESTORE_ACTION_NAME, request, EmptyTransportResponseHandler.INSTANCE_SAME);
    }

    private boolean failed(Snapshot snapshot, String index) {
        for (SnapshotShardFailure failure : snapshot.shardFailures()) {
            if (!index.equals(failure.index())) continue;
            return true;
        }
        return false;
    }

    public void addListener(ActionListener<RestoreCompletionResponse> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ActionListener<RestoreCompletionResponse> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        try {
            if (event.localNodeMaster()) {
                this.processDeletedIndices(event);
            }
        }
        catch (Throwable t) {
            this.logger.warn("Failed to update restore state ", t, new Object[0]);
        }
    }

    public static boolean isRepositoryInUse(ClusterState clusterState, String repository) {
        RestoreInProgress snapshots = (RestoreInProgress)clusterState.custom("restore");
        if (snapshots != null) {
            for (RestoreInProgress.Entry snapshot : snapshots.entries()) {
                if (!repository.equals(snapshot.snapshotId().getRepository())) continue;
                return true;
            }
        }
        return false;
    }

    class UpdateRestoreStateRequestHandler
    extends TransportRequestHandler<UpdateIndexShardRestoreStatusRequest> {
        UpdateRestoreStateRequestHandler() {
        }

        @Override
        public void messageReceived(UpdateIndexShardRestoreStatusRequest request, TransportChannel channel) throws Exception {
            RestoreService.this.updateRestoreStateOnMaster(request);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    public static class UpdateIndexShardRestoreStatusRequest
    extends TransportRequest {
        private SnapshotId snapshotId;
        private ShardId shardId;
        private RestoreInProgress.ShardRestoreStatus status;
        volatile boolean processed;

        public UpdateIndexShardRestoreStatusRequest() {
        }

        private UpdateIndexShardRestoreStatusRequest(SnapshotId snapshotId, ShardId shardId, RestoreInProgress.ShardRestoreStatus status) {
            this.snapshotId = snapshotId;
            this.shardId = shardId;
            this.status = status;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.snapshotId = SnapshotId.readSnapshotId(in);
            this.shardId = ShardId.readShardId(in);
            this.status = RestoreInProgress.ShardRestoreStatus.readShardRestoreStatus(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.snapshotId.writeTo(out);
            this.shardId.writeTo(out);
            this.status.writeTo(out);
        }

        public SnapshotId snapshotId() {
            return this.snapshotId;
        }

        public ShardId shardId() {
            return this.shardId;
        }

        public RestoreInProgress.ShardRestoreStatus status() {
            return this.status;
        }

        public String toString() {
            return "" + this.snapshotId + ", shardId [" + this.shardId + "], status [" + (Object)((Object)this.status.state()) + "]";
        }
    }

    public static class RestoreRequest {
        private final String cause;
        private final String name;
        private final String repository;
        private final String[] indices;
        private final String renamePattern;
        private final String renameReplacement;
        private final IndicesOptions indicesOptions;
        private final Settings settings;
        private final TimeValue masterNodeTimeout;
        private final boolean includeGlobalState;
        private final boolean partial;
        private final boolean includeAliases;
        private final Settings indexSettings;
        private final String[] ignoreIndexSettings;

        public RestoreRequest(String cause, String repository, String name, String[] indices, IndicesOptions indicesOptions, String renamePattern, String renameReplacement, Settings settings, TimeValue masterNodeTimeout, boolean includeGlobalState, boolean partial, boolean includeAliases, Settings indexSettings, String[] ignoreIndexSettings) {
            this.cause = cause;
            this.name = name;
            this.repository = repository;
            this.indices = indices;
            this.renamePattern = renamePattern;
            this.renameReplacement = renameReplacement;
            this.indicesOptions = indicesOptions;
            this.settings = settings;
            this.masterNodeTimeout = masterNodeTimeout;
            this.includeGlobalState = includeGlobalState;
            this.partial = partial;
            this.includeAliases = includeAliases;
            this.indexSettings = indexSettings;
            this.ignoreIndexSettings = ignoreIndexSettings;
        }

        public String cause() {
            return this.cause;
        }

        public String name() {
            return this.name;
        }

        public String repository() {
            return this.repository;
        }

        public String[] indices() {
            return this.indices;
        }

        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public String renamePattern() {
            return this.renamePattern;
        }

        public String renameReplacement() {
            return this.renameReplacement;
        }

        public Settings settings() {
            return this.settings;
        }

        public boolean includeGlobalState() {
            return this.includeGlobalState;
        }

        public boolean partial() {
            return this.partial;
        }

        public boolean includeAliases() {
            return this.includeAliases;
        }

        public Settings indexSettings() {
            return this.indexSettings;
        }

        public String[] ignoreIndexSettings() {
            return this.ignoreIndexSettings;
        }

        public TimeValue masterNodeTimeout() {
            return this.masterNodeTimeout;
        }
    }

    public static final class RestoreCompletionResponse {
        private final SnapshotId snapshotId;
        private final RestoreInfo restoreInfo;

        private RestoreCompletionResponse(SnapshotId snapshotId, RestoreInfo restoreInfo) {
            this.snapshotId = snapshotId;
            this.restoreInfo = restoreInfo;
        }

        public SnapshotId getSnapshotId() {
            return this.snapshotId;
        }

        public RestoreInfo getRestoreInfo() {
            return this.restoreInfo;
        }
    }
}

