/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class PersistentByteMap {
    private MappedByteBuffer buf;
    private static final int MAGIC = 0;
    private static final int VERSION = 4;
    private static final int CAPACITY = 8;
    private static final int TABLE_BASE = 12;
    private static final int STRING_BASE = 16;
    private static final int STRING_SIZE = 20;
    private static final int FILE_SIZE = 24;
    private static final int ELEMENTS = 28;
    private static final int INT_SIZE = 4;
    private static final int TABLE_ENTRY_SIZE = 8;
    private int capacity;
    private int table_base;
    private int string_base;
    private int string_size;
    private int file_size;
    private int elements;
    private long length;
    private final File name;
    private static final int UNUSED_ENTRY = -1;
    public static final int KEYS = 0;
    public static final int VALUES = 1;
    public static final int ENTRIES = 2;
    private HashMap values;
    FileChannel fc;

    private PersistentByteMap(File name) {
        this.name = name;
    }

    public PersistentByteMap(String filename, AccessMode mode) throws IOException {
        this(new File(filename), mode);
    }

    public PersistentByteMap(File f, AccessMode mode) throws IOException {
        this.name = f;
        if (mode == AccessMode.READ_ONLY) {
            FileInputStream fis = new FileInputStream(f);
            this.fc = fis.getChannel();
        } else {
            RandomAccessFile fos = new RandomAccessFile(f, "rw");
            this.fc = fos.getChannel();
        }
        this.length = this.fc.size();
        this.buf = this.fc.map(mode.mapMode, 0L, this.length);
        int magic = this.getWord(0);
        if (magic != 1734568548) {
            throw new IllegalArgumentException(f.getName());
        }
        this.table_base = this.getWord(12);
        this.capacity = this.getWord(8);
        this.string_base = this.getWord(16);
        this.string_size = this.getWord(20);
        this.file_size = this.getWord(24);
        this.elements = this.getWord(28);
    }

    private void init(PersistentByteMap m, File f, int capacity, int strtabSize) throws IOException {
        f.createNewFile();
        RandomAccessFile raf = new RandomAccessFile(f, "rw");
        BigInteger size = new BigInteger(Integer.toString((capacity * 3 + 1) / 2));
        BigInteger two = BigInteger.ONE.add(BigInteger.ONE);
        if (size.getLowestSetBit() != 0) {
            size = size.add(BigInteger.ONE);
        }
        while (!size.isProbablePrime(10)) {
            size = size.add(two);
        }
        this.capacity = capacity = size.intValue();
        this.table_base = 64;
        this.string_base = this.table_base + capacity * 8;
        this.string_size = 0;
        this.file_size = this.string_base;
        this.elements = 0;
        int totalFileSize = this.string_base + strtabSize;
        byte[] _4k = new byte[4096];
        long i = 0L;
        while (i < (long)totalFileSize) {
            raf.write(_4k);
            i += 4096L;
        }
        this.fc = raf.getChannel();
        this.buf = this.fc.map(FileChannel.MapMode.READ_WRITE, 0L, raf.length());
        int i2 = 0;
        while (i2 < capacity) {
            this.putKeyPos(-1, i2);
            ++i2;
        }
        this.putWord(1734568548, 0);
        this.putWord(1, 4);
        this.putWord(capacity, 8);
        this.putWord(this.table_base, 12);
        this.putWord(this.string_base, 16);
        this.putWord(this.file_size, 24);
        this.putWord(this.elements, 28);
        this.buf.force();
        this.length = this.fc.size();
        this.string_size = 0;
    }

    public static PersistentByteMap emptyPersistentByteMap(File name, int capacity, int strtabSize) throws IOException {
        PersistentByteMap m = new PersistentByteMap(name);
        m.init(m, name, capacity, strtabSize);
        return m;
    }

    private int getWord(int index) {
        this.buf.position(index);
        byte[] wordBuf = new byte[4];
        this.buf.get(wordBuf);
        int result = wordBuf[0] & 0xFF;
        result += (wordBuf[1] & 0xFF) << 8;
        result += (wordBuf[2] & 0xFF) << 16;
        return result += (wordBuf[3] & 0xFF) << 24;
    }

    private void putWord(int word, int index) {
        this.buf.position(index);
        byte[] wordBuf = new byte[]{(byte)word, (byte)(word >>> 8), (byte)(word >>> 16), (byte)(word >>> 24)};
        this.buf.put(wordBuf);
    }

    public Set entrySet() {
        return null;
    }

    private int getBucket(int n) {
        return this.table_base + 2 * n * 4;
    }

    private int getKeyPos(int n) {
        return this.getWord(this.getBucket(n));
    }

    private int getValuePos(int n) {
        return this.getWord(this.getBucket(n) + 4);
    }

    private void putKeyPos(int index, int n) {
        this.putWord(index, this.getBucket(n));
    }

    private void putValuePos(int index, int n) {
        this.putWord(index, this.getBucket(n) + 4);
    }

    private byte[] getBytes(int n) {
        int len = this.getWord(this.string_base + n);
        int base = this.string_base + n + 4;
        byte[] key = new byte[len];
        this.buf.position(base);
        this.buf.get(key, 0, len);
        return key;
    }

    private int hash(byte[] b) {
        long hashIndex = ((long)b[0] & 0xFFL) + (((long)b[1] & 0xFFL) << 8) + (((long)b[2] & 0xFFL) << 16) + (((long)b[3] & 0xFFL) << 24);
        long result = hashIndex % (long)this.capacity;
        return (int)result;
    }

    public byte[] get(byte[] digest) {
        int hashIndex = this.hash(digest);
        int k;
        while ((k = this.getKeyPos(hashIndex)) != -1) {
            if (Arrays.equals(digest, this.getBytes(k))) {
                return this.getBytes(this.getValuePos(hashIndex));
            }
            ++hashIndex;
            hashIndex %= this.capacity;
        }
        return null;
    }

    public void put(byte[] digest, byte[] value) throws IllegalAccessException {
        int hashIndex = this.hash(digest);
        if (this.elements >= this.capacity()) {
            throw new IllegalAccessException("Table Full: " + this.elements);
        }
        while (true) {
            int k;
            if ((k = this.getKeyPos(hashIndex)) == -1) {
                int newKey = this.addBytes(digest);
                this.putKeyPos(newKey, hashIndex);
                int newValue = this.addBytes(value);
                this.putValuePos(newValue, hashIndex);
                ++this.elements;
                this.putWord(this.elements, 28);
                return;
            }
            if (Arrays.equals(digest, this.getBytes(k))) {
                int newValue = this.addBytes(value);
                this.putValuePos(newValue, hashIndex);
                return;
            }
            ++hashIndex;
            hashIndex %= this.capacity;
        }
    }

    private int addBytes(byte[] data) throws IllegalAccessException {
        int extent;
        if (data.length > 16) {
            Object result;
            if (this.values == null) {
                this.values = new HashMap();
                int i = 0;
                while (i < this.capacity) {
                    if (this.getKeyPos(i) != -1) {
                        int pos = this.getValuePos(i);
                        ByteWrapper bytes = new ByteWrapper(this.getBytes(pos));
                        this.values.put(bytes, new Integer(pos));
                    }
                    ++i;
                }
            }
            if ((result = this.values.get(new ByteWrapper(data))) != null) {
                return (Integer)result;
            }
        }
        if ((long)(data.length + 4) >= this.length) {
            throw new IllegalAccessException("String table Full");
        }
        int top = extent = this.string_base + this.string_size;
        this.putWord(data.length, extent);
        this.buf.position(extent += 4);
        this.buf.put(data, 0, data.length);
        extent += data.length;
        extent += 3;
        this.string_size = (extent &= 0xFFFFFFFC) - this.string_base;
        this.file_size = extent;
        this.putWord(this.string_size, 20);
        this.putWord(this.file_size, 24);
        if (data.length > 16) {
            this.values.put(new ByteWrapper(data), new Integer(top - this.string_base));
        }
        return top - this.string_base;
    }

    public Iterator iterator(int type) {
        return new HashIterator(type);
    }

    public int size() {
        return this.elements;
    }

    public int stringTableSize() {
        return this.string_size;
    }

    public int capacity() {
        return this.capacity * 2 / 3;
    }

    public void force() {
        this.buf.force();
    }

    public File getFile() {
        return this.name;
    }

    public void close() throws IOException {
        this.force();
        this.fc.close();
    }

    public void putAll(PersistentByteMap t) throws IllegalAccessException {
        if (this.elements == 0 && t.capacity == this.capacity && t.length == this.length) {
            this.buf.position(0);
            t.buf.position(0);
            this.buf.put(t.buf);
            this.table_base = t.table_base;
            this.string_base = t.string_base;
            this.string_size = t.string_size;
            this.file_size = t.file_size;
            this.elements = t.elements;
            if (t.values != null) {
                this.values = (HashMap)t.values.clone();
            }
            return;
        }
        Iterator iterator = t.iterator(2);
        while (iterator.hasNext()) {
            MapEntry entry = (MapEntry)iterator.next();
            this.put((byte[])entry.getKey(), (byte[])entry.getValue());
        }
    }

    public static final class AccessMode {
        private final FileChannel.MapMode mapMode;
        public static final AccessMode READ_ONLY = new AccessMode(FileChannel.MapMode.READ_ONLY);
        public static final AccessMode READ_WRITE = new AccessMode(FileChannel.MapMode.READ_WRITE);
        public static final AccessMode PRIVATE = new AccessMode(FileChannel.MapMode.PRIVATE);

        private AccessMode(FileChannel.MapMode mode) {
            this.mapMode = mode;
        }
    }

    private final class ByteWrapper {
        final byte[] bytes;
        final int hash;

        public ByteWrapper(byte[] bytes) {
            int sum = 0;
            this.bytes = bytes;
            int i = 0;
            while (i < bytes.length) {
                sum += bytes[i];
                ++i;
            }
            this.hash = sum;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            return Arrays.equals(this.bytes, ((ByteWrapper)obj).bytes);
        }
    }

    private final class HashIterator
    implements Iterator {
        private int idx;
        private int count;
        private final int type;

        HashIterator(int type) {
            this.type = type;
            this.count = PersistentByteMap.this.elements;
            this.idx = 0;
        }

        public boolean hasNext() {
            return this.count > 0;
        }

        public Object next() {
            --this.count;
            int i = this.idx;
            while (i < PersistentByteMap.this.capacity) {
                if (PersistentByteMap.this.getKeyPos(i) != -1) {
                    this.idx = i + 1;
                    if (this.type == 1) {
                        return PersistentByteMap.this.getBytes(PersistentByteMap.this.getValuePos(i));
                    }
                    if (this.type == 0) {
                        return PersistentByteMap.this.getBytes(PersistentByteMap.this.getKeyPos(i));
                    }
                    return new MapEntry(i, PersistentByteMap.this.getBytes(PersistentByteMap.this.getKeyPos(i)), PersistentByteMap.this.getBytes(PersistentByteMap.this.getValuePos(i)));
                }
                ++i;
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class MapEntry {
        private final Object key;
        private final Object value;
        private final int bucket;

        public MapEntry(int bucket, Object newKey, Object newValue) {
            this.key = newKey;
            this.value = newValue;
            this.bucket = bucket;
        }

        public final Object getKey() {
            return this.key;
        }

        public final Object getValue() {
            return this.value;
        }

        public final int getBucket() {
            return this.bucket;
        }
    }
}

