/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Pointer;
import gnu.java.awt.image.ImageDecoder;
import gnu.java.awt.peer.gtk.CairoGraphics2D;
import gnu.java.awt.peer.gtk.CairoSurface;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class GdkPixbufDecoder
extends ImageDecoder {
    static Object pixbufLock;
    private final int native_state = GtkGenericPeer.getUniqueInteger();
    private boolean needsClose = false;
    Vector curr;
    private Pointer nativeDecoder;
    static final ColorModel cm;
    static ArrayList<ImageFormatSpec> imageFormatSpecs;
    private static GdkPixbufReaderSpi readerSpi;
    private static GdkPixbufWriterSpi writerSpi;

    static {
        System.loadLibrary("gtkpeer");
        GdkPixbufDecoder.initStaticState();
        pixbufLock = new Object();
        cm = new DirectColorModel(32, -16777216, 0xFF0000, 65280, 255);
    }

    static native void initStaticState();

    native void initState();

    native void pumpBytes(byte[] var1, int var2) throws IOException;

    native void pumpDone() throws IOException;

    native void finish(boolean var1);

    static native void streamImage(int[] var0, String var1, int var2, int var3, boolean var4, GdkPixbufWriter var5);

    public GdkPixbufDecoder(DataInput datainput) {
        super(datainput);
    }

    public GdkPixbufDecoder(InputStream in) {
        super(in);
    }

    public GdkPixbufDecoder(String filename) {
        super(filename);
    }

    public GdkPixbufDecoder(URL url) {
        super(url);
    }

    public GdkPixbufDecoder(byte[] imagedata, int imageoffset, int imagelength) {
        super(imagedata, imageoffset, imagelength);
    }

    void areaPrepared(int width, int height) {
        if (this.curr == null) {
            return;
        }
        int i = 0;
        while (i < this.curr.size()) {
            ImageConsumer ic = (ImageConsumer)this.curr.elementAt(i);
            ic.setDimensions(width, height);
            ic.setColorModel(cm);
            ic.setHints(1);
            ++i;
        }
    }

    void areaUpdated(int x, int y, int width, int height, int[] pixels, int scansize) {
        if (this.curr == null) {
            return;
        }
        int i = 0;
        while (i < this.curr.size()) {
            ImageConsumer ic = (ImageConsumer)this.curr.elementAt(i);
            ic.setPixels(x, y, width, height, cm, pixels, 0, scansize);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produce(Vector v, InputStream is) throws IOException {
        this.curr = v;
        byte[] bytes = new byte[4096];
        int len = 0;
        Object object = pixbufLock;
        synchronized (object) {
            this.initState();
        }
        this.needsClose = true;
        while ((len = is.read(bytes)) != -1) {
            object = pixbufLock;
            synchronized (object) {
                this.pumpBytes(bytes, len);
            }
        }
        object = pixbufLock;
        synchronized (object) {
            this.pumpDone();
        }
        this.needsClose = false;
        int i = 0;
        while (i < this.curr.size()) {
            ImageConsumer ic = (ImageConsumer)this.curr.elementAt(i);
            ic.imageComplete(3);
            ++i;
        }
        this.curr = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        Object object = pixbufLock;
        synchronized (object) {
            this.finish(this.needsClose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageFormatSpec registerFormat(String name, boolean writable) {
        ImageFormatSpec ifs = new ImageFormatSpec(name, writable);
        Class<GdkPixbufDecoder> clazz = GdkPixbufDecoder.class;
        synchronized (GdkPixbufDecoder.class) {
            if (imageFormatSpecs == null) {
                imageFormatSpecs = new ArrayList();
            }
            imageFormatSpecs.add(ifs);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return ifs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getFormatNames(boolean writable) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<ImageFormatSpec> arrayList = imageFormatSpecs;
        synchronized (arrayList) {
            for (ImageFormatSpec ifs : imageFormatSpecs) {
                if (writable && !ifs.writable) continue;
                names.add(ifs.name);
                Iterator j = ifs.extensions.iterator();
                while (j.hasNext()) {
                    names.add((String)j.next());
                }
            }
        }
        return names.toArray(new String[names.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getFormatExtensions(boolean writable) {
        ArrayList<String> extensions = new ArrayList<String>();
        ArrayList<ImageFormatSpec> arrayList = imageFormatSpecs;
        synchronized (arrayList) {
            for (ImageFormatSpec ifs : imageFormatSpecs) {
                if (writable && !ifs.writable) continue;
                Iterator j = ifs.extensions.iterator();
                while (j.hasNext()) {
                    extensions.add((String)j.next());
                }
            }
        }
        return extensions.toArray(new String[extensions.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getFormatMimeTypes(boolean writable) {
        ArrayList<String> mimeTypes = new ArrayList<String>();
        ArrayList<ImageFormatSpec> arrayList = imageFormatSpecs;
        synchronized (arrayList) {
            for (ImageFormatSpec ifs : imageFormatSpecs) {
                if (writable && !ifs.writable) continue;
                Iterator j = ifs.mimeTypes.iterator();
                while (j.hasNext()) {
                    mimeTypes.add((String)j.next());
                }
            }
        }
        return mimeTypes.toArray(new String[mimeTypes.size()]);
    }

    static String findFormatName(Object ext, boolean needWritable) {
        if (ext == null) {
            return null;
        }
        if (!(ext instanceof String)) {
            throw new IllegalArgumentException("extension is not a string");
        }
        String str = (String)ext;
        for (ImageFormatSpec ifs : imageFormatSpecs) {
            if (needWritable && !ifs.writable) continue;
            if (ifs.name.equals(str)) {
                return str;
            }
            for (String extension : ifs.extensions) {
                if (!extension.equals(str)) continue;
                return ifs.name;
            }
            for (String mimeType : ifs.mimeTypes) {
                if (!mimeType.equals(str)) continue;
                return ifs.name;
            }
        }
        throw new IllegalArgumentException("unknown extension '" + str + "'");
    }

    public static synchronized GdkPixbufReaderSpi getReaderSpi() {
        if (readerSpi == null) {
            readerSpi = new GdkPixbufReaderSpi();
        }
        return readerSpi;
    }

    public static synchronized GdkPixbufWriterSpi getWriterSpi() {
        if (writerSpi == null) {
            writerSpi = new GdkPixbufWriterSpi();
        }
        return writerSpi;
    }

    public static void registerSpis(IIORegistry reg) {
        reg.registerServiceProvider(GdkPixbufDecoder.getReaderSpi(), ImageReaderSpi.class);
        reg.registerServiceProvider(GdkPixbufDecoder.getWriterSpi(), ImageWriterSpi.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GdkPixbufReader
    extends ImageReader
    implements ImageConsumer {
        GdkPixbufDecoder dec;
        BufferedImage bufferedImage;
        ColorModel defaultModel;
        int width;
        int height;
        String ext;

        public GdkPixbufReader(GdkPixbufReaderSpi ownerSpi, Object ext) {
            super(ownerSpi);
            this.ext = GdkPixbufDecoder.findFormatName(ext, false);
        }

        public GdkPixbufReader(GdkPixbufReaderSpi ownerSpi, Object ext, GdkPixbufDecoder d) {
            this(ownerSpi, ext);
            this.dec = d;
        }

        @Override
        public void setDimensions(int w, int h) {
            this.processImageStarted(1);
            this.width = w;
            this.height = h;
        }

        public void setProperties(Hashtable props) {
        }

        @Override
        public void setColorModel(ColorModel model) {
            this.defaultModel = model;
        }

        @Override
        public void setHints(int flags) {
        }

        @Override
        public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int offset, int scansize) {
        }

        @Override
        public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize) {
            int[] pixels2;
            if (model == null) {
                model = this.defaultModel;
            }
            if (this.bufferedImage == null) {
                this.bufferedImage = model != null && model.hasAlpha() ? new BufferedImage(this.width, this.height, 2) : new BufferedImage(this.width, this.height, 1);
            }
            if (model != null) {
                pixels2 = new int[pixels.length];
                int yy = 0;
                while (yy < h) {
                    int xx = 0;
                    while (xx < w) {
                        int i = yy * scansize + xx;
                        pixels2[i] = model.getRGB(pixels[i]);
                        ++xx;
                    }
                    ++yy;
                }
            } else {
                pixels2 = pixels;
            }
            this.bufferedImage.setRGB(x, y, w, h, pixels2, offset, scansize);
            this.processImageProgress(y / (this.height == 0 ? 1 : this.height));
        }

        @Override
        public void imageComplete(int status) {
            this.processImageComplete();
        }

        public BufferedImage getBufferedImage() {
            if (this.bufferedImage == null && this.dec != null) {
                this.dec.startProduction(this);
            }
            return this.bufferedImage;
        }

        @Override
        public int getNumImages(boolean allowSearch) throws IOException {
            return 1;
        }

        @Override
        public IIOMetadata getImageMetadata(int i) {
            return null;
        }

        @Override
        public IIOMetadata getStreamMetadata() throws IOException {
            return null;
        }

        @Override
        public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
            BufferedImage img = this.getBufferedImage();
            Vector<ImageTypeSpecifier> vec = new Vector<ImageTypeSpecifier>();
            vec.add(new ImageTypeSpecifier(img));
            return vec.iterator();
        }

        @Override
        public int getHeight(int imageIndex) throws IOException {
            return this.getBufferedImage().getHeight();
        }

        @Override
        public int getWidth(int imageIndex) throws IOException {
            return this.getBufferedImage().getWidth();
        }

        @Override
        public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
            super.setInput(input, seekForwardOnly, ignoreMetadata);
            Object get = this.getInput();
            if (get instanceof InputStream) {
                this.dec = new GdkPixbufDecoder((InputStream)get);
            } else if (get instanceof DataInput) {
                this.dec = new GdkPixbufDecoder((DataInput)get);
            } else {
                throw new IllegalArgumentException("input object not supported: " + get);
            }
        }

        @Override
        public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
            return this.getBufferedImage();
        }
    }

    public static class GdkPixbufReaderSpi
    extends ImageReaderSpi {
        public GdkPixbufReaderSpi() {
            super("GdkPixbuf", "2.x", GdkPixbufDecoder.getFormatNames(false), GdkPixbufDecoder.getFormatExtensions(false), GdkPixbufDecoder.getFormatMimeTypes(false), "gnu.java.awt.peer.gtk.GdkPixbufDecoder$GdkPixbufReader", new Class[]{ImageInputStream.class}, new String[]{"gnu.java.awt.peer.gtk.GdkPixbufDecoder$GdkPixbufWriterSpi"}, false, null, null, null, null, false, null, null, null, null);
        }

        public boolean canDecodeInput(Object obj) {
            return true;
        }

        public ImageReader createReaderInstance(Object ext) {
            return new GdkPixbufReader(this, ext);
        }

        public String getDescription(Locale loc) {
            return "GdkPixbuf Reader SPI";
        }
    }

    private static class GdkPixbufWriter
    extends ImageWriter
    implements Runnable {
        String ext;
        private static final Object DATADONE = new Object();
        private ArrayList<Object> data = new ArrayList();
        private IOException exception;

        public GdkPixbufWriter(GdkPixbufWriterSpi ownerSpi, Object ext) {
            super(ownerSpi);
            this.ext = GdkPixbufDecoder.findFormatName(ext, true);
        }

        public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
            return null;
        }

        public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
            return null;
        }

        public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
            return null;
        }

        public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void write(IIOMetadata streamMetadata, IIOImage i, ImageWriteParam param) throws IOException {
            image = i.getRenderedImage();
            ras = image.getData();
            width = ras.getWidth();
            height = ras.getHeight();
            model = image.getColorModel();
            pixels = CairoGraphics2D.findSimpleIntegerArray(image.getColorModel(), ras);
            if (pixels == null) {
                if (model != null && model.hasAlpha()) {
                    var10_10 = CairoSurface.getBufferedImage(width, height);
                }
                img = new BufferedImage(width, height, 1);
                pix = new int[4];
                y = 0;
                while (y < height) {
                    x = 0;
                    while (x < width) {
                        img.setRGB(x, y, model.getRGB(ras.getPixel(x, y, pix)));
                        ++x;
                    }
                    ++y;
                }
                pixels = CairoGraphics2D.findSimpleIntegerArray(img.getColorModel(), img.getRaster());
                model = img.getColorModel();
            }
            workerThread = new Thread(this, "GdkPixbufWriter");
            workerThread.start();
            this.processImageStarted(1);
            var11_11 = GdkPixbufDecoder.pixbufLock;
            synchronized (var11_11) {
                GdkPixbufDecoder.streamImage(pixels, this.ext, width, height, model.hasAlpha(), this);
            }
            var11_11 = this.data;
            synchronized (var11_11) {
                this.data.add(GdkPixbufWriter.DATADONE);
                this.data.notifyAll();
                // MONITOREXIT @DISABLED, blocks:[1, 4] lbl41 : MonitorExitStatement: MONITOREXIT : var11_11
                if (true) ** GOTO lbl48
            }
            do {
                try {
                    workerThread.join();
                }
                catch (InterruptedException v2) {}
lbl48:
                // 3 sources

            } while (workerThread.isAlive());
            if (this.exception != null) {
                throw this.exception;
            }
            this.processImageComplete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void write(byte[] bs) {
            ArrayList<Object> arrayList = this.data;
            synchronized (arrayList) {
                this.data.add(bs);
                this.data.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            boolean done = false;
            while (!done) {
                ArrayList<Object> arrayList = this.data;
                synchronized (arrayList) {
                    block10: {
                        Object o;
                        while (true) {
                            if (!this.data.isEmpty()) {
                                o = this.data.remove(0);
                                if (o != DATADONE) break;
                                return;
                            }
                            try {
                                this.data.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        DataOutput out = (DataOutput)this.getOutput();
                        try {
                            out.write((byte[])o);
                        }
                        catch (IOException ioe) {
                            if (this.exception != null) break block10;
                            this.exception = ioe;
                        }
                    }
                }
            }
        }
    }

    public static class GdkPixbufWriterSpi
    extends ImageWriterSpi {
        public GdkPixbufWriterSpi() {
            super("GdkPixbuf", "2.x", GdkPixbufDecoder.getFormatNames(true), GdkPixbufDecoder.getFormatExtensions(true), GdkPixbufDecoder.getFormatMimeTypes(true), "gnu.java.awt.peer.gtk.GdkPixbufDecoder$GdkPixbufWriter", new Class[]{ImageOutputStream.class}, new String[]{"gnu.java.awt.peer.gtk.GdkPixbufDecoder$GdkPixbufReaderSpi"}, false, null, null, null, null, false, null, null, null, null);
        }

        public boolean canEncodeImage(ImageTypeSpecifier ts) {
            return true;
        }

        public ImageWriter createWriterInstance(Object ext) {
            return new GdkPixbufWriter(this, ext);
        }

        public String getDescription(Locale loc) {
            return "GdkPixbuf Writer SPI";
        }
    }

    public static class ImageFormatSpec {
        public String name;
        public boolean writable = false;
        public ArrayList<String> mimeTypes = new ArrayList();
        public ArrayList<String> extensions = new ArrayList();

        public ImageFormatSpec(String name, boolean writable) {
            this.name = name;
            this.writable = writable;
        }

        public synchronized void addMimeType(String m) {
            this.mimeTypes.add(m);
        }

        public synchronized void addExtension(String e) {
            this.extensions.add(e);
        }
    }
}

