/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.kwa;

import gnu.java.security.hash.Sha160;
import gnu.javax.crypto.assembly.Assembly;
import gnu.javax.crypto.assembly.Cascade;
import gnu.javax.crypto.assembly.Direction;
import gnu.javax.crypto.assembly.Stage;
import gnu.javax.crypto.assembly.Transformer;
import gnu.javax.crypto.assembly.TransformerException;
import gnu.javax.crypto.cipher.TripleDES;
import gnu.javax.crypto.kwa.BaseKeyWrappingAlgorithm;
import gnu.javax.crypto.kwa.KeyUnwrappingException;
import gnu.javax.crypto.mode.IMode;
import gnu.javax.crypto.mode.ModeFactory;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class TripleDESKeyWrap
extends BaseKeyWrappingAlgorithm {
    private static final byte[] DEFAULT_IV = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};
    private Assembly asm;
    private HashMap asmAttributes = new HashMap();
    private HashMap modeAttributes = new HashMap();
    private Sha160 sha = new Sha160();
    private SecureRandom rnd;

    public TripleDESKeyWrap() {
        super("kw-tripledes");
    }

    protected void engineInit(Map attributes) throws InvalidKeyException {
        this.rnd = (SecureRandom)attributes.get("gnu.crypto.kwa.prng");
        IMode des3CBC = ModeFactory.getInstance("cbc", new TripleDES(), 8);
        Stage des3CBCStage = Stage.getInstance(des3CBC, Direction.FORWARD);
        Cascade cascade = new Cascade();
        Object modeNdx = cascade.append(des3CBCStage);
        this.asmAttributes.put(modeNdx, this.modeAttributes);
        this.asm = new Assembly();
        this.asm.addPreTransformer(Transformer.getCascadeTransformer(cascade));
        this.modeAttributes.put("gnu.crypto.cipher.key.material", attributes.get("gnu.crypto.kwa.kek"));
        this.asmAttributes.put("gnu.crypto.assembly.assembly.direction", Direction.FORWARD);
    }

    protected byte[] engineWrap(byte[] in, int inOffset, int length) {
        byte[] result;
        byte[] TEMP1;
        if (length != 16 && length != 24) {
            throw new IllegalArgumentException("Only 2- and 3-key Triple DES keys are alowed");
        }
        byte[] CEK = new byte[24];
        if (length == 16) {
            System.arraycopy(in, inOffset, CEK, 0, 16);
            System.arraycopy(in, inOffset, CEK, 16, 8);
        } else {
            System.arraycopy(in, inOffset, CEK, 0, 24);
        }
        TripleDES.adjustParity(CEK, 0);
        this.sha.update(CEK);
        byte[] hash = this.sha.digest();
        byte[] ICV = new byte[8];
        System.arraycopy(hash, 0, ICV, 0, 8);
        byte[] CEKICV = new byte[CEK.length + ICV.length];
        System.arraycopy(CEK, 0, CEKICV, 0, CEK.length);
        System.arraycopy(ICV, 0, CEKICV, CEK.length, ICV.length);
        byte[] IV = new byte[8];
        this.nextRandomBytes(IV);
        this.modeAttributes.put("gnu.crypto.mode.iv", IV);
        this.asmAttributes.put("gnu.crypto.assembly.assembly.direction", Direction.FORWARD);
        try {
            this.asm.init(this.asmAttributes);
            TEMP1 = this.asm.lastUpdate(CEKICV);
        }
        catch (TransformerException x) {
            throw new RuntimeException(x);
        }
        byte[] TEMP2 = new byte[IV.length + TEMP1.length];
        System.arraycopy(IV, 0, TEMP2, 0, IV.length);
        System.arraycopy(TEMP1, 0, TEMP2, IV.length, TEMP1.length);
        byte[] TEMP3 = new byte[TEMP2.length];
        int i = 0;
        int j = TEMP2.length - 1;
        while (i < TEMP2.length) {
            TEMP3[j] = TEMP2[i];
            ++i;
            --j;
        }
        this.modeAttributes.put("gnu.crypto.mode.iv", DEFAULT_IV);
        this.asmAttributes.put("gnu.crypto.assembly.assembly.direction", Direction.FORWARD);
        try {
            this.asm.init(this.asmAttributes);
            result = this.asm.lastUpdate(TEMP3);
        }
        catch (TransformerException x) {
            throw new RuntimeException(x);
        }
        return result;
    }

    protected byte[] engineUnwrap(byte[] in, int inOffset, int length) throws KeyUnwrappingException {
        byte[] CEKICV;
        byte[] TEMP3;
        if (length != 40) {
            throw new IllegalArgumentException("length MUST be 40");
        }
        this.modeAttributes.put("gnu.crypto.mode.iv", DEFAULT_IV);
        this.asmAttributes.put("gnu.crypto.assembly.assembly.direction", Direction.REVERSED);
        try {
            this.asm.init(this.asmAttributes);
            TEMP3 = this.asm.lastUpdate(in, inOffset, 40);
        }
        catch (TransformerException x) {
            throw new RuntimeException(x);
        }
        byte[] TEMP2 = new byte[40];
        int i = 0;
        int j = 39;
        while (i < 40) {
            TEMP2[j] = TEMP3[i];
            ++i;
            --j;
        }
        byte[] IV = new byte[8];
        byte[] TEMP1 = new byte[32];
        System.arraycopy(TEMP2, 0, IV, 0, 8);
        System.arraycopy(TEMP2, 8, TEMP1, 0, 32);
        this.modeAttributes.put("gnu.crypto.mode.iv", IV);
        this.asmAttributes.put("gnu.crypto.assembly.assembly.direction", Direction.REVERSED);
        try {
            this.asm.init(this.asmAttributes);
            CEKICV = this.asm.lastUpdate(TEMP1, 0, 32);
        }
        catch (TransformerException x) {
            throw new RuntimeException(x);
        }
        byte[] CEK = new byte[24];
        byte[] ICV = new byte[8];
        System.arraycopy(CEKICV, 0, CEK, 0, 24);
        System.arraycopy(CEKICV, 24, ICV, 0, 8);
        this.sha.update(CEK);
        byte[] hash = this.sha.digest();
        byte[] computedICV = new byte[8];
        System.arraycopy(hash, 0, computedICV, 0, 8);
        if (!Arrays.equals(ICV, computedICV)) {
            throw new KeyUnwrappingException("ICV and computed ICV MUST match");
        }
        if (!TripleDES.isParityAdjusted(CEK, 0)) {
            throw new KeyUnwrappingException("Triple-DES key parity MUST be adjusted");
        }
        return CEK;
    }

    private void nextRandomBytes(byte[] buffer) {
        if (this.rnd != null) {
            this.rnd.nextBytes(buffer);
        } else {
            this.getDefaultPRNG().nextBytes(buffer);
        }
    }
}

