/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.stream.UnicodeReader;
import gnu.xml.stream.XMLParser;
import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class QNameType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{1, 2, 3, 4, 5, 6};

    QNameType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "QName"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String value, ValidationContext context) throws DatatypeException {
        String prefix;
        super.checkValid(value, context);
        int ci = -1;
        try {
            int[] cp = UnicodeReader.toCodePointArray(value);
            if (cp.length == 0) {
                throw new DatatypeException("invalid NCName value");
            }
            if (cp[0] == 58 || !XMLParser.isNameStartCharacter(cp[0], false)) {
                throw new DatatypeException(0, "invalid NCName value");
            }
            int i = 1;
            while (i < cp.length) {
                if (cp[i] == 58) {
                    if (ci != -1 || i + 1 == cp.length) {
                        throw new DatatypeException(i, "invalid NCName value");
                    }
                    ci = i;
                } else if (!XMLParser.isNameCharacter(cp[i], false)) {
                    throw new DatatypeException(i, "invalid NCName value");
                }
                ++i;
            }
        }
        catch (IOException e) {
            DatatypeException e2 = new DatatypeException("invalid NCName value");
            e2.initCause(e);
            throw e2;
        }
        if (ci != -1 && context.resolveNamespacePrefix(prefix = value.substring(0, ci)) == null) {
            throw new DatatypeException("invalid namespace prefix");
        }
    }

    public boolean isContextDependent() {
        return true;
    }
}

