/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import javax.crypto.Cipher;

public class EncryptedPrivateKeyInfo {
    private byte[] encryptedData;
    private byte[] encoded;
    private OID algOid;
    private String algName;
    private AlgorithmParameters params;
    private byte[] encodedParams;

    public EncryptedPrivateKeyInfo(AlgorithmParameters params, byte[] encryptedData) throws IllegalArgumentException, NoSuchAlgorithmException {
        if (encryptedData.length == 0) {
            throw new IllegalArgumentException("0-length encryptedData");
        }
        this.params = params;
        this.algName = params.getAlgorithm();
        this.algOid = EncryptedPrivateKeyInfo.getOid(this.algName);
        this.encryptedData = (byte[])encryptedData.clone();
    }

    public EncryptedPrivateKeyInfo(byte[] encoded) throws IOException {
        this.encoded = (byte[])encoded.clone();
        this.decode();
    }

    public EncryptedPrivateKeyInfo(String algName, byte[] encryptedData) throws IllegalArgumentException, NoSuchAlgorithmException, NullPointerException {
        if (encryptedData.length == 0) {
            throw new IllegalArgumentException("0-length encryptedData");
        }
        this.algName = algName.toString();
        this.algOid = EncryptedPrivateKeyInfo.getOid(algName);
        this.encryptedData = (byte[])encryptedData.clone();
    }

    private static OID getOid(String str) throws NoSuchAlgorithmException {
        if (str.equalsIgnoreCase("DSA")) {
            return new OID("1.2.840.10040.4.3");
        }
        try {
            return new OID(str);
        }
        catch (Throwable throwable) {
            throw new NoSuchAlgorithmException("cannot determine OID for '" + str + "'");
        }
    }

    public String getAlgName() {
        return this.algOid.toString();
    }

    public AlgorithmParameters getAlgParameters() {
        if (this.params == null && this.encodedParams != null) {
            try {
                this.params = AlgorithmParameters.getInstance(this.getAlgName());
                this.params.init(this.encodedParams);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (IOException iOException) {}
        }
        return this.params;
    }

    public synchronized byte[] getEncoded() throws IOException {
        if (this.encoded == null) {
            this.encode();
        }
        return (byte[])this.encoded.clone();
    }

    public byte[] getEncryptedData() {
        return this.encryptedData;
    }

    public PKCS8EncodedKeySpec getKeySpec(Cipher cipher) throws InvalidKeySpecException {
        try {
            return new PKCS8EncodedKeySpec(cipher.doFinal(this.encryptedData));
        }
        catch (Exception x) {
            throw new InvalidKeySpecException(x.toString());
        }
    }

    private void decode() throws IOException {
        DERReader der = new DERReader(this.encoded);
        DERValue val = der.read();
        if (val.getTag() != 16) {
            throw new IOException("malformed EncryptedPrivateKeyInfo");
        }
        val = der.read();
        if (val.getTag() != 16) {
            throw new IOException("malformed AlgorithmIdentifier");
        }
        int algpLen = val.getLength();
        DERValue oid = der.read();
        if (oid.getTag() != 6) {
            throw new IOException("malformed AlgorithmIdentifier");
        }
        this.algOid = (OID)oid.getValue();
        if (algpLen == 0) {
            val = der.read();
            if (val.getTag() != 0) {
                this.encodedParams = val.getEncoded();
                der.read();
            }
        } else if (oid.getEncodedLength() < val.getLength()) {
            val = der.read();
            this.encodedParams = val.getEncoded();
        }
        if ((val = der.read()).getTag() != 4) {
            throw new IOException("malformed AlgorithmIdentifier");
        }
        this.encryptedData = (byte[])val.getValue();
    }

    private void encode() throws IOException {
        ArrayList<DERValue> algId = new ArrayList<DERValue>(2);
        algId.add(new DERValue(6, this.algOid));
        this.getAlgParameters();
        if (this.params != null) {
            algId.add(DERReader.read(this.params.getEncoded()));
        } else {
            algId.add(new DERValue(5, null));
        }
        ArrayList<DERValue> epki = new ArrayList<DERValue>(2);
        epki.add(new DERValue(48, algId));
        epki.add(new DERValue(4, this.encryptedData));
        this.encoded = new DERValue(48, epki).getEncoded();
    }
}

