/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.InvalidOpenTypeException;
import javax.management.openmbean.KeyAlreadyExistsException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabularDataSupport
implements TabularData,
Serializable,
Cloneable,
Map<Object, Object> {
    private static final long serialVersionUID = 5720150593236309827L;
    private HashMap<Object, Object> dataMap;
    private TabularType tabularType;

    public TabularDataSupport(TabularType type) {
        this(type, 101, 0.75f);
    }

    public TabularDataSupport(TabularType type, int cap, float lf) {
        if (type == null) {
            throw new IllegalArgumentException("The type may not be null.");
        }
        this.tabularType = type;
        this.dataMap = new HashMap(cap, lf);
    }

    @Override
    public Object[] calculateIndex(CompositeData val) {
        if (!val.getCompositeType().equals(this.tabularType.getRowType())) {
            throw new InvalidOpenTypeException("The type of the given value does not match the row type of this instance.");
        }
        List<String> indexNames = this.tabularType.getIndexNames();
        ArrayList<String> matchingIndicies = new ArrayList<String>(indexNames.size());
        for (String name : indexNames) {
            matchingIndicies.add(val.get(name).toString());
        }
        return matchingIndicies.toArray();
    }

    @Override
    public void clear() {
        this.dataMap.clear();
    }

    public Object clone() {
        TabularDataSupport clone = null;
        try {
            clone = (TabularDataSupport)super.clone();
            clone.setMap((HashMap)this.dataMap.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Object[]) {
            return this.containsKey((Object[])key);
        }
        return false;
    }

    @Override
    public boolean containsKey(Object[] key) {
        if (key == null) {
            return false;
        }
        if (!this.isKeyValid(key)) {
            return false;
        }
        return this.dataMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object val) {
        if (val instanceof CompositeData) {
            return this.containsValue((CompositeData)val);
        }
        return false;
    }

    @Override
    public boolean containsValue(CompositeData val) {
        if (val == null) {
            return false;
        }
        if (!val.getCompositeType().equals(this.tabularType.getRowType())) {
            return false;
        }
        return this.dataMap.containsValue(val);
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.dataMap.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TabularData)) {
            return false;
        }
        TabularData data = (TabularData)obj;
        return this.tabularType.equals(data.getTabularType()) && this.dataMap.values().equals(data.values());
    }

    @Override
    public Object get(Object key) {
        return this.get((Object[])key);
    }

    @Override
    public CompositeData get(Object[] key) {
        if (!this.isKeyValid(key)) {
            throw new InvalidKeyException("The key does not match the tabular type of this instance.");
        }
        return (CompositeData)this.dataMap.get(key);
    }

    @Override
    public TabularType getTabularType() {
        return this.tabularType;
    }

    @Override
    public int hashCode() {
        return this.tabularType.hashCode() + this.dataMap.values().hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.dataMap.isEmpty();
    }

    private boolean isKeyValid(Object[] key) {
        Iterator<String> it = this.tabularType.getIndexNames().iterator();
        CompositeType rowType = this.tabularType.getRowType();
        int a = 0;
        while (it.hasNext()) {
            OpenType<?> type = rowType.getType(it.next());
            if (!type.isValue(key[a])) {
                return false;
            }
            ++a;
        }
        return true;
    }

    @Override
    public Set<Object> keySet() {
        return this.dataMap.keySet();
    }

    @Override
    public void put(CompositeData val) {
        Object[] key = this.calculateIndex(val);
        if (this.dataMap.containsKey(key)) {
            throw new KeyAlreadyExistsException("A value with this index already exists.");
        }
        this.dataMap.put(key, val);
    }

    @Override
    public Object put(Object key, Object val) {
        this.put((CompositeData)val);
        return val;
    }

    @Override
    public void putAll(CompositeData[] vals) {
        if (vals == null || vals.length == 0) {
            return;
        }
        HashMap<Object[], CompositeData> mapToAdd = new HashMap<Object[], CompositeData>(vals.length);
        int a = 0;
        while (a < vals.length) {
            Object[] key = this.calculateIndex(vals[a]);
            if (this.dataMap.containsKey(key)) {
                throw new KeyAlreadyExistsException("Element " + a + ": A " + "value with this index " + "already exists.");
            }
            mapToAdd.put(key, vals[a]);
            ++a;
        }
        this.dataMap.putAll(mapToAdd);
    }

    @Override
    public void putAll(Map<?, ?> m) {
        if (m == null || m.size() == 0) {
            return;
        }
        Collection<?> vals = m.values();
        CompositeData[] data = new CompositeData[vals.size()];
        Iterator<?> it = vals.iterator();
        int a = 0;
        while (it.hasNext()) {
            data[a] = (CompositeData)it.next();
            ++a;
        }
        this.putAll(data);
    }

    @Override
    public Object remove(Object key) {
        return this.remove((Object[])key);
    }

    @Override
    public CompositeData remove(Object[] key) {
        if (!this.isKeyValid(key)) {
            throw new InvalidKeyException("The key does not match the tabular type of this instance.");
        }
        return (CompositeData)this.dataMap.remove(key);
    }

    private void setMap(HashMap<Object, Object> map) {
        this.dataMap = map;
    }

    @Override
    public int size() {
        return this.dataMap.size();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[tabularType=" + this.tabularType + ",dataMap=" + this.dataMap + "]";
    }

    @Override
    public Collection<Object> values() {
        return this.dataMap.values();
    }
}

