/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import gnu.java.lang.CPStringBuilder;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableModel
implements TableModel,
Serializable {
    static final long serialVersionUID = -5798593159423650347L;
    protected EventListenerList listenerList = new EventListenerList();

    @Override
    public String getColumnName(int columnIndex) {
        CPStringBuilder buffer = new CPStringBuilder();
        while (columnIndex >= 0) {
            buffer.insert(0, (char)(65 + columnIndex % 26));
            columnIndex = columnIndex / 26 - 1;
        }
        return buffer.toString();
    }

    public int findColumn(String columnName) {
        int count = this.getColumnCount();
        int index = 0;
        while (index < count) {
            String name = this.getColumnName(index);
            if (columnName.equals(name)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        this.listenerList.add(TableModelListener.class, listener);
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        this.listenerList.remove(TableModelListener.class, listener);
    }

    public TableModelListener[] getTableModelListeners() {
        return (TableModelListener[])this.listenerList.getListeners(TableModelListener.class);
    }

    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this, 0, Integer.MAX_VALUE));
    }

    public void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    public void fireTableCellUpdated(int row, int column) {
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
    }

    public void fireTableChanged(TableModelEvent event) {
        Object[] list2 = this.listenerList.getListenerList();
        int index = 0;
        while (index < list2.length) {
            TableModelListener listener = (TableModelListener)list2[index + 1];
            listener.tableChanged(event);
            index += 2;
        }
    }

    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        return this.listenerList.getListeners(listenerType);
    }
}

