/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.appletextendedsecurity;

import net.sourceforge.jnlp.runtime.Translator;

public enum ExecuteAppletAction {
    ALWAYS,
    NEVER,
    YES,
    SANDBOX,
    NO,
    UNSET;


    public String toChar() {
        switch (this) {
            case ALWAYS: {
                return "A";
            }
            case NEVER: {
                return "N";
            }
            case YES: {
                return "y";
            }
            case SANDBOX: {
                return "s";
            }
            case NO: {
                return "n";
            }
            case UNSET: {
                return "X";
            }
        }
        throw new RuntimeException("Unknown ExecuteUnsignedApplet");
    }

    public String toExplanation() {
        switch (this) {
            case ALWAYS: {
                return Translator.R("APPEXTSECunsignedAppletActionAlways");
            }
            case NEVER: {
                return Translator.R("APPEXTSECunsignedAppletActionNever");
            }
            case YES: {
                return Translator.R("APPEXTSECunsignedAppletActionYes");
            }
            case SANDBOX: {
                return Translator.R("APPEXTSECunsignedAppletActionSandbox");
            }
            case NO: {
                return Translator.R("APPEXTSECunsignedAppletActionNo");
            }
            case UNSET: {
                return Translator.R("APPEXTSECunsetAppletAction");
            }
        }
        throw new RuntimeException("Unknown UnsignedAppletAction");
    }

    public static ExecuteAppletAction fromString(String s) {
        if (s.length() == 0) {
            throw new RuntimeException("Undefined zero-length ExecuteAppletAction String representatio");
        }
        return ExecuteAppletAction.fromChar(s.charAt(0));
    }

    public static ExecuteAppletAction fromChar(char s) {
        switch (s) {
            case 'A': {
                return ALWAYS;
            }
            case 'N': {
                return NEVER;
            }
            case 'y': {
                return YES;
            }
            case 's': {
                return SANDBOX;
            }
            case 'n': {
                return NO;
            }
            case 'X': {
                return UNSET;
            }
        }
        throw new RuntimeException("Unknown ExecuteUnsignedApplet for " + s);
    }

    public String toString() {
        return this.toChar() + " - " + this.toExplanation();
    }
}

